/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DriverLibraryLocal
extends DriverLibraryAbstract {
    private static final Log log = Log.getLog(DriverLibraryLocal.class);
    private boolean useOriginalJar;

    public DriverLibraryLocal(DriverDescriptor driver, DBPDriverLibrary.FileType type, String path) {
        super(driver, type, path);
    }

    public DriverLibraryLocal(DriverDescriptor driver, IConfigurationElement config) {
        super(driver, config);
    }

    public DriverLibraryLocal(DriverDescriptor driverDescriptor, DriverLibraryLocal copyFrom) {
        super(driverDescriptor, copyFrom);
    }

    @Override
    public DBPDriverLibrary copyLibrary(DriverDescriptor driverDescriptor) {
        return new DriverLibraryLocal(driverDescriptor, this);
    }

    public boolean isDownloadable() {
        return false;
    }

    public void resetVersion() {
    }

    public boolean isSecureDownload(@NotNull DBRProgressMonitor monitor) {
        return true;
    }

    protected String getLocalFilePath() {
        return this.path;
    }

    @Nullable
    public String getExternalURL(DBRProgressMonitor monitor) {
        return null;
    }

    @Nullable
    public Path getLocalFile() {
        String localFilePath = this.getLocalFilePath();
        if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            Path resolvedCache;
            List<DriverDescriptor.DriverFileInfo> driverFileInfos = this.driver.getResolvedFiles().get(this);
            if (!CommonUtils.isEmpty(driverFileInfos) && driverFileInfos.size() == 1) {
                DriverDescriptor.DriverFileInfo driverFileInfo = driverFileInfos.get(0);
                resolvedCache = this.resolveCacheDir().resolve(driverFileInfo.getFile());
            } else {
                resolvedCache = this.resolveCacheDir().resolve(localFilePath);
            }
            if (Files.exists(resolvedCache, new LinkOption[0])) {
                localFilePath = resolvedCache.toAbsolutePath().toString();
            }
        }
        Path platformFile = null;
        try {
            Path libraryFile = Path.of(localFilePath, new String[0]);
            if (Files.exists(libraryFile, new LinkOption[0])) {
                return libraryFile;
            }
            platformFile = this.detectLocalFile();
            if (platformFile != null && Files.exists(platformFile, new LinkOption[0])) {
                return platformFile;
            }
        }
        catch (InvalidPathException invalidPathException) {}
        URL url = this.driver.getProviderDescriptor().getContributorBundle().getEntry(localFilePath);
        if (url == null) {
            url = DataSourceProviderRegistry.getInstance().findResourceURL(localFilePath);
        }
        if (url != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException ex) {
                log.warn((Object)ex);
            }
            if (url != null) {
                return Path.of(url.getFile(), new String[0]);
            }
        } else {
            try {
                url = FileLocator.toFileURL((URL)new URL(localFilePath));
                Path urlFile = RuntimeUtils.getLocalPathFromURL((URL)url);
                if (Files.exists(urlFile, new LinkOption[0])) {
                    return urlFile;
                }
            }
            catch (IOException iOException) {}
        }
        return platformFile;
    }

    private Path resolveCacheDir() {
        if (this.isUseOriginalJar()) {
            return DriverDescriptor.getProvidedDriversStorageFolder();
        }
        if (DBWorkbench.isDistributed() || this.isCustom()) {
            return DriverDescriptor.getWorkspaceDriversStorageFolder();
        }
        return DriverDescriptor.getProvidedDriversStorageFolder();
    }

    @Nullable
    public Collection<? extends DBPDriverLibrary> getDependencies(@NotNull DBRProgressMonitor monitor) throws IOException {
        return null;
    }

    protected Path detectLocalFile() {
        String localPath = this.getLocalFilePath();
        Path file = null;
        try {
            file = RuntimeUtils.getLocalPathFromURL((URL)Platform.getInstallLocation().getURL()).resolve(localPath);
        }
        catch (IOException e) {
            log.warn((Object)"Error getting platform location", (Throwable)e);
        }
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            file = DriverDescriptor.getCustomDriversHome().resolve(localPath);
        }
        return file;
    }

    @NotNull
    public String getDisplayName() {
        return this.path;
    }

    @NotNull
    public String getId() {
        return this.path;
    }

    @NotNull
    public DBIcon getIcon() {
        Path localFile = this.getLocalFile();
        if (localFile != null && Files.isDirectory(localFile, new LinkOption[0])) {
            return DBIcon.TREE_FOLDER_ADMIN;
        }
        switch (this.type) {
            case lib: {
                return DBIcon.LIBRARY;
            }
            case jar: {
                return DBIcon.JAR;
            }
            case license: {
                return DBIcon.TYPE_TEXT;
            }
        }
        return DBIcon.TYPE_UNKNOWN;
    }

    public boolean isUseOriginalJar() {
        return this.useOriginalJar;
    }

    public void setUseOriginalJar(boolean useOriginalJar) {
        this.useOriginalJar = useOriginalJar;
    }
}

