/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.NativeClientDistributionDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class NativeClientDescriptor
extends AbstractDescriptor {
    private final List<NativeClientDistributionDescriptor> distributions = new ArrayList<NativeClientDistributionDescriptor>();
    private String id;
    private String label;

    NativeClientDescriptor(IConfigurationElement config) {
        super(config.getContributor().getName());
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("dist");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement clientElement = iConfigurationElementArray[n2];
            this.distributions.add(new NativeClientDistributionDescriptor(clientElement));
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    private boolean isClientsPathVirtualizedByWindows(Path clientFile) {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        return application.isStandalone() && !application.isHeadlessMode() && RuntimeUtils.isWindowsStoreApplication() && clientFile.startsWith(System.getenv("AppData"));
    }

    public NativeClientDistributionDescriptor findDistribution() {
        OSDescriptor localSystem = DBWorkbench.getPlatform().getLocalSystem();
        Path driversHome = DriverDescriptor.getCustomDriversHome().toAbsolutePath();
        for (NativeClientDistributionDescriptor distr : this.distributions) {
            if (!distr.getOs().matches(localSystem) || this.isClientsPathVirtualizedByWindows(driversHome.resolve(distr.getTargetPath()))) continue;
            return distr;
        }
        return null;
    }

    public String toString() {
        return this.id;
    }
}

