/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class BasePolicyDataProvider {
    private static final Log log = Log.getLog(BasePolicyDataProvider.class);
    private static final String DBEAVER_REGISTRY_POLICY_NODE = "Software\\DBeaver Corp\\DBeaver\\policy";
    private static final BasePolicyDataProvider INSTANCE = new BasePolicyDataProvider();

    @NotNull
    public static BasePolicyDataProvider getInstance() {
        return INSTANCE;
    }

    private BasePolicyDataProvider() {
    }

    public boolean isPolicyEnabled(@NotNull String propertyName) {
        return this.convertToBooleanValue(this.getPolicyProperty(propertyName));
    }

    @Nullable
    public String getPolicyValue(@NotNull String propertyName) {
        return this.getPolicyProperty(propertyName);
    }

    private boolean convertToBooleanValue(String value) {
        if (value == null || value.isBlank()) {
            return false;
        }
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equals("1");
    }

    @Nullable
    public String getPolicyProperty(@NotNull String property) {
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        value = BasePolicyDataProvider.getRegistryPolicyValue(WinReg.HKEY_CURRENT_USER, property);
        if (value != null) {
            return value;
        }
        value = BasePolicyDataProvider.getRegistryPolicyValue(WinReg.HKEY_LOCAL_MACHINE, property);
        return value;
    }

    @Nullable
    private static String getRegistryPolicyValue(@NotNull WinReg.HKEY root, @NotNull String property) {
        if (!RuntimeUtils.isWindows()) {
            return null;
        }
        try {
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)root, (String)DBEAVER_REGISTRY_POLICY_NODE) && Advapi32Util.registryValueExists((WinReg.HKEY)root, (String)DBEAVER_REGISTRY_POLICY_NODE, (String)property)) {
                return Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)DBEAVER_REGISTRY_POLICY_NODE, (String)property);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error reading Windows registry", e);
        }
        return null;
    }
}

