/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreGeometryValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;

public class RedshiftGeometryValueHandler
extends PostgreGeometryValueHandler {
    public static final RedshiftGeometryValueHandler INSTANCE = new RedshiftGeometryValueHandler();

    private RedshiftGeometryValueHandler() {
    }

    @Override
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, resultSet.getString(index), false, false);
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        int valueSRID = 0;
        if (value instanceof DBGeometry) {
            valueSRID = ((DBGeometry)value).getSRID();
            value = ((DBGeometry)value).getRawValue();
        }
        if (valueSRID == 0 && paramType instanceof GisAttribute) {
            valueSRID = ((GisAttribute)paramType).getAttributeGeometrySRID(session.getProgressMonitor());
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof Geometry) {
            if (((Geometry)value).getSRID() == 0) {
                ((Geometry)value).setSRID(valueSRID);
            }
            statement.setString(paramIndex, WKBWriter.toHex((byte[])new WKBWriter(3).write((Geometry)value)));
        } else {
            throw new DBCException("Can't bind geometry value " + String.valueOf(value));
        }
    }

    @Override
    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof DBGeometry) {
            return copy ? ((DBGeometry)object).copy() : object;
        }
        if (object instanceof Geometry) {
            return new DBGeometry((Geometry)object);
        }
        if (object instanceof byte[]) {
            return this.makeGeometryFromWKB((byte[])object);
        }
        if (object instanceof String) {
            try {
                return this.makeGeometryFromWKB((String)object);
            }
            catch (Exception exception) {
                return this.makeGeometryFromWKT(session, (String)object);
            }
        }
        return null;
    }
}

