/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.PostgreValueParser;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCArrayValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreArrayValueHandler
extends JDBCArrayValueHandler {
    public static final PostgreArrayValueHandler INSTANCE = new PostgreArrayValueHandler();
    private static final Log log = Log.getLog(PostgreArrayValueHandler.class);

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return super.fetchColumnValue(session, resultSet, type, index);
    }

    public DBDCollection getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object != null) {
            PostgreDataType arrayType = PostgreUtils.findDataType(session, (PostgreDataSource)session.getDataSource(), type);
            if (arrayType == null) {
                throw new DBCException("Can't resolve data type " + type.getFullTypeName());
            }
            PostgreDataType itemType = arrayType.getElementType(session.getProgressMonitor());
            if (itemType == null && arrayType.getTypeType() == PostgreTypeType.d) {
                itemType = arrayType.getBaseType(session.getProgressMonitor());
            }
            if (itemType == null) {
                throw new DBCException("Array type " + arrayType.getFullTypeName() + " doesn't have a component type");
            }
            String className = object.getClass().getName();
            if (object instanceof String || PostgreUtils.isPGObject(object) || className.equals("org.postgresql.jdbc.PgArray")) {
                if (className.equals("org.postgresql.jdbc.PgArray")) {
                    String strValue = object.toString();
                    return this.convertStringArrayToCollection(session, arrayType, itemType, strValue);
                }
                if (PostgreUtils.isPGObject(object)) {
                    Object[] objectArray;
                    Object value = PostgreUtils.extractPGObjectValue(object);
                    if (value instanceof String) {
                        return this.convertStringArrayToCollection(session, arrayType, itemType, (String)value);
                    }
                    log.error((Object)"Can't parse array");
                    DBRProgressMonitor dBRProgressMonitor = session.getProgressMonitor();
                    DBDValueHandler dBDValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType);
                    if (value == null) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = value;
                    }
                    return new JDBCCollection(dBRProgressMonitor, (DBSDataType)itemType, dBDValueHandler, objectArray);
                }
                return this.convertStringArrayToCollection(session, arrayType, itemType, (String)object);
            }
            if (object instanceof Object[]) {
                return new JDBCCollection(session.getProgressMonitor(), (DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), (Object[])object);
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value instanceof DBDCollection && !((DBDValue)value).isNull()) {
            statement.setObject(paramIndex, (Object)this.getValueDisplayString(paramType, value, DBDDisplayFormat.NATIVE), 1111);
        } else {
            super.bindParameter(session, statement, paramType, paramIndex, value);
        }
    }

    private JDBCCollection convertStringArrayToCollection(@NotNull DBCSession session, @NotNull PostgreDataType arrayType, @NotNull PostgreDataType itemType, @NotNull String strValue) throws DBCException {
        Object parsedArray = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)arrayType, strValue);
        if (parsedArray instanceof Object[]) {
            return new JDBCCollection(session.getProgressMonitor(), (DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), (Object[])parsedArray);
        }
        log.error((Object)"Can't parse array");
        return new JDBCCollection(session.getProgressMonitor(), (DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), new Object[]{parsedArray});
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (!DBUtils.isNullValue((Object)value) && value instanceof DBDCollection) {
            DBDCollection collection = (DBDCollection)value;
            StringJoiner output = new StringJoiner(PostgreUtils.getArrayDelimiter((DBSTypedObject)collection.getComponentType()), "{", "}");
            int i = 0;
            while (i < collection.getItemCount()) {
                String member;
                Object item = collection.getItem(i);
                if (item instanceof DBDCollection) {
                    member = PostgreArrayValueHandler.getArrayMemberDisplayString(column, (DBDValueHandler)this, item, format);
                } else {
                    PostgreDataType componentType = (PostgreDataType)collection.getComponentType();
                    DBDValueHandler componentHandler = collection.getComponentValueHandler();
                    member = PostgreArrayValueHandler.getArrayMemberDisplayString((DBSTypedObject)componentType, componentHandler, item, format);
                }
                output.add(member);
                ++i;
            }
            return output.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }

    @NotNull
    private static String getArrayMemberDisplayString(@NotNull DBSTypedObject type, @NotNull DBDValueHandler handler, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (DBUtils.isNullValue((Object)value)) {
            return "NULL";
        }
        String string = handler.getValueDisplayString(type, value, format);
        if (PostgreArrayValueHandler.isQuotingRequired(type, string)) {
            return "\"" + string.replaceAll("[\\\\\"]", "\\\\$0") + "\"";
        }
        return string;
    }

    private static boolean isQuotingRequired(@NotNull DBSTypedObject type, @NotNull String value) {
        switch (type.getDataKind()) {
            case NUMERIC: 
            case ARRAY: {
                return false;
            }
        }
        if (value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return true;
        }
        int index = 0;
        while (index < value.length()) {
            switch (value.charAt(index)) {
                case ' ': 
                case '\"': 
                case '\\': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            ++index;
        }
        return value.equals(PostgreUtils.getArrayDelimiter(type));
    }
}

