/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreBinaryFormatter;
import org.jkiss.dbeaver.ext.postgresql.sql.PostgreEscapeStringRule;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDataTypeConverter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectDDLExtension;
import org.jkiss.dbeaver.model.sql.SQLDialectSchemaController;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDollarQuoteRule;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreDialect
extends JDBCSQLDialect
implements TPRuleProvider,
SQLDataTypeConverter,
SQLDialectDDLExtension,
SQLDialectSchemaController {
    public static final String[] POSTGRE_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"SHOW", "SET"});
    private static final String[][] PG_STRING_QUOTES = new String[][]{{"'", "'"}};
    public static final String[][] BLOCK_BOUND_KEYWORDS = new String[0][];
    private static final String[] EXEC_KEYWORDS = new String[]{"CALL"};
    private static final String[] OTHER_TYPES_FUNCTION = new String[]{"current_date", "current_time", "current_timestamp", "current_role", "current_user"};
    public static final String AUTO_INCREMENT_KEYWORD = "AUTO_INCREMENT";
    public static String[] POSTGRE_EXTRA_KEYWORDS = new String[]{"ABSENT", "ACCORDING", "ADA", "ADMIN", "BASE64", "BEGIN_FRAME", "BEGIN_PARTITION", "BERNOULLI", "BIT_LENGTH", "BLOCKED", "BOM", "CONTROL", "DLNEWCOPY", "DLPREVIOUSCOPY", "DLURLCOMPLETE", "DLURLCOMPLETEONLY", "DLURLCOMPLETEWRITE", "DLURLPATH", "DLURLPATHONLY", "DLURLPATHWRITE", "DLURLSCHEME", "DLURLSERVER", "DLVALUE", "DYNAMIC_FUNCTION", "DYNAMIC_FUNCTION_CODE", "EMPTY", "END_FRAME", "END_PARTITION", "ENFORCED", "EXIT", "EXPRESSION", "FIRST_VALUE", "FRAME_ROW", "FS", "GROUPS", "IGNORE", "IMMEDIATELY", "INCLUDE", "INDENT", "INTEGRITY", "KEY_MEMBER", "LAG", "LAST_VALUE", "LEAD", "LIBRARY", "LIKE_REGEX", "NAMESPACE", "NIL", "NTH_VALUE", "NTILE", "NULLABLE", "OCCURRENCES_REGEX", "PASSTHROUGH", "PERCENT", "PERIOD", "PERMISSION", "POSITION_REGEX", "PRECEDES", "PROCEDURES", "RECOVERY", "REQUIRING", "RESPECT", "RESTORE", "RULE", "SIMPLE", "SQLCODE", "SQLERROR", "SUCCEEDS", "TOKEN", "UNLINK", "UNTYPED", "VERSIONING", "XMLAGG", "XMLBINARY", "XMLCAST", "XMLCOMMENT", "XMLDECLARATION", "XMLDOCUMENT", "XMLITERATE", "XMLQUERY", "XMLSCHEMA", "XMLTEXT", "XMLVALIDATE", "SQLERRM", "WHILE"};
    public static String[] POSTGRE_EXTRA_TYPES = new String[]{"UUID"};
    public static String[] POSTGRE_ONE_CHAR_KEYWORDS = new String[]{"C", "G", "K", "M", "T", "P"};
    public static String[] POSTGRE_FUNCTIONS_AGGREGATE = new String[]{"array_agg", "bit_and", "bit_or", "bool_and", "bool_or", "every", "json_agg", "jsonb_agg", "json_object_agg", "jsonb_object_agg", "mode", "string_agg", "xmlagg", "corr", "covar_pop", "covar_samp", "stddev", "stddev_pop", "stddev_samp", "variance", "var_pop", "var_samp"};
    public static String[] POSTGRE_FUNCTIONS_WINDOW = new String[]{"row_number", "rank", "dense_rank", "cume_dist", "ntile", "lag", "lead", "first_value", "last_value", "nth_value"};
    public static String[] POSTGRE_FUNCTIONS_MATH = new String[]{"acosd", "asind", "atan2d", "atand", "cbrt", "ceil", "ceiling", "cosd", "cotd", "div", "exp", "ln", "mod", "random", "scale", "setseed", "sind", "tand", "trunc", "width_bucket"};
    public static String[] POSTGRE_FUNCTIONS_STRING = new String[]{"bit_length", "btrim", "chr", "concat_ws", "convert", "convert_from", "convert_to", "decode", "encode", "initcap", "left", "length", "lpad", "md5", "overlay", "parse_ident", "pg_client_encoding", "position", "quote_ident", "quote_literal", "quote_nullable", "regexp_match", "regexp_matches", "regexp_replace", "regexp_split_to_array", "regexp_split_to_table", "replace", "reverse", "right", "rpad", "split_part", "strpos", "substring", "to_ascii", "to_hex", "translate", "treat", "unaccent"};
    public static String[] POSTGRE_FUNCTIONS_DATETIME = new String[]{"age", "clock_timestamp", "date_part", "date_trunc", "isfinite", "justify_days", "justify_hours", "justify_interval", "make_date", "make_interval", "make_time", "make_timestamp", "make_timestamptz", "statement_timestamp", "timeofday", "transaction_timestamp"};
    public static String[] POSTGRE_FUNCTIONS_GEOMETRY = new String[]{"area", "center", "diameter", "height", "isclosed", "isopen", "npoints", "pclose", "popen", "radius", "width", "box", "bound_box", "circle", "line", "lseg", "path", "polygon"};
    public static String[] POSTGRE_FUNCTIONS_NETWROK = new String[]{"abbrev", "broadcast", "host", "hostmask", "masklen", "netmask", "network", "set_masklen", "text", "inet_same_family", "inet_merge", "macaddr8_set7bit"};
    public static String[] POSTGRE_FUNCTIONS_LO = new String[]{"lo_from_bytea", "lo_put", "lo_get", "lo_creat", "lo_create", "lo_unlink", "lo_import", "lo_export", "loread", "lowrite", "grouping", "cast"};
    public static String[] POSTGRE_FUNCTIONS_ADMIN = new String[]{"current_setting", "set_config", "brin_summarize_new_values", "brin_summarize_range", "brin_desummarize_range", "gin_clean_pending_list"};
    public static String[] POSTGRE_FUNCTIONS_RANGE = new String[]{"isempty", "lower_inc", "upper_inc", "lower_inf", "upper_inf", "range_merge"};
    public static String[] POSTGRE_FUNCTIONS_TEXT_SEARCH = new String[]{"array_to_tsvector", "get_current_ts_config", "numnode", "plainto_tsquery", "phraseto_tsquery", "websearch_to_tsquery", "querytree", "setweight", "strip", "to_tsquery", "to_tsvector", "json_to_tsvector", "jsonb_to_tsvector", "ts_delete", "ts_filter", "ts_headline", "ts_rank", "ts_rank_cd", "ts_rewrite", "tsquery_phrase", "tsvector_to_array", "tsvector_update_trigger", "tsvector_update_trigger_column"};
    public static String[] POSTGRE_FUNCTIONS_XML = new String[]{"xmlcomment", "xmlconcat", "xmlelement", "xmlforest", "xmlpi", "xmlroot", "xmlexists", "xml_is_well_formed", "xml_is_well_formed_document", "xml_is_well_formed_content", "xpath", "xpath_exists", "xmltable", "xmlnamespaces", "table_to_xml", "table_to_xmlschema", "table_to_xml_and_xmlschema", "query_to_xml", "query_to_xmlschema", "query_to_xml_and_xmlschema", "cursor_to_xml", "cursor_to_xmlschema", "schema_to_xml", "schema_to_xmlschema", "schema_to_xml_and_xmlschema", "database_to_xml", "database_to_xmlschema", "database_to_xml_and_xmlschema", "xmlattributes"};
    public static String[] POSTGRE_FUNCTIONS_JSON = new String[]{"to_json", "to_jsonb", "array_to_json", "row_to_json", "json_build_array", "jsonb_build_array", "json_build_object", "jsonb_build_object", "json_object", "jsonb_object", "json_array_length", "jsonb_array_length", "json_each", "jsonb_each", "json_each_text", "jsonb_each_text", "json_extract_path", "jsonb_extract_path", "json_object_keys", "jsonb_object_keys", "json_populate_record", "jsonb_populate_record", "json_populate_recordset", "jsonb_populate_recordset", "json_array_elements", "jsonb_array_elements", "json_array_elements_text", "jsonb_array_elements_text", "json_typeof", "jsonb_typeof", "json_to_record", "jsonb_to_record", "json_to_recordset", "jsonb_to_recordset", "json_strip_nulls", "jsonb_strip_nulls", "jsonb_set", "jsonb_insert", "jsonb_pretty"};
    public static String[] POSTGRE_FUNCTIONS_ARRAY = new String[]{"array_append", "array_cat", "array_ndims", "array_dims", "array_fill", "array_length", "array_lower", "array_position", "array_positions", "array_prepend", "array_remove", "array_replace", "array_to_string", "array_upper", "cardinality", "string_to_array", "unnest"};
    public static String[] POSTGRE_FUNCTIONS_INFO = new String[]{"current_database", "current_query", "current_schema", "current_schemas", "inet_client_addr", "inet_client_port", "inet_server_addr", "inet_server_port", "row_security_active", "format_type", "to_regclass", "to_regproc", "to_regprocedure", "to_regoper", "to_regoperator", "to_regtype", "to_regnamespace", "to_regrole", "col_description", "obj_description", "shobj_description", "txid_current", "txid_current_if_assigned", "txid_current_snapshot", "txid_snapshot_xip", "txid_snapshot_xmax", "txid_snapshot_xmin", "txid_visible_in_snapshot", "txid_status"};
    public static String[] POSTGRE_FUNCTIONS_COMPRASION = new String[]{"num_nonnulls", "num_nulls"};
    public static String[] POSTGRE_FUNCTIONS_FORMATTING = new String[]{"to_char", "to_date", "to_number", "to_timestamp"};
    public static String[] POSTGRE_FUNCTIONS_ENUM = new String[]{"enum_first", "enum_last", "enum_range"};
    public static String[] POSTGRE_FUNCTIONS_SEQUENCE = new String[]{"currval", "lastval", "nextval", "setval"};
    public static String[] POSTGRE_FUNCTIONS_BINARY_STRING = new String[]{"get_bit", "get_byte", "set_bit", "set_byte"};
    public static String[] POSTGRE_FUNCTIONS_CONDITIONAL = new String[]{"coalesce", "nullif", "greatest", "least"};
    public static String[] POSTGRE_FUNCTIONS_TRIGGER = new String[]{"suppress_redundant_updates_trigger"};
    public static String[] POSTGRE_FUNCTIONS_SRF = new String[]{"generate_series", "generate_subscripts"};
    private PostgreServerExtension serverExtension;

    public PostgreDialect() {
        super("PostgreSQL", "postgresql");
    }

    public void addExtraKeywords(String ... keywords) {
        super.addSQLKeywords(Arrays.asList(keywords));
    }

    public void addExtraFunctions(String ... functions) {
        super.addFunctions(Arrays.asList(functions));
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addExtraKeywords("SHOW", "TYPE", "USER", "COMMENT", "MATERIALIZED", "ILIKE", "ELSIF", "ELSEIF", "ANALYSE", "ANALYZE", "CONCURRENTLY", "FREEZE", "LANGUAGE", "MODULE", "OFFSET", "RETURNING", "VARIADIC", "PERFORM", "FOREACH", "LOOP", "PERFORM", "RAISE", "NOTICE", "CONFLICT", "EXTENSION", "DATATYPE", "TABLESPACE", "REFRESH");
        this.addExtraKeywords(POSTGRE_EXTRA_KEYWORDS);
        this.addKeywords(Arrays.asList(OTHER_TYPES_FUNCTION), DBPKeywordType.OTHER);
        this.addExtraFunctions(PostgreConstants.POSTGIS_FUNCTIONS);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_ADMIN);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_AGGREGATE);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_ARRAY);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_BINARY_STRING);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_COMPRASION);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_CONDITIONAL);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_DATETIME);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_ENUM);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_FORMATTING);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_GEOMETRY);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_INFO);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_JSON);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_LO);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_MATH);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_NETWROK);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_RANGE);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_SEQUENCE);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_SRF);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_STRING);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_TEXT_SEARCH);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_TRIGGER);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_WINDOW);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_XML);
        this.removeSQLKeyword("LENGTH");
        if (dataSource instanceof PostgreDataSource) {
            this.serverExtension = ((PostgreDataSource)dataSource).getServerType();
            this.serverExtension.configureDialect(this);
        }
        this.setUnquotedIdentCase(DBPIdentifierCase.LOWER);
    }

    @NotNull
    protected DBPIdentifierCase getDefaultIdentifiersCase() {
        return DBPIdentifierCase.LOWER;
    }

    public void addKeywords(Collection<String> set, DBPKeywordType type) {
        super.addKeywords(set, type);
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public char getStringEscapeCharacter() {
        if (this.serverExtension != null && this.serverExtension.supportsBackslashStringEscape()) {
            return '\\';
        }
        return super.getStringEscapeCharacter();
    }

    public int getCatalogUsage() {
        return 1;
    }

    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public String[] getParametersPrefixes() {
        return new String[]{"$"};
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public String[][] getBlockBoundStrings() {
        return BLOCK_BOUND_KEYWORDS;
    }

    public String getCastedAttributeName(@NotNull DBSAttributeBase attribute, String attributeName) {
        if (attribute instanceof DBSObject && !DBUtils.isPseudoAttribute((DBSAttributeBase)attribute)) {
            attributeName = !CommonUtils.equalObjects((Object)attributeName, (Object)attribute.getName()) ? DBUtils.getQuotedIdentifier((DBPDataSource)((DBSObject)attribute).getDataSource(), (String)attributeName) : DBUtils.getObjectFullName((DBPDataSource)((DBSObject)attribute).getDataSource(), (DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return this.getCastedString((DBSTypedObject)attribute, attributeName, true, true);
    }

    @NotNull
    public String getTypeCastClause(@NotNull DBSTypedObject attribute, String expression, boolean isInCondition) {
        return this.getCastedString(attribute, expression, isInCondition, false);
    }

    private String getCastedString(@NotNull DBSTypedObject attribute, String string, boolean isInCondition, boolean castColumnName) {
        String typeCasting;
        DBSDataType dataType;
        if (attribute instanceof DBSTypedObjectEx && (dataType = ((DBSTypedObjectEx)attribute).getDataType()) instanceof PostgreDataType && CommonUtils.isNotEmpty((String)(typeCasting = ((PostgreDataType)dataType).getConditionTypeCasting(isInCondition, castColumnName)))) {
            return string + typeCasting;
        }
        return string;
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (PostgreUtils.isPGObject(value) || "bit".equals(attribute.getTypeName()) || "interval".equals(attribute.getTypeName()) || attribute.getTypeID() == 1111 || attribute.getTypeID() == 2003 || attribute.getTypeID() == 2002) {
            return "'" + this.escapeString(strValue) + "'";
        }
        if (CommonUtils.isNaN((Object)value) || CommonUtils.isInfinite((Object)value)) {
            return "'" + String.valueOf(value) + "'";
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }

    @NotNull
    public String[][] getStringQuoteStrings() {
        return PG_STRING_QUOTES;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsAliasInConditions() {
        return false;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    public boolean supportsColumnAutoIncrement() {
        return false;
    }

    public boolean supportsCommentQuery() {
        return true;
    }

    public boolean supportsNestedComments() {
        return true;
    }

    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        if (operator == DBCLogicalOperator.LIKE) {
            return (left, right) -> left + " ILIKE " + right;
        }
        return super.getCaseInsensitiveExpressionFormatter(operator);
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return PostgreBinaryFormatter.INSTANCE;
    }

    protected void loadDataTypesFromDatabase(JDBCDataSource dataSource) {
        super.loadDataTypesFromDatabase(dataSource);
        this.addDataTypes(PostgreConstants.DATA_TYPE_ALIASES.keySet());
        this.addDataTypes(Arrays.asList(POSTGRE_EXTRA_TYPES));
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return POSTGRE_NON_TRANSACTIONAL_KEYWORDS;
    }

    protected boolean isStoredProcedureCallIncludesOutParameters() {
        return false;
    }

    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            boolean ddTagDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.tag.string");
            boolean ddTagIsString = dataSource == null ? ddTagDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.tag.string"), (boolean)ddTagDefault);
            boolean ddPlainDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.plain.string");
            boolean ddPlainIsString = dataSource == null ? ddPlainDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.plain.string"), (boolean)ddPlainDefault);
            return new TPRule[]{new SQLDollarQuoteRule(position == TPRuleProvider.RulePosition.PARTITION, true, ddTagIsString, ddPlainIsString), new PostgreEscapeStringRule()};
        }
        return new TPRule[0];
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }

    public String convertExternalDataType(@NotNull SQLDialect sourceDialect, @NotNull DBSTypedObject sourceTypedObject, @Nullable DBPDataTypeProvider targetTypeProvider) {
        String externalTypeName = sourceTypedObject.getTypeName().toLowerCase(Locale.ENGLISH);
        String localDataType = null;
        Object dataTypeModifies = null;
        switch (externalTypeName) {
            case "xmltype": 
            case "xml": 
            case "sys.xmltype": {
                localDataType = "xml";
                break;
            }
            case "nvarchar": 
            case "varchar2": 
            case "nchar": {
                localDataType = "varchar";
                if (sourceTypedObject.getMaxLength() <= 0L || sourceTypedObject.getMaxLength() == Integer.MAX_VALUE || sourceTypedObject.getMaxLength() == Long.MAX_VALUE) break;
                dataTypeModifies = String.valueOf(sourceTypedObject.getMaxLength());
                break;
            }
            case "json": 
            case "jsonb": {
                localDataType = "jsonb";
                break;
            }
            case "sdo_geometry": 
            case "mdsys.sdo_geometry": 
            case "geometry": {
                localDataType = "geometry";
                break;
            }
            case "number": {
                localDataType = "numeric";
                if (sourceTypedObject.getPrecision() == null) break;
                dataTypeModifies = sourceTypedObject.getPrecision().toString();
                if (sourceTypedObject.getScale() == null) break;
                dataTypeModifies = (String)dataTypeModifies + "," + String.valueOf(sourceTypedObject.getScale());
            }
        }
        if (localDataType == null) {
            return null;
        }
        if (targetTypeProvider == null) {
            return localDataType;
        }
        DBSDataType dataType = targetTypeProvider.getLocalDataType(localDataType);
        if (dataType == null) {
            return null;
        }
        Object targetTypeName = DBUtils.getObjectFullName((DBPNamedObject)dataType, (DBPEvaluationContext)DBPEvaluationContext.DDL);
        if (dataTypeModifies != null) {
            targetTypeName = (String)targetTypeName + "(" + (String)dataTypeModifies + ")";
        }
        return targetTypeName;
    }

    @Nullable
    public String getAutoIncrementKeyword() {
        return AUTO_INCREMENT_KEYWORD;
    }

    public boolean supportsCreateIfExists() {
        return true;
    }

    @NotNull
    public String getTimestampDataType() {
        return "timestamp";
    }

    @NotNull
    public String getBigIntegerType() {
        return "bigint";
    }

    @NotNull
    public String getClobDataType() {
        return "text";
    }

    @NotNull
    public String getBlobDataType() {
        return "bytea";
    }

    @NotNull
    public String getUuidDataType() {
        return "uuid";
    }

    @NotNull
    public String getBooleanDataType() {
        return "boolean";
    }

    @NotNull
    public String getAlterColumnOperation() {
        return "alter";
    }

    public boolean supportsNoActionIndex() {
        return true;
    }

    public boolean supportsAlterColumnSet() {
        return true;
    }

    public boolean supportsAlterHasColumn() {
        return true;
    }

    @NotNull
    public String getSchemaExistQuery(@NotNull String schemaName) {
        return "SELECT 1 FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = " + this.getQuotedString(schemaName);
    }

    @NotNull
    public String getCreateSchemaQuery(@NotNull String schemaName) {
        return "CREATE SCHEMA " + schemaName;
    }

    public EnumSet<SQLDialect.ProjectionAliasVisibilityScope> getProjectionAliasVisibilityScope() {
        return EnumSet.of(SQLDialect.ProjectionAliasVisibilityScope.GROUP_BY, SQLDialect.ProjectionAliasVisibilityScope.ORDER_BY);
    }
}

