/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreSequenceManager
extends SQLObjectEditor<PostgreTableBase, PostgreSchema>
implements DBEObjectRenamer<PostgreTableBase> {
    public DBSObjectCache<? extends DBSObject, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreTableContainer)object.getContainer()).getSchema().getTableCache();
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((PostgreTableBase)command.getObject()).getName())) {
            throw new DBException("Sequence name cannot be empty");
        }
    }

    protected PostgreSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        PostgreSchema schema = (PostgreSchema)container;
        return schema.getDataSource().getServerType().createSequence(schema);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create sequence", "CREATE SEQUENCE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        PostgreSequence sequence = (PostgreSequence)command.getObject();
        String sequenceName = sequence.getFullyQualifiedName(DBPEvaluationContext.DDL);
        StringBuilder sequenceOptions = new StringBuilder();
        this.addSequenceOptions(sequenceOptions, command.getProperties());
        if (sequenceOptions.length() > 0) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter sequence", "ALTER SEQUENCE " + sequenceName + String.valueOf(sequenceOptions)));
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop sequence", "DROP SEQUENCE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private void addSequenceOptions(StringBuilder ddl, Map<Object, Object> options) {
        if (options.containsKey("incrementBy")) {
            ddl.append("\n\tINCREMENT BY ").append(options.get("incrementBy"));
        }
        if (options.containsKey("minValue")) {
            ddl.append("\n\tMINVALUE ").append(options.get("minValue"));
        }
        if (options.containsKey("maxValue")) {
            ddl.append("\n\tMAXVALUE ").append(options.get("maxValue"));
        }
        if (options.containsKey("startValue")) {
            ddl.append("\n\tSTART ").append(options.get("startValue"));
        }
        if (options.get("lastValue") != null) {
            ddl.append("\n\tRESTART ").append(options.get("lastValue"));
        }
        if (options.containsKey("cacheValue")) {
            ddl.append("\n\tCACHE ").append(options.get("cacheValue"));
        }
        if (options.containsKey("cycled")) {
            ddl.append("\n\t");
            if (!CommonUtils.toBoolean((Object)options.get("cycled"))) {
                ddl.append("NO ");
            }
            ddl.append("CYCLE");
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename sequence", "ALTER SEQUENCE " + DBUtils.getQuotedIdentifier((DBSObject)((PostgreTableBase)command.getObject()).getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, options, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreTableBase, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "COMMENT ON SEQUENCE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)CommonUtils.notEmpty((String)((PostgreTableBase)command.getObject()).getDescription()))));
        }
    }
}

