/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.backup;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.sql.backup.JDBCDatabaseBackupHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class JDBCDatabasePostgresBackupHandler
implements JDBCDatabaseBackupHandler {
    private static final Log log = Log.getLog(JDBCDatabasePostgresBackupHandler.class);

    public void doBackup(@NotNull Connection connection, int currentSchemaVersion, @NotNull InternalDatabaseConfig databaseConfig) throws DBException {
        block6: {
            try {
                URI uri = new URI(databaseConfig.getUrl().replace("jdbc:", ""));
                Path workspace = DBWorkbench.getPlatform().getWorkspace().getAbsolutePath().resolve("backup");
                Path backupFile = workspace.resolve(uri.getPath().replace("/", "") + "_backup_version_" + databaseConfig.getSchema() + currentSchemaVersion + ".zip");
                if (!Files.notExists(backupFile, new LinkOption[0])) break block6;
                Files.createDirectories(workspace, new FileAttribute[0]);
                ProcessBuilder processBuilder = JDBCDatabasePostgresBackupHandler.getBuilder(databaseConfig, uri, backupFile);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                while (process.isAlive()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                int exitCode = process.exitValue();
                if (exitCode == 0) {
                    log.info((Object)"Postgres backup successful");
                    break block6;
                }
                log.error((Object)"Postgres backup failed");
                throw new DBException("Postgres backup failed");
            }
            catch (Exception e) {
                log.error((Object)("Create backup is failed: " + e.getMessage()));
                throw new DBException("Create backup is failed: " + e.getMessage());
            }
        }
    }

    private static ProcessBuilder getBuilder(@NotNull InternalDatabaseConfig databaseConfig, URI uri, Path backupFile) {
        ProcessBuilder processBuilder = new ProcessBuilder("pg_dump", "--host", uri.getHost(), "--port", String.valueOf(uri.getPort()), "--username", databaseConfig.getUser(), "--schema", databaseConfig.getSchema(), "--format", "c", "--blobs", "--verbose", "--file", backupFile.toAbsolutePath().toString());
        if (CommonUtils.isNotEmpty((String)databaseConfig.getPassword())) {
            processBuilder.environment().put("PGPASSWORD", databaseConfig.getPassword());
        }
        return processBuilder;
    }
}

