/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.rulers.RulerFigure;

public class RulerLayout
extends AbstractLayout {
    private final Map<IFigure, Integer> constraints = new HashMap<IFigure, Integer>();

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return new Dimension(1, 1);
    }

    public Integer getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    public void layout(IFigure container) {
        Rectangle rulerSize = container.getClientArea();
        for (IFigure child : container.getChildren()) {
            Dimension childSize = child.getPreferredSize();
            Integer childPos = this.getConstraint(child);
            if (childPos == null) continue;
            int position = childPos;
            if (((RulerFigure)container).isHorizontal()) {
                childSize.height = rulerSize.height - 1;
                Rectangle.SINGLETON.setLocation(position - childSize.width / 2, rulerSize.y);
            } else {
                childSize.width = rulerSize.width - 1;
                Rectangle.SINGLETON.setLocation(rulerSize.x, position - childSize.height / 2);
            }
            Rectangle.SINGLETON.setSize(childSize);
            child.setBounds(Rectangle.SINGLETON);
        }
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    /*
     * WARNING - void declaration
     */
    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            void intConstraint;
            Object object = newConstraint;
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("RulerLayout was given " + newConstraint.getClass().getName() + " as constraint for Figure. Integer expected!");
            }
            Integer n = (Integer)object;
            Integer cfr_ignored_0 = (Integer)object;
            this.constraints.put(figure, (Integer)intConstraint);
        }
    }
}

