/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteContainerFlowLayout;
import org.eclipse.gef.internal.ui.palette.editparts.PinnablePaletteStackFigure;
import org.eclipse.gef.internal.ui.palette.editparts.SeparatorEditPart;

public class ColumnsLayout
extends PaletteContainerFlowLayout {
    private Dimension defaultConstraint = null;
    private Dimension cachedConstraint = null;

    public ColumnsLayout() {
        super(true);
        this.setMinorSpacing(0);
        this.setMajorSpacing(0);
        this.setStretchMinorAxis(true);
        this.setDefaultConstraint(new Dimension(55, 55));
    }

    @Override
    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        if (!(child instanceof SeparatorEditPart.SeparatorFigure)) {
            Dimension hints = this.getMinimumHints(child, wHint, hHint);
            int numOfColumns = (wHint + this.getMajorSpacing()) / (hints.width + this.getMajorSpacing());
            wHint = numOfColumns == 0 ? hints.width : (wHint - (numOfColumns - 1) * this.getMajorSpacing()) / numOfColumns;
            hHint = hints.height;
        }
        return super.getChildSize(child, wHint, hHint);
    }

    /*
     * WARNING - void declaration
     */
    private Dimension getMinimumHints(IFigure figure, int wHint, int hHint) {
        if (this.cachedConstraint == null) {
            this.cachedConstraint = this.defaultConstraint.getCopy();
            for (IFigure child : figure.getParent().getChildren()) {
                Dimension dimension;
                IFigure iFigure = child;
                if (iFigure instanceof PinnablePaletteStackFigure) {
                    void ppStackFigure;
                    PinnablePaletteStackFigure cfr_ignored_0 = (PinnablePaletteStackFigure)iFigure;
                    PinnablePaletteStackFigure cfr_ignored_1 = (PinnablePaletteStackFigure)iFigure;
                    dimension = ppStackFigure.getHeaderPreferredSize(this.cachedConstraint.width, this.cachedConstraint.height);
                } else {
                    dimension = child.getPreferredSize(this.cachedConstraint.width, this.cachedConstraint.height);
                }
                Dimension childSize = dimension;
                this.cachedConstraint.width = Math.max(this.cachedConstraint.width, childSize.width);
            }
            this.cachedConstraint.height = hHint;
        }
        return this.cachedConstraint;
    }

    public void invalidate() {
        super.invalidate();
        this.cachedConstraint = null;
    }

    public void setDefaultConstraint(Dimension d) {
        this.defaultConstraint = d;
    }
}

