/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.InvalidFieldLengthException;
import nl.knaw.dans.common.dbflib.InvalidFieldTypeException;
import nl.knaw.dans.common.dbflib.Table;
import nl.knaw.dans.common.dbflib.Version;

public class Database {
    private final File databaseDirectory;
    private final Map<String, Table> tableMap = new HashMap<String, Table>();
    private final Version version;
    private final String charsetName;

    public Database(File databaseDirectory, Version version) {
        this(databaseDirectory, version, Charset.defaultCharset().name());
    }

    public Database(File databaseDirectory, Version version, String charsetName) {
        String[] fileNames;
        if (databaseDirectory == null || databaseDirectory.isFile()) {
            throw new IllegalArgumentException("Database must be a directory ");
        }
        if (!databaseDirectory.exists()) {
            databaseDirectory.mkdirs();
        }
        this.databaseDirectory = databaseDirectory;
        this.version = version;
        this.charsetName = charsetName == null ? Charset.defaultCharset().name() : charsetName;
        Charset.forName(this.charsetName);
        for (String fileName : fileNames = databaseDirectory.list()) {
            if (!fileName.toLowerCase().endsWith(".dbf") || fileName.length() <= ".dbf".length()) continue;
            this.addTable(fileName);
        }
    }

    public Set<String> getTableNames() {
        return Collections.unmodifiableSet(this.tableMap.keySet());
    }

    public Table getTable(String name) {
        return this.tableMap.get(name);
    }

    public Table addTable(String name, List<Field> fields) throws InvalidFieldTypeException, InvalidFieldLengthException {
        Table table = this.tableMap.get(name);
        if (table == null) {
            table = new Table(new File(this.databaseDirectory, name), this.version, fields);
            this.tableMap.put(name, table);
        }
        return table;
    }

    private void addTable(String name) {
        Table table = this.tableMap.get(name);
        if (table == null) {
            table = new Table(new File(this.databaseDirectory, name), this.charsetName);
            this.tableMap.put(name, table);
        }
    }

    public void removeTable(String name) {
        this.tableMap.remove(name);
    }

    public void removeTable(Table table) {
        this.tableMap.remove(table.getName());
    }

    public String getCharsetName() {
        return this.charsetName;
    }
}

