/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXASocketFactory;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.FileValidator;
import com.exasol.jdbc.importExport.HTTPThread;
import com.exasol.jdbc.importExport.HttpPush;
import com.exasol.jdbc.importExport.MultiFileInputStream;
import com.exasol.jdbc.importExport.QueryManipulator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class HttpPushTool {
    final String sql;
    final HttpPush hp;
    final String[] files;
    final String[] errFiles;
    final String cookie;
    final String errCookie;
    DebugLog debug = null;
    final PrintStream logPrinterOut;
    final PrintStream logPrinterErr;
    HTTPThread hpt = null;

    public void KillHttpPushToolThread() {
        if (this.hpt != null) {
            try {
                this.hpt.InterruptThread();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public HttpPushTool(HttpPush httpPush, HttpPush httpPush2, String string, String[] stringArray, String[] stringArray2, String string2, String string3, DebugLog debugLog, PrintStream printStream, PrintStream printStream2) {
        this.sql = string;
        this.hp = httpPush;
        this.files = stringArray;
        this.errFiles = stringArray2;
        this.cookie = string2;
        this.errCookie = string3;
        this.debug = debugLog;
        this.logPrinterOut = printStream;
        this.logPrinterErr = printStream2;
        this.hpt = new HTTPThread(httpPush, stringArray, string2, debugLog, printStream, printStream2);
        this.hpt.start();
        if (null != httpPush2) {
            this.hpt = new HTTPThread(httpPush2, stringArray2, string3, debugLog, printStream, printStream2);
            this.hpt.start();
        }
    }

    public void logOut(String string) {
        if (this.debug != null) {
            this.debug.log(string);
        }
        if (this.logPrinterOut != null) {
            this.logPrinterOut.println(string);
        }
    }

    public void logErr(String string) {
        if (this.debug != null) {
            this.debug.log(string);
        }
        if (this.logPrinterErr != null) {
            this.logPrinterErr.println(string);
        }
    }

    public void logErr(Throwable throwable) {
        if (this.debug != null) {
            this.debug.log(throwable);
        }
        if (this.logPrinterErr != null) {
            throwable.printStackTrace(this.logPrinterErr);
        }
    }

    public static HttpPushTool transformCommand(String string, Vector vector) throws IOException, SQLException {
        return HttpPushTool.transformCommand(string, vector, false, null, null, null);
    }

    public static HttpPushTool transformCommand(String string, Vector vector, boolean bl, DebugLog debugLog) throws IOException, SQLException {
        return HttpPushTool.transformCommand(string, vector, bl, debugLog, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HttpPushTool transformCommand(String string, Vector vector, boolean bl, DebugLog debugLog, PrintStream printStream, PrintStream printStream2) throws IOException, SQLException {
        void var12_29;
        if (string == null || string.equals("")) {
            return null;
        }
        FileValidator fileValidator = new FileValidator();
        if (!fileValidator.Match(string)) {
            return null;
        }
        if (bl) {
            fileValidator.setSecure(true);
        }
        if (null == vector) {
            throw new SQLException("Cannot connect, no hosts known.", "04506");
        }
        if (!fileValidator.GenerateCookie()) {
            throw new SQLException("Cookie cannot be generated.", "04506");
        }
        if (debugLog != null) {
            debugLog.log(Translator.UseCookie(fileValidator.getCookie()));
            if (fileValidator.getCookieErr() != null) {
                debugLog.log(Translator.UseCookie("Error table cookie: " + fileValidator.getCookie()));
            }
        }
        if (printStream != null) {
            printStream.println(Translator.UseCookie(fileValidator.getCookie()));
            if (fileValidator.getCookieErr() != null) {
                printStream.println(Translator.UseCookie("Error table cookie: " + fileValidator.getCookie()));
            }
        }
        String[] stringArray = fileValidator.getFiles();
        String[] stringArray2 = fileValidator.getErrFiles();
        if (debugLog != null) {
            for (String string2 : stringArray) {
                debugLog.log(Translator.File(string2));
            }
            if (null != stringArray2) {
                for (String string3 : stringArray2) {
                    debugLog.log(Translator.File(string3));
                }
            }
        }
        if (printStream != null) {
            for (String string4 : stringArray) {
                printStream.println(Translator.File(string4));
            }
            if (null != stringArray2) {
                for (String string5 : stringArray2) {
                    printStream.println(Translator.File(string5));
                }
            }
        }
        Socket socket = HttpPushTool.GetNewSocket(vector, debugLog, printStream2, string);
        Socket socket2 = null;
        if (stringArray2 != null) {
            socket2 = HttpPushTool.GetNewSocket(vector, debugLog, printStream2, string);
        }
        HttpPush httpPush = new HttpPush(socket, stringArray, fileValidator.getCookie(), fileValidator.isSecure(), true);
        Object var12_27 = null;
        if (stringArray2 != null) {
            HttpPush httpPush2 = new HttpPush(socket2, stringArray2, fileValidator.getCookieErr(), fileValidator.isSecure(), true);
        }
        String string6 = httpPush.getRemoteHost();
        int n = httpPush.getRemotePort();
        String string7 = null;
        if (stringArray2 != null) {
            string7 = var12_29.getRemoteHost();
        }
        int n2 = 0;
        if (stringArray2 != null) {
            n2 = var12_29.getRemotePort();
        }
        String string8 = fileValidator.isSecure() ? "https" : "http";
        String string9 = string8 + "://" + string6 + ":" + n;
        String string10 = null;
        if (stringArray2 != null) {
            string10 = string8 + "://" + string7 + ":" + n2;
        }
        String string11 = QueryManipulator.BuildImpExpQuery(string9, string10, fileValidator);
        HttpPushTool httpPushTool = new HttpPushTool(httpPush, (HttpPush)var12_29, string11, stringArray, stringArray2, fileValidator.getCookie(), fileValidator.getCookieErr(), debugLog, printStream, printStream2);
        if (debugLog != null) {
            debugLog.log("HttpPushTool created. ");
        }
        return httpPushTool;
    }

    static Socket GetNewSocket(Vector vector, DebugLog debugLog, PrintStream printStream, String string) throws IOException {
        Socket socket = null;
        Vector vector2 = (Vector)vector.clone();
        Collections.shuffle(vector2);
        Enumeration enumeration = vector2.elements();
        block6: while (socket == null && enumeration.hasMoreElements()) {
            ClusterNode clusterNode = (ClusterNode)enumeration.nextElement();
            try {
                EXASocketFactoryInstance eXASocketFactoryInstance = new EXASocketFactoryInstance();
                InetAddress[] inetAddressArray = null;
                try {
                    inetAddressArray = InetAddress.getAllByName(clusterNode.GetHost());
                }
                catch (UnknownHostException unknownHostException) {
                    debugLog.log(Translator.Unknown_host_name() + unknownHostException.getMessage());
                    continue;
                }
                for (InetAddress inetAddress : inetAddressArray) {
                    try {
                        socket = new Socket(inetAddress.getHostAddress(), clusterNode.GetPort());
                        continue block6;
                    }
                    catch (Exception exception) {
                        debugLog.log(exception.toString());
                    }
                }
            }
            catch (Exception exception) {
                socket = null;
            }
        }
        if (socket == null) {
            if (debugLog != null) {
                debugLog.log(Translator.Connect_failed());
            }
            if (printStream != null) {
                printStream.println(Translator.Connect_failed());
            }
            throw new IOException(Translator.Connect_for_SQL_failed(string));
        }
        return socket;
    }

    public void close() throws IOException {
        this.hp.close();
    }

    private Thread getPushThread() {
        return this.hpt;
    }

    public String getSQL() {
        return this.sql;
    }

    public void checkForErrors() throws IOException {
        this.hpt.checkForErrors();
    }

    private static class EXASocketFactoryInstance
    extends EXASocketFactory {
        private EXASocketFactoryInstance() {
        }

        @Override
        public Socket createCustomSocket(InetAddress inetAddress, int n, int n2) {
            return null;
        }
    }

    public static class PullFile
    implements HttpPush.PullFileInterface {
        private FileOutputStream fout = null;
        private byte[] buffer = new byte[16384];

        public PullFile(String string, boolean bl) throws IOException {
            try {
                this.fout = new FileOutputStream(new File(string), bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException(fileNotFoundException.toString() + ": " + string);
            }
        }

        @Override
        public void putBuffer(byte[] byArray, int n) throws IOException {
            this.fout.write(byArray, 0, n);
        }

        @Override
        public void close() throws IOException {
            if (this.fout != null) {
                this.fout.close();
            }
        }
    }

    public static class PushFiles
    implements HttpPush.PushFileInterface {
        private MultiFileInputStream fin = null;
        private byte[] buffer = new byte[16384];
        private int buffer_full = 0;
        private boolean eof = false;

        @Override
        public void close() throws IOException {
            if (null != this.fin) {
                this.fin.close();
            }
        }

        public PushFiles(String[] stringArray) throws IOException {
            this.fin = new MultiFileInputStream(stringArray);
        }

        @Override
        public byte[] getBuffer() {
            return this.buffer;
        }

        @Override
        public boolean hasMoreElements() throws IOException {
            this.buffer_full = this.fin.read(this.buffer);
            return this.buffer_full != -1;
        }

        @Override
        public int nextElement() {
            return this.buffer_full;
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

