/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.informix.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDCursor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCursor;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetImpl;

public class InformixTimeSeriesCursor
implements DBDCursor {
    private static final Log log = Log.getLog(JDBCCursor.class);
    private JDBCSession session;
    private JDBCResultSet resultSet;
    private String cursorName;

    public InformixTimeSeriesCursor(JDBCSession session, ResultSet resultSet, String typeName) throws SQLException {
        this.session = session;
        this.resultSet = new CursorResultSet(session, resultSet);
        this.cursorName = "Cursor (" + typeName + ")";
    }

    public Object getRawValue() {
        return this.resultSet;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            this.resultSet = null;
        }
    }

    @NotNull
    public DBCResultSet openResultSet(@NotNull DBCSession session) throws DBCException {
        if (this.resultSet != null) {
            try {
                this.resultSet.absolute(1);
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this.resultSet.getSession().getExecutionContext());
            }
        }
        return this.resultSet;
    }

    @Nullable
    public String getCursorName() {
        return this.cursorName;
    }

    public String toString() {
        return this.cursorName;
    }

    private class CursorResultSet
    extends JDBCResultSetImpl {
        protected CursorResultSet(@NotNull JDBCSession session, ResultSet original) {
            super(session, null, original, null, true);
        }

        public void close() {
        }
    }
}

