/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.processor;

import com.dbeaver.data.transfer.internal.DTMessages;
import com.dbeaver.data.transfer.mail.SMTPAuthentication;
import com.dbeaver.data.transfer.mail.SMTPProfile;
import com.dbeaver.data.transfer.mail.SMTPProfileManager;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SendMailEventProcessor
implements IDataTransferEventProcessor<IDataTransferConsumer<?, ?>> {
    public static final String PROP_PROFILE = "profile";
    public static final String PROP_FROM = "from";
    public static final String PROP_RECIPIENT = "recipient";
    public static final String PROP_SUBJECT = "subject";
    public static final String PROP_REPORT_TASK_SUCCESS = "sendOnSuccess";
    public static final String PROP_REPORT_TASK_FAILURE = "sendOnError";
    public static final String PROP_OMIT_RESULT_FILES = "omitResultFiles";
    public static final String PROP_OMIT_EMPTY_RESULT_FILES = "omitEmptyResults";
    public static final String PROP_TRUST_SERVER = "trustServer";
    private static final Log log = Log.getLog(SendMailEventProcessor.class);

    public void processEvent(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferEventProcessor.Event event, @NotNull IDataTransferConsumer<?, ?> consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) throws DBException {
        this.process(monitor, null, consumer, task, settings);
    }

    public void processError(@NotNull DBRProgressMonitor monitor, @NotNull Throwable error, @NotNull IDataTransferConsumer<?, ?> consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) throws DBException {
        this.process(monitor, error, consumer, task, settings);
    }

    /*
     * WARNING - void declaration
     */
    private void process(@NotNull DBRProgressMonitor monitor, @Nullable Throwable error, @NotNull IDataTransferConsumer<?, ?> consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) throws DBException {
        if (!SendMailEventProcessor.canProceed(error, consumer, settings)) {
            return;
        }
        SMTPProfile profile = SMTPProfileManager.getProfile(CommonUtils.toString((Object)settings.get(PROP_PROFILE)));
        if (profile == null) {
            throw new DBException("Can't find SMTP profile");
        }
        String from = CommonUtils.toString((Object)settings.get(PROP_FROM));
        String recipient = CommonUtils.toString((Object)settings.get(PROP_RECIPIENT));
        String subject = CommonUtils.toString((Object)settings.get(PROP_SUBJECT));
        SMTPAuthentication auth = profile.getAuthentication();
        if (CommonUtils.isEmptyTrimmed((String)from) && auth != null) {
            from = auth.getUsername();
        }
        if (CommonUtils.isEmptyTrimmed((String)from) || CommonUtils.isEmptyTrimmed((String)recipient) || CommonUtils.isEmptyTrimmed((String)subject)) {
            throw new DBException("Invalid E-Mail configuration");
        }
        Properties properties = new Properties();
        properties.put("mail.smtp.host", profile.getHostname());
        properties.put("mail.smtp.port", (Object)profile.getPort());
        properties.put("mail.smtp.auth", (Object)(auth != null ? 1 : 0));
        properties.put("mail.smtp.starttls.enable", (Object)true);
        if (CommonUtils.toBoolean((Object)settings.get(PROP_TRUST_SERVER))) {
            try {
                properties.put("mail.smtp.socketFactory", SSLHandlerTrustStoreImpl.createNonValidatingSslSocketFactory());
            }
            catch (Exception e) {
                log.error((Object)"Error creating non-validating socket factory", (Throwable)e);
            }
        }
        Session session = Session.getInstance((Properties)properties, (Authenticator)profile.createAuthenticator());
        try {
            IDataTransferConsumer<?, ?> iDataTransferConsumer;
            String taskName;
            MimeMultipart multipart = new MimeMultipart();
            StringJoiner buffer = new StringJoiner("<br>");
            String string = taskName = task != null ? task.getName() : "<unknown>";
            if (error != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                buffer.add(NLS.bind((String)DTMessages.data_transfer_event_processor_send_mail_task_failed_text, (Object)taskName));
                buffer.add("<pre>" + CommonUtils.escapeHtml((String)sw.toString().trim()) + "</pre>");
            } else {
                buffer.add(NLS.bind((String)DTMessages.data_transfer_event_processor_send_mail_task_success_text, (Object)taskName));
            }
            buffer.add("");
            buffer.add(NLS.bind((String)DTMessages.data_transfer_event_processor_send_mail_sent_by_text, (Object)GeneralUtils.getProductName()));
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)buffer.toString(), "text/html; charset=UTF-8");
            multipart.addBodyPart((BodyPart)body);
            if (error == null && (iDataTransferConsumer = consumer) instanceof StreamTransferConsumer) {
                buffer = (StreamTransferConsumer)iDataTransferConsumer;
                StreamTransferConsumer cfr_ignored_0 = (StreamTransferConsumer)iDataTransferConsumer;
                if (!CommonUtils.toBoolean((Object)settings.get(PROP_OMIT_RESULT_FILES))) {
                    void streamConsumer;
                    for (Path file : streamConsumer.getOutputFiles()) {
                        MimeBodyPart attachment = new MimeBodyPart();
                        attachment.attachFile(file.toFile());
                        multipart.addBodyPart((BodyPart)attachment);
                    }
                }
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
            message.setSubject(subject);
            message.setContent((Multipart)multipart);
            try {
                monitor.beginTask("Send mail", 1);
                Transport.send((Message)message);
            }
            finally {
                monitor.done();
            }
        }
        catch (Exception e) {
            throw new DBException("Error sending E-Mail message", (Throwable)e);
        }
    }

    private static boolean canProceed(@Nullable Throwable error, @NotNull IDataTransferConsumer<?, ?> consumer, @NotNull Map<String, Object> settings) {
        if (error != null) {
            return CommonUtils.getBoolean((Object)settings.get(PROP_REPORT_TASK_FAILURE), (boolean)true);
        }
        if (!CommonUtils.getBoolean((Object)settings.get(PROP_REPORT_TASK_SUCCESS), (boolean)true)) {
            return false;
        }
        if (consumer instanceof StreamTransferConsumer && ((StreamTransferConsumer)consumer).isBeforeFirstRow()) {
            return !CommonUtils.toBoolean((Object)settings.get(PROP_OMIT_EMPTY_RESULT_FILES));
        }
        return true;
    }
}

