/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.mail;

import com.dbeaver.data.transfer.mail.SMTPAuthentication;
import com.dbeaver.data.transfer.mail.SMTPProfile;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public final class SMTPProfileManager {
    private static final Log log = Log.getLog(SMTPProfileManager.class);
    private static final List<SMTPProfile> cachedProfiles = new ArrayList<SMTPProfile>();

    private SMTPProfileManager() {
    }

    @Nullable
    public static SMTPProfile getProfile(@NotNull String id) {
        for (SMTPProfile profile : SMTPProfileManager.getProfiles()) {
            if (!profile.getId().equals(id)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    private static String getSecretId(int profileIndex, String key) {
        return "mail/profiles/" + profileIndex + "/" + key;
    }

    @NotNull
    private static DBSSecretController getSecretController() throws DBException {
        return DBSSecretController.getGlobalSecretController();
    }

    @NotNull
    public static synchronized List<SMTPProfile> getProfiles() {
        if (cachedProfiles.isEmpty()) {
            DBSSecretController secrets;
            try {
                secrets = SMTPProfileManager.getSecretController();
            }
            catch (DBException e) {
                log.error((Object)e);
                return cachedProfiles;
            }
            DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
            int count = preferences.getInt("mail.profiles.count");
            int i = 0;
            while (i < count) {
                try {
                    String username = CommonUtils.notEmpty((String)secrets.getPrivateSecretValue(SMTPProfileManager.getSecretId(i, "username")));
                    String password = CommonUtils.notEmpty((String)secrets.getPrivateSecretValue(SMTPProfileManager.getSecretId(i, "password")));
                    SMTPAuthentication authentication = CommonUtils.isEmpty((String)username) ? null : new SMTPAuthentication(username, password);
                    cachedProfiles.add(new SMTPProfile(preferences.getString("mail.profiles." + i + ".id"), preferences.getString("mail.profiles." + i + ".hostname"), preferences.getInt("mail.profiles." + i + ".port"), authentication));
                }
                catch (DBException e) {
                    log.warn((Object)"Error loading SMTP profile", (Throwable)e);
                }
                ++i;
            }
        }
        return cachedProfiles;
    }

    public static synchronized void setProfiles(@NotNull List<SMTPProfile> profiles) {
        DBSSecretController secrets;
        cachedProfiles.clear();
        try {
            secrets = SMTPProfileManager.getSecretController();
        }
        catch (DBException e) {
            log.error((Object)e);
            return;
        }
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        try {
            preferences.setValue("mail.profiles.count", profiles.size());
            int i = 0;
            while (i < profiles.size()) {
                SMTPProfile profile = profiles.get(i);
                preferences.setValue("mail.profiles." + i + ".id", profile.getId());
                preferences.setValue("mail.profiles." + i + ".hostname", profile.getHostname());
                preferences.setValue("mail.profiles." + i + ".port", profile.getPort());
                SMTPAuthentication auth = profile.getAuthentication();
                secrets.setPrivateSecretValue(SMTPProfileManager.getSecretId(i, "username"), auth != null ? auth.getUsername() : null);
                secrets.setPrivateSecretValue(SMTPProfileManager.getSecretId(i, "password"), auth != null ? auth.getPassword() : null);
                ++i;
            }
            preferences.save();
            secrets.flushChanges();
        }
        catch (Exception e) {
            log.error((Object)"Error saving SMTP profiles", (Throwable)e);
        }
    }
}

