/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.model;

import com.dbeaver.ee.influxdb2.exec.Influx2ExecutionContext;
import com.dbeaver.ee.influxdb2.model.Influx2DataSource;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class Influx2DataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(Influx2DataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "org.jkiss.bundle.influxdb";
    private final Influx2DataSource dataSource;

    public Influx2DataSourceInfo(Influx2DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isReadOnlyData() {
        return true;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return "InfluxDB";
    }

    public String getDatabaseProductVersion() {
        return ((Influx2ExecutionContext)DBUtils.getDefaultContext((DBSObject)this.dataSource, (boolean)true)).getClient().version();
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Influx driver bundle 'org.jkiss.bundle.influxdb' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        return this.getDriverBundle().getVersion();
    }

    public String getDriverName() {
        return (String)this.getDriverBundle().getHeaders().get("Bundle-Name");
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public boolean supportsIndexes() {
        return true;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsResultSetLimit() {
        return true;
    }

    public boolean supportsResultSetScroll() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return true;
    }
}

