/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.exec;

import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.dbeaver.ee.influxdb2.model.Influx2DataSource;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.domain.WriteConsistency;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.OkHttpClient;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.impl.app.CertificateGenHelper;
import org.jkiss.dbeaver.model.impl.app.NullHostnameVerifier;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class Influx2ExecutionContext
extends AbstractExecutionContext<Influx2DataSource>
implements DBCExecutionContextDefaults<Influx2Database, DBSSchema> {
    private static final Log log = Log.getLog(Influx2ExecutionContext.class);
    private InfluxDBClient influxDB;
    private String defaultDatabase;
    private WriteConsistency currentConsistencyLevel;

    public Influx2ExecutionContext(Influx2DataSource dataSource, String purpose, String databaseName) {
        super((DBPDataSource)dataSource, purpose);
        this.defaultDatabase = databaseName;
    }

    public WriteConsistency getCurrentConsistencyLevel() {
        return this.currentConsistencyLevel;
    }

    public InfluxDBClient getClient() {
        return this.influxDB;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((Influx2DataSource)this.dataSource).getContainer());
        try {
            try {
                String defCL;
                monitor.subTask("Open influx session");
                DBPConnectionConfiguration configuration = ((Influx2DataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
                OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient().newBuilder().connectTimeout((long)CommonUtils.toInt((Object)configuration.getProviderProperty("influxdb.timeout.connect"), (int)10000), TimeUnit.MILLISECONDS).readTimeout((long)CommonUtils.toInt((Object)configuration.getProviderProperty("influxdb.timeout.read"), (int)60000), TimeUnit.MILLISECONDS).writeTimeout((long)CommonUtils.toInt((Object)configuration.getProviderProperty("influxdb.timeout.write"), (int)10000), TimeUnit.MILLISECONDS);
                if (CommonUtils.toBoolean((Object)configuration.getProviderProperty("influxdb.trust.self.signed"))) {
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, CertificateGenHelper.NON_VALIDATING_TRUST_MANAGERS, new SecureRandom());
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    okHttpClientBuilder.sslSocketFactory(sslSocketFactory, CertificateGenHelper.NON_VALIDATING_TRUST_MANAGERS[0]);
                    okHttpClientBuilder.hostnameVerifier((HostnameVerifier)NullHostnameVerifier.INSTANCE);
                }
                if (!CommonUtils.isEmpty((String)(defCL = ((Influx2DataSource)this.dataSource).getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-default.consistency.level@")))) {
                    try {
                        this.currentConsistencyLevel = WriteConsistency.valueOf((String)defCL);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.debug((Object)("Bad default consistency level: " + defCL));
                    }
                }
                InfluxDBClientOptions.Builder optionsBuilder = InfluxDBClientOptions.builder().url(configuration.getUrl());
                optionsBuilder.okHttpClient(okHttpClientBuilder);
                optionsBuilder.url(configuration.getUrl());
                optionsBuilder.bucket(configuration.getDatabaseName());
                optionsBuilder.org(configuration.getProviderProperty("influx.org"));
                if (!CommonUtils.isEmpty((String)configuration.getAuthProperty("influx.token"))) {
                    optionsBuilder.authenticateToken(configuration.getAuthProperty("influx.token").toCharArray());
                } else {
                    optionsBuilder.authenticate(configuration.getUserName(), configuration.getUserPassword().toCharArray());
                }
                optionsBuilder.consistency(this.currentConsistencyLevel);
                this.influxDB = InfluxDBClientFactory.create((InfluxDBClientOptions)optionsBuilder.build());
                this.influxDB.health();
                super.initContextBootstrap(monitor, true);
                ((Influx2DataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((Influx2DataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public Influx2Session openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new Influx2Session(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
        try {
            this.influxDB.health();
        }
        catch (Exception e) {
            throw new DBException("Error pinging Influx", (Throwable)e);
        }
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.influxDB.close();
        Influx2ExecutionContext influx2ExecutionContext = this;
        synchronized (influx2ExecutionContext) {
            ((Influx2DataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }

    public void setCurrentConsistencyLevel(WriteConsistency currentConsistencyLevel) {
        this.currentConsistencyLevel = currentConsistencyLevel;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public Influx2Database getDefaultCatalog() {
        List<Influx2Database> databases = ((Influx2DataSource)this.getDataSource()).getDatabases();
        if (databases == null) {
            return null;
        }
        for (Influx2Database db : databases) {
            if (this.defaultDatabase == null || !CommonUtils.equalObjects((Object)db.getName(), (Object)this.defaultDatabase)) continue;
            return db;
        }
        return null;
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, Influx2Database catalog, DBSSchema schema) throws DBCException {
        Influx2Database oldSelectedDB = this.getDefaultCatalog();
        if (oldSelectedDB == catalog) {
            return;
        }
        this.defaultDatabase = catalog.getName();
        if (oldSelectedDB != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedDB, (boolean)false, (DBCExecutionContext)this);
        }
        DBUtils.fireObjectSelect((DBSObject)catalog, (boolean)true, (DBCExecutionContext)this);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        return true;
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.defaultDatabase, null);
    }
}

