/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.RestExceptionHandler;
import com.dbeaver.remote.client.interceptor.ClientVersionInterceptor;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.app.CertificateGenHelper;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.security.exception.SMAccessTokenExpiredException;
import org.jkiss.dbeaver.model.security.exception.SMRefreshTokenExpiredException;
import org.jkiss.dbeaver.model.security.exception.SMTooManySessionsException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.GsonUtils;

public abstract class AbstractRemoteClient {
    private static final Log log = Log.getLog(AbstractRemoteClient.class);
    public static final int TOKEN_EXPIRED_ERROR_CODE = 440;
    public static final int REFRESH_TOKEN_EXPIRED_ERROR_CODE = 441;
    public static final int TOO_MANY_SESSIONS_ERROR_CODE = 442;
    public static final int DEFAULT_REQUEST_RETRIES = 30;
    public static final boolean DISABLE_SSL_CERT_VALIDATION = Boolean.getBoolean("dbeaver.ssl.disableCertificateValidation");
    private static final List<RestExceptionHandler> exceptionHandlers = new ArrayList<RestExceptionHandler>();
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 120000;
    public static final int DEFAULT_INIT_RETRY_COUNT = 300;
    public static final String TOO_MANY_SESSIONS = "tooManySessions";
    private static boolean runRequestsInAsyncMode;
    private static SSLContext nonValidatingSslContext;
    private final OkHttpClient httpClient;
    private final String apiUrl;
    protected Gson gson;

    public static boolean isRunRequestsInAsyncMode() {
        return runRequestsInAsyncMode;
    }

    public static void setRunRequestsInAsyncMode(boolean runRequestsInAsyncMode) {
        AbstractRemoteClient.runRequestsInAsyncMode = runRequestsInAsyncMode;
    }

    public static void addExceptionHandler(@NotNull RestExceptionHandler handler) {
        exceptionHandlers.add(handler);
    }

    public static void removeExceptionHandler(@NotNull RestExceptionHandler handler) {
        exceptionHandlers.remove(handler);
    }

    public AbstractRemoteClient(String apiUrl, List<Interceptor> interceptors) {
        this(apiUrl, 5000, 120000, interceptors);
    }

    public AbstractRemoteClient(@NotNull String apiUrl, int connectTimeout, int readTimeout, @NotNull List<Interceptor> interceptors) {
        this.apiUrl = apiUrl;
        this.httpClient = this.buildClient(connectTimeout, readTimeout, interceptors);
        this.gson = GsonUtils.gsonBuilder().create();
    }

    @NotNull
    private OkHttpClient buildClient(int connectTimeout, int readTimeout, List<Interceptor> interceptors) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient().newBuilder();
        httpClientBuilder.connectTimeout((long)(connectTimeout > 0 ? connectTimeout : 5000), TimeUnit.MILLISECONDS);
        httpClientBuilder.readTimeout((long)(readTimeout > 0 ? readTimeout : 120000), TimeUnit.MILLISECONDS);
        this.initSSL(httpClientBuilder);
        if (this.isInternalClient()) {
            httpClientBuilder.addInterceptor((Interceptor)new ClientVersionInterceptor());
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)httpClientBuilder).addInterceptor(arg_0));
        return httpClientBuilder.build();
    }

    private void initSSL(OkHttpClient.Builder clientBuilder) {
        if (DISABLE_SSL_CERT_VALIDATION) {
            try {
                clientBuilder.sslSocketFactory(AbstractRemoteClient.getNonValidatingSslContext().getSocketFactory(), CertificateGenHelper.NON_VALIDATING_TRUST_MANAGERS[0]);
                clientBuilder.hostnameVerifier((hostname, session) -> true);
            }
            catch (Exception e) {
                log.error((Object)"Error while initializing SSL for remote client", (Throwable)e);
            }
        }
    }

    @NotNull
    private static SSLContext getNonValidatingSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        if (nonValidatingSslContext == null) {
            nonValidatingSslContext = SSLContext.getInstance("SSL");
            nonValidatingSslContext.init(null, CertificateGenHelper.NON_VALIDATING_TRUST_MANAGERS, new SecureRandom());
        }
        return nonValidatingSslContext;
    }

    protected OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected <T> T executeGetRequest(String endpointUrl, Type type) throws DBException {
        return this.executeGetRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeGetRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executeGetRequest(endpointUrl, parameters, BodyConverter.JSON, type);
    }

    protected <T> T executeGetRequest(String endpointUrl, Map<String, ?> parameters, MediaType resultMediaType, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).build();
        return this.executeRequest(request, type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Type type) throws DBException {
        return this.executeDeleteRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executeDeleteRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Map<String, ?> parameters, Object body, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).delete(BodyConverter.convertFrom(this.gson, body, BodyConverter.JSON)).build();
        return this.executeRequest(request, type);
    }

    protected <T> T executePostRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executePostRequest(String endpointUrl, Object body, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, Map.of(), body, type);
    }

    protected <T> T executePostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, parameters, body, BodyConverter.JSON, type);
    }

    protected <T> T executePostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull MediaType mediaType, Type type) throws DBException {
        Request request = this.buildPostRequest(endpointUrl, parameters, body, mediaType);
        return this.executeRequest(request, type);
    }

    protected Request buildPostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull MediaType mediaType) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        RequestBody requestBody = BodyConverter.convertFrom(this.gson, body, mediaType);
        return new Request.Builder().url(url).post(requestBody).build();
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @Nullable Object body, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, Map.of(), body, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, parameters, body, BodyConverter.JSON, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull MediaType bodyMediaType, @NotNull Type type) throws DBException {
        Request request = new Request.Builder().url(this.buildUrl(endpointUrl, parameters)).put(BodyConverter.convertFrom(this.gson, body, bodyMediaType)).build();
        return this.executeRequest(request, type);
    }

    protected HttpUrl buildUrl(String endpointUrl, Map<String, ?> parameters) throws DBException {
        HttpUrl baseUrl = HttpUrl.parse((String)this.apiUrl);
        if (baseUrl == null) {
            throw new DBException("Could not parse url: " + this.apiUrl);
        }
        HttpUrl.Builder urlBuilder = baseUrl.newBuilder().addPathSegments(endpointUrl);
        parameters.forEach((paramName, value) -> {
            if (value == null) {
                return;
            }
            if (value instanceof byte[]) {
                urlBuilder.addQueryParameter(paramName, new String((byte[])value, StandardCharsets.UTF_8));
            } else if (value.getClass().isArray()) {
                Object[] array;
                Object[] objectArray = array = (Object[])value;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    urlBuilder.addQueryParameter(paramName, v.toString());
                    ++n2;
                }
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection array = (Collection)value;
                for (Object v : array) {
                    urlBuilder.addQueryParameter(paramName, v.toString());
                }
            } else {
                urlBuilder.addQueryParameter(paramName, value.toString());
            }
        });
        return urlBuilder.build();
    }

    /*
     * Unable to fully structure code
     */
    protected <T> T executeRequest(Request request, Type type) throws DBException {
        requestURL = request.url();
        AbstractRemoteClient.log.debug((Object)("--> Call: " + requestURL.scheme() + "://" + requestURL.host() + ":" + requestURL.port() + requestURL.encodedPath()));
        call = this.httpClient.newCall(request);
        try {
            if (type == InputStream.class) {
                return this.executeUnclosed(call, type, requestURL);
            }
            return this.executeClosed(call, type, requestURL);
        }
        catch (Exception e) {
            ** for (handler : AbstractRemoteClient.exceptionHandlers)
        }
lbl-1000:
        // 1 sources

        {
            handler.handle(e);
            continue;
        }
lbl12:
        // 1 sources

        this.handleRequestException(e);
        return null;
    }

    private <T> T executeClosed(Call call, Type type, HttpUrl requestURL) throws Exception {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Response response = AbstractRemoteClient.execute(call);){
            return this.processResponse(type, requestURL, response);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <T> T executeUnclosed(Call call, Type type, HttpUrl requestURL) throws Exception {
        Response response = AbstractRemoteClient.execute(call);
        return this.processResponse(type, requestURL, response);
    }

    private <T> T processResponse(Type type, HttpUrl requestURL, Response response) throws IOException, DBException {
        if (!response.isSuccessful()) {
            Object message = response.code() == 404 ? "Endpoint '" + String.valueOf(requestURL) + "' not recognized by remote server" : response.body().string();
            if (CommonUtils.isEmpty((String)message)) {
                message = "Error processing HTTP request: " + response.message();
            }
            if (response.code() == 440) {
                log.error((Object)("Access Token expired " + String.valueOf(requestURL)));
                throw new SMAccessTokenExpiredException((String)message);
            }
            if (response.code() == 441) {
                log.error((Object)("Refresh Token expired " + String.valueOf(requestURL)));
                throw new SMRefreshTokenExpiredException((String)message);
            }
            if (response.code() == 442) {
                log.error((Object)("Too many sessions " + String.valueOf(requestURL)));
                throw new SMTooManySessionsException((String)message);
            }
            log.error((Object)String.format("Failed to execute request %s - %s", requestURL, message));
            throw new DBException((String)message);
        }
        if (type == InputStream.class) {
            return (T)response.body().byteStream();
        }
        if (type == byte[].class) {
            return (T)response.body().bytes();
        }
        String jsonResponse = response.body().string();
        if (type == String.class) {
            return (T)jsonResponse;
        }
        return (T)this.gson.fromJson(jsonResponse, type);
    }

    public static String buildEndpointUrl(String ... pathParts) {
        return String.join((CharSequence)"/", pathParts);
    }

    protected void handleRequestException(Exception e) throws DBException {
        throw new DBCException(e.getMessage(), (Throwable)e);
    }

    @NotNull
    private static Response execute(final @NotNull Call call) throws Exception {
        if (!AbstractRemoteClient.isRunRequestsInAsyncMode()) {
            return call.execute();
        }
        String descr = "Execute remote call to " + String.join((CharSequence)"/", call.request().url().pathSegments());
        Future result = DBWorkbench.getPlatformUI().executeWithProgressBlocking(descr, (DBRRunnableWithResult)new DBRRunnableWithResult<Future<Response>>(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    this.result = CompletableFuture.completedFuture(call.execute());
                }
                catch (IOException ex) {
                    this.result = CompletableFuture.failedFuture(ex);
                }
            }

            public void cancel() {
                call.cancel();
            }
        });
        return (Response)result.get();
    }

    public boolean isInternalClient() {
        return true;
    }
}

