/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class TeradataZone
implements DBSObject,
DBPScriptObject {
    private String name;
    private String rootName;
    private String rootType;
    private String zoneDBAName;
    private String creatorName;
    private Date createdTimestamp;
    private final TeradataDatasource datasource;

    public TeradataZone(@NotNull TeradataDatasource datasource, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.name = name;
        this.rootName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RootName");
        this.rootType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RootType");
        this.zoneDBAName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ZoneDBAName");
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.datasource;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getRootName() {
        return this.rootName;
    }

    @Property(viewable=true, order=3)
    public String getRootType() {
        return "U".equals(this.rootType) ? "User" : "Database";
    }

    @Property(viewable=true, order=4)
    public String getZoneDBAName() {
        return this.zoneDBAName;
    }

    @Property(viewable=true, order=5)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=6)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return "CREATE ZONE " + DBUtils.getQuotedIdentifier((DBSObject)this) + " ROOT " + this.rootName;
    }
}

