/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import com.dbeaver.db.teradata.model.TeradataDatasource;
import com.dbeaver.db.teradata.model.TeradataMacro;
import com.dbeaver.db.teradata.model.TeradataMap;
import com.dbeaver.db.teradata.model.TeradataZone;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericDataType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.teradata.model.TeradataTrigger;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum TeradataObjectType implements DBSObjectType
{
    A("Function", "Aggregate function", GenericProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION),
    B("Function", "Combined aggregate and ordered analytical function", GenericProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION),
    C("Function", "Table operator parser contract function", GenericProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION),
    E("Procedure", "External stored procedure", GenericProcedure.class, (DBPImage)DBIcon.TREE_PROCEDURE),
    F("Function", "Standard function", GenericProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION),
    G("Trigger", "Table Trigger", TeradataTrigger.class, (DBPImage)DBIcon.TREE_TRIGGER),
    M("Macro", "Macro", TeradataMacro.class, (DBPImage)DBIcon.TREE_VIEW),
    O("Table", "Table with no primary index and no partitioning", GenericTable.class, (DBPImage)DBIcon.TREE_TABLE),
    P("Procedure", "Stored procedure", GenericProcedure.class, (DBPImage)DBIcon.TREE_PROCEDURE),
    Q("Table", "Queue table", GenericTable.class, (DBPImage)DBIcon.TREE_TABLE),
    R("Function", "Table function", GenericProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION),
    S("Function", "Ordered analytical function", GenericProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION),
    T("Table", "Table with a primary index, partitioning, or both", GenericTable.class, (DBPImage)DBIcon.TREE_TABLE),
    U("Type", "User-defined type", GenericDataType.class, (DBPImage)DBIcon.TREE_DATA_TYPE),
    V("View", "View", GenericView.class, (DBPImage)DBIcon.TREE_VIEW),
    COLUMN("Column", "Teradata Column", GenericTableColumn.class, (DBPImage)DBIcon.TREE_COLUMN),
    MAP("Map", "Teradata Map", TeradataMap.class, (DBPImage)DBIcon.TREE_DATA_TYPE),
    ZONE("Zone", "Teradata Zone", TeradataZone.class, (DBPImage)DBIcon.TREE_SESSIONS);

    private final String typeName;
    private final String description;
    private final Class<? extends DBSObject> theClass;
    private final DBPImage icon;
    private static final Log log;

    static {
        log = Log.getLog(TeradataObjectType.class);
    }

    private TeradataObjectType(String type, String description, Class<? extends DBSObject> theClass, DBPImage icon) {
        this.typeName = type;
        this.description = description;
        this.theClass = theClass;
        this.icon = icon;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getImage() {
        return this.icon;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.theClass;
    }

    @Nullable
    public DBSObject findObject(@NotNull DBRProgressMonitor monitor, @Nullable GenericObjectContainer schema, @NotNull String objectName) throws DBException {
        if (schema == null) {
            log.debug((Object)("Null schema in table " + objectName + " search (" + objectName + ")"));
            return null;
        }
        if (GenericTable.class.isAssignableFrom(this.theClass) || GenericView.class.isAssignableFrom(this.theClass)) {
            return schema.getChild(monitor, objectName);
        }
        if (TeradataTrigger.class.isAssignableFrom(this.theClass)) {
            return schema.getTableTrigger(monitor, objectName);
        }
        if (GenericProcedure.class.isAssignableFrom(this.theClass)) {
            return schema.getProcedure(monitor, objectName);
        }
        if (schema instanceof TeradataDatabase && TeradataMacro.class.isAssignableFrom(this.theClass)) {
            return ((TeradataDatabase)schema).getMacro(monitor, objectName);
        }
        GenericDataSource dataSource = schema.getDataSource();
        if (dataSource instanceof TeradataDatasource) {
            if (TeradataZone.class.isAssignableFrom(this.theClass)) {
                return ((TeradataDatasource)dataSource).getZone(monitor, objectName);
            }
            if (TeradataMap.class.isAssignableFrom(this.theClass)) {
                return ((TeradataDatasource)dataSource).getMap(monitor, objectName);
            }
        }
        log.debug((Object)("Unsupported object type for Teradata objects search: " + this.name()));
        return null;
    }

    public static List<TeradataObjectType> getTypesForClass(@NotNull Class<?> theClass) {
        ArrayList<TeradataObjectType> result = new ArrayList<TeradataObjectType>();
        TeradataObjectType[] teradataObjectTypeArray = TeradataObjectType.values();
        int n = teradataObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TeradataObjectType ot = teradataObjectTypeArray[n2];
            if (ot.theClass == theClass) {
                result.add(ot);
            }
            ++n2;
        }
        return result;
    }
}

