/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatasource;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class TeradataMap
implements DBSObject,
DBPScriptObject,
DBPSystemObject {
    private final TeradataDatasource datasource;
    private String name;
    private String mapKind;
    private String parentMapName;
    private String creatorName;
    private String zoneName;
    private int numberOfAMPs;
    private Date createdTimestamp;
    private String description;
    private boolean isSystem;

    public TeradataMap(@NotNull TeradataDatasource datasource, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.datasource = datasource;
        this.name = name;
        this.mapKind = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"MapKind");
        this.parentMapName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ParentMapName");
        this.creatorName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CreatorName");
        this.zoneName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ZoneName");
        this.numberOfAMPs = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"NumberOfAMPs");
        this.createdTimestamp = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CreateTimeStamp");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CommentString");
        this.isSystem = "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"SystemDefined"));
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.datasource;
    }

    @NotNull
    public TeradataDatasource getDataSource() {
        return this.datasource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getMapKind() {
        return "S".equals(this.mapKind) ? "Sparse" : "Contiguous";
    }

    @Property(viewable=true, order=3)
    public String getParentMapName() {
        return this.parentMapName;
    }

    @Property(viewable=true, order=4)
    public String getCreatorName() {
        return this.creatorName;
    }

    @Property(viewable=true, order=5)
    public String getZoneName() {
        return this.zoneName;
    }

    @Property(viewable=true, order=6)
    public int getNumberOfAMPs() {
        return this.numberOfAMPs;
    }

    @Property(viewable=true, order=7)
    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Property(viewable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        return "CREATE MAP " + DBUtils.getQuotedIdentifier((DBSObject)this) + (String)(CommonUtils.isEmpty((String)this.parentMapName) ? "" : " FROM " + this.parentMapName) + (String)("S".equals(this.mapKind) && this.numberOfAMPs > 0 ? " SPARSE AMPCOUNT = " + this.numberOfAMPs : "");
    }

    public boolean isSystem() {
        return this.isSystem;
    }
}

