/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import com.dbeaver.db.teradata.model.TeradataDatabase;
import com.dbeaver.db.teradata.model.TeradataMap;
import com.dbeaver.db.teradata.model.TeradataProfile;
import com.dbeaver.db.teradata.model.TeradataRole;
import com.dbeaver.db.teradata.model.TeradataStructureAssistant;
import com.dbeaver.db.teradata.model.TeradataUser;
import com.dbeaver.db.teradata.model.TeradataZone;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.teradata.model.TeradataSQLDialect;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceWithOptionalElements;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class TeradataDatasource
extends GenericDataSource
implements DBPDataSourceWithOptionalElements {
    private List<TeradataDatabase> topLevelDatabases = new ArrayList<TeradataDatabase>();
    private final ZoneCache zoneCache = new ZoneCache();
    private final MapCache mapCache = new MapCache();
    private final UserCache userCache = new UserCache();
    private final RoleCache roleCache = new RoleCache();
    private final ProfileCache profileCache = new ProfileCache();

    public TeradataDatasource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new TeradataSQLDialect());
    }

    void addDatabaseToFirstLevel(@NotNull TeradataDatabase database) {
        this.topLevelDatabases.add(database);
    }

    @Association
    public List<? extends GenericSchema> getCatalogsList() {
        if (this.showDatabasesHierarchically() && !CommonUtils.isEmpty(this.topLevelDatabases)) {
            return this.topLevelDatabases;
        }
        List catalogs = this.getSchemas();
        if (!CommonUtils.isEmpty((Collection)catalogs)) {
            catalogs.sort(DBUtils.nameComparatorIgnoreCase());
        }
        return catalogs;
    }

    boolean showDatabasesHierarchically() {
        return CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("show-db-hierarchically@"));
    }

    public boolean hasOptionalFolders() {
        return !this.showDatabasesHierarchically();
    }

    @Association
    public Collection<TeradataZone> getZones(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.zoneCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public TeradataZone getZone(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (TeradataZone)this.zoneCache.getObject(monitor, (DBSObject)this, name);
    }

    public MapCache getMapCache() {
        return this.mapCache;
    }

    @Association
    public Collection<TeradataMap> getMaps(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.mapCache.getAllObjects(monitor, (DBSObject)this);
    }

    Collection<TeradataMap> getMaps() {
        return this.mapCache.getCachedObjects();
    }

    @Association
    public TeradataMap getMap(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (TeradataMap)this.mapCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<TeradataUser> getUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public TeradataUser getUser(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (TeradataUser)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    public RoleCache getRoleCache() {
        return this.roleCache;
    }

    @Association
    public Collection<TeradataRole> getRoles(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public TeradataRole getRole(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (TeradataRole)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    public ProfileCache getProfileCache() {
        return this.profileCache;
    }

    @Association
    public Collection<TeradataProfile> getProfiles(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.profileCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public TeradataProfile getProfile(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (TeradataProfile)this.profileCache.getObject(monitor, (DBSObject)this, name);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new TeradataStructureAssistant(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.userCache.clearCache();
        this.roleCache.clearCache();
        this.profileCache.clearCache();
        this.mapCache.clearCache();
        this.zoneCache.clearCache();
        this.topLevelDatabases.clear();
        return super.refreshObject(monitor);
    }

    public class MapCache
    extends JDBCObjectLookupCache<TeradataDatasource, TeradataMap> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @Nullable TeradataMap object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM DBC.MapsV" + (object != null || objectName != null ? " WHERE MapName = ?" : "") + "\nORDER BY MapName";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected TeradataMap fetchObject(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @NotNull JDBCResultSet resultSet) {
            String mapName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"MapName");
            if (CommonUtils.isNotEmpty((String)mapName)) {
                return new TeradataMap(teradataDatasource, mapName, resultSet);
            }
            return null;
        }
    }

    public class ProfileCache
    extends JDBCObjectLookupCache<TeradataDatasource, TeradataProfile> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @Nullable TeradataProfile object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM DBC.ProfileInfoV" + (object != null || objectName != null ? " WHERE ProfileName = ?" : "") + "\nORDER BY ProfileName";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected TeradataProfile fetchObject(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @NotNull JDBCResultSet resultSet) {
            String profileName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ProfileName");
            if (CommonUtils.isNotEmpty((String)profileName)) {
                return new TeradataProfile(session.getProgressMonitor(), teradataDatasource, profileName, resultSet);
            }
            return null;
        }
    }

    public class RoleCache
    extends JDBCObjectLookupCache<TeradataDatasource, TeradataRole> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @Nullable TeradataRole object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM DBC.RoleInfoV" + (object != null || objectName != null ? " WHERE RoleName = ?" : "") + "\nORDER BY RoleName";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected TeradataRole fetchObject(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @NotNull JDBCResultSet resultSet) {
            String roleName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RoleName");
            if (CommonUtils.isNotEmpty((String)roleName)) {
                return new TeradataRole(teradataDatasource, roleName, resultSet);
            }
            return null;
        }
    }

    public class UserCache
    extends JDBCObjectLookupCache<TeradataDatasource, TeradataUser> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @Nullable TeradataUser object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM DBC.UsersV" + (object != null || objectName != null ? " WHERE UserName = ?" : "") + "\nORDER BY UserName";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected TeradataUser fetchObject(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @NotNull JDBCResultSet resultSet) {
            String userName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"UserName");
            if (CommonUtils.isNotEmpty((String)userName)) {
                return new TeradataUser(teradataDatasource, userName, resultSet);
            }
            return null;
        }
    }

    public class ZoneCache
    extends JDBCObjectLookupCache<TeradataDatasource, TeradataZone> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @Nullable TeradataZone object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT * FROM DBC.ZonesV" + (object != null || objectName != null ? " WHERE ZoneName = ?" : "") + "\nORDER BY ZoneName";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected TeradataZone fetchObject(@NotNull JDBCSession session, @NotNull TeradataDatasource teradataDatasource, @NotNull JDBCResultSet resultSet) {
            String zoneName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ZoneName");
            if (CommonUtils.isNotEmpty((String)zoneName)) {
                return new TeradataZone(teradataDatasource, zoneName, resultSet);
            }
            return null;
        }
    }
}

