/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.handlers;

import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditDomain;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.ui.ERDUIUtils;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorAdapter;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;

public class VQBFocusHandler
extends AbstractHandler {
    private static final String DIAGRAM_FOCUS = "org.jkiss.dbeaver.erd.focus.diagram";
    private static final String PALETTE_FOCUS = "org.jkiss.dbeaver.erd.focus.palette";
    private static final String OUTLINE_FOCUS = "org.jkiss.dbeaver.erd.focus.outline";
    private static final String PARAMETER_FOCUS = "org.jkiss.dbeaver.erd.focus.parameter";
    private static final String TABLE_FOCUS = "com.dbeaver.vqb.focus.table";
    private static final String QUERY_FOCUS = "com.dbeaver.vqb.focus.query";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        VQBEditorPresentation vqbPresentation = VQBFocusHandler.getVQBPresentation(event);
        if (vqbPresentation == null || vqbPresentation.getVQBEditor() == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.erd.focus.diagram": {
                vqbPresentation.getVQBEditor().getViewer().getControl().forceFocus();
                break;
            }
            case "org.jkiss.dbeaver.erd.focus.palette": {
                Object adapter = vqbPresentation.getVQBEditor().getAdapter(EditDomain.class);
                if (!(adapter instanceof EditDomain) || ((EditDomain)adapter).getPaletteViewer() == null) break;
                ((EditDomain)adapter).getPaletteViewer().getControl().setFocus();
                break;
            }
            case "org.jkiss.dbeaver.erd.focus.outline": {
                ERDUIUtils.openOutline();
                break;
            }
            case "org.jkiss.dbeaver.erd.focus.parameter": {
                ERDUIUtils.openProperties();
                break;
            }
            case "com.dbeaver.vqb.focus.query": {
                VQBEditorQueryPanel queryPanel = vqbPresentation.getQueryPanel();
                if (queryPanel == null) break;
                if (!queryPanel.isPreviewVisible()) {
                    queryPanel.togglePreview();
                }
                queryPanel.getPreviewEditor().setFocus();
                break;
            }
            case "com.dbeaver.vqb.focus.table": {
                if (vqbPresentation.getQueryPanel() == null) break;
                vqbPresentation.getQueryPanel().getFolderList().setFocus();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + event.getCommand().getId());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static VQBEditorPresentation getVQBPresentation(ExecutionEvent event) {
        Object activeEditor;
        Object object;
        VQBEditorPresentation presentation = null;
        Control control = (Control)HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeFocusControl");
        if (control != null) {
            presentation = ((VQBEditorPart)ERDEditorAdapter.getEditor((Control)control)).getPresentation();
        }
        if (presentation == null && (object = (activeEditor = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditor"))) instanceof SQLEditor) {
            void sqlEditor;
            SQLEditorPresentation activePresentation;
            SQLEditor sQLEditor = (SQLEditor)object;
            SQLEditor cfr_ignored_0 = (SQLEditor)object;
            SQLEditorPresentation sQLEditorPresentation = activePresentation = sqlEditor.getActivePresentation();
            if (sQLEditorPresentation instanceof VQBEditorPresentation) {
                void vqbEditorPresentation;
                VQBEditorPresentation vQBEditorPresentation = (VQBEditorPresentation)sQLEditorPresentation;
                VQBEditorPresentation cfr_ignored_1 = (VQBEditorPresentation)sQLEditorPresentation;
                return vqbEditorPresentation;
            }
        }
        return presentation;
    }
}

