/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

class VQBPanelQuerySelectItems
extends VQBPanelQueryElements<SelectItem> {
    private static final Log log = Log.getLog(VQBPanelQuerySelectItems.class);
    private static final String[] AGGREGATION_FUNCTIONS = new String[]{" ", "COUNT", "AVG", "MAX", "MIN", "SUM"};

    protected VQBPanelQuerySelectItems(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected void loadElements() {
        PlainSelect selectBody = this.getPlainSelect();
        if (selectBody != null) {
            this.elementViewer.setInput((Object)selectBody.getSelectItems());
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
    }

    private void replaceSelectItem(SelectItem oldItem, SelectItem newItem) {
        PlainSelect selectBody = this.getPlainSelect();
        if (selectBody != null) {
            List selectItems = selectBody.getSelectItems();
            int itemIndex = selectItems.indexOf(oldItem);
            if (itemIndex >= 0) {
                selectItems.set(itemIndex, newItem);
            } else {
                log.error((Object)("Can't find old select item [" + String.valueOf(oldItem) + "]"));
            }
        }
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, SelectItem> columnsController) {
        columnsController.addColumn("#", VQBMessages.editor_panel_select_items_column_item_position_description, 16384, true, true, selectItem -> {
            PlainSelect selectBody = this.getPlainSelect();
            if (selectBody != null) {
                return String.valueOf(selectBody.getSelectItems().indexOf(selectItem) + 1);
            }
            return null;
        }, null);
        VQBPanelQueryElements.ExpressionEditingSupport<SelectItem> expressionEditSupport = new VQBPanelQueryElements.ExpressionEditingSupport<SelectItem>((VQBPanelQueryElements)this){

            @Override
            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor cellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQuerySelectItems.this.elementViewer, (Composite)VQBPanelQuerySelectItems.this.elementViewer.getTree(), new String[0], 4);
                List attrNames = VQBUtils.getAttributeNames((ERDDiagram)VQBPanelQuerySelectItems.this.presentation.getVQBEditor().getDiagram(), (boolean)true);
                attrNames.add("*");
                cellEditor.setItems(attrNames.toArray(new String[0]));
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQuerySelectItems.this.presentation.getSQLEditor().getSite(), (Control)cellEditor.getControl());
                return cellEditor;
            }

            @Override
            protected boolean setValue(SelectItem selectItem, String text) {
                if (text.equals("*")) {
                    VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)new AllColumns());
                    return true;
                }
                if (text.endsWith(".*")) {
                    VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)new AllTableColumns(new Table(text.substring(0, text.length() - 2))));
                    return true;
                }
                return super.setValue(selectItem, text);
            }

            @Override
            protected String convertExpressionToString(SelectItem selectItem) {
                if (selectItem instanceof SelectExpressionItem) {
                    return ((SelectExpressionItem)selectItem).getExpression().toString();
                }
                return super.convertExpressionToString(selectItem);
            }

            @Override
            protected boolean updateElementExpression(SelectItem parent, SelectItem selectItem, Expression expression) {
                SelectExpressionItem newItem = new SelectExpressionItem(expression);
                if (selectItem instanceof SelectExpressionItem) {
                    GroupByElement groupBy;
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                    Expression selectExpression = selectExpressionItem.getExpression();
                    PlainSelect pSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                    if (pSelect != null && (groupBy = pSelect.getGroupBy()) != null) {
                        List groupByExpressions = groupBy.getGroupByExpressions();
                        List selectItems = pSelect.getSelectItems();
                        if (selectExpression instanceof Function) {
                            VQBPanelQuerySelectItems.this.addExpressionInGroupBy(expression, groupBy);
                            selectItems.remove(selectItem);
                            selectItems.add(newItem);
                            return true;
                        }
                        if (!VQBPanelQuerySelectItems.this.isExpressionInGroupBy(groupByExpressions, expression)) {
                            VQBPanelQuerySelectItems.this.addExpressionInGroupBy(expression, groupBy);
                        }
                        if (VQBPanelQuerySelectItems.this.isExpressionInGroupBy(groupByExpressions, selectExpression)) {
                            VQBUtils.removeExpressionFromGrouping((PlainSelect)pSelect, (SelectExpressionItem)selectExpressionItem, (GroupByElement)groupBy);
                        }
                        newItem.setAlias(selectExpressionItem.getAlias());
                    }
                }
                VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)newItem);
                return true;
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_select_items_columns_expression_name, VQBMessages.editor_panel_select_items_columns_expression_description, 16384, true, true, selectItem -> {
            if (selectItem instanceof SelectExpressionItem) {
                List groupByExpressions;
                GroupByElement groupBy;
                PlainSelect plainSelect;
                Expression expression = ((SelectExpressionItem)selectItem).getExpression();
                if (expression instanceof Column && (plainSelect = this.getPlainSelect()) != null && (groupBy = plainSelect.getGroupBy()) != null && !this.isExpressionInGroupBy(groupByExpressions = groupBy.getGroupByExpressions(), expression)) {
                    this.addExpressionInGroupBy(expression, groupBy);
                    this.refreshDiagramAndStatement();
                }
                return expression == null ? null : expression.toString();
            }
            return selectItem.toString();
        }, (EditingSupport)expressionEditSupport);
        VQBPanelQueryElements.TextEditingSupport<SelectItem> aliasEditingSupport = new VQBPanelQueryElements.TextEditingSupport<SelectItem>((VQBPanelQueryElements)this){

            @Override
            protected String convertExpressionToString(SelectItem selectItem) {
                if (selectItem instanceof SelectExpressionItem) {
                    Alias alias = ((SelectExpressionItem)selectItem).getAlias();
                    return alias == null ? "" : alias.getName();
                }
                return "";
            }

            @Override
            protected void updateElementText(SelectItem selectItem, String text) {
                if (selectItem instanceof SelectExpressionItem) {
                    if (CommonUtils.isEmpty((String)text)) {
                        ((SelectExpressionItem)selectItem).setAlias(null);
                    } else {
                        ((SelectExpressionItem)selectItem).setAlias(new Alias(text));
                    }
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_select_items_columns_alias_name, VQBMessages.editor_panel_select_items_columns_alias_description, 16384, true, false, selectItem -> {
            Alias alias;
            if (selectItem instanceof SelectExpressionItem && (alias = ((SelectExpressionItem)selectItem).getAlias()) != null) {
                return alias.getName();
            }
            return null;
        }, (EditingSupport)aliasEditingSupport);
        EditingSupport groupByEditingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object o) {
                return new CustomCheckboxCellEditor((Composite)VQBPanelQuerySelectItems.this.elementViewer.getTree());
            }

            protected boolean canEdit(Object o) {
                if (o instanceof SelectExpressionItem) {
                    Expression expression = ((SelectExpressionItem)o).getExpression();
                    if (expression instanceof Function) {
                        return !((Function)expression).isAllColumns();
                    }
                    return true;
                }
                return o instanceof Column;
            }

            protected Object getValue(Object element) {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                if (plainSelect != null) {
                    GroupByElement groupBy = plainSelect.getGroupBy();
                    if (groupBy != null) {
                        List groupByExpr = groupBy.getGroupByExpressions();
                        Expression expression = ((SelectExpressionItem)element).getExpression();
                        return VQBPanelQuerySelectItems.this.isExpressionInGroupBy(groupByExpr, expression);
                    }
                    return false;
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                SelectBody selectBody = VQBPanelQuerySelectItems.this.getQueryInfo().getParsedQuery().getSelectBody();
                if (selectBody instanceof PlainSelect && element instanceof SelectExpressionItem) {
                    PlainSelect pSelect = (PlainSelect)selectBody;
                    GroupByElement groupBy = pSelect.getGroupBy();
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)element;
                    Expression elementExpression = ((SelectExpressionItem)element).getExpression();
                    List selectItems = pSelect.getSelectItems();
                    if (Boolean.TRUE.equals(value)) {
                        if (groupBy == null) {
                            GroupByElement groupByElement = new GroupByElement();
                            if (elementExpression instanceof Function) {
                                Expression functionExpression = (Expression)((Function)elementExpression).getParameters().getExpressions().get(0);
                                VQBPanelQuerySelectItems.this.replaceFunctionToSelectItem(selectItems, functionExpression, selectExpressionItem);
                                groupByElement.addGroupByExpression(functionExpression);
                            } else {
                                groupByElement.addGroupByExpression(elementExpression);
                                if (selectItems.size() == 1) {
                                    Function countFunction = new Function();
                                    countFunction.setName("COUNT");
                                    countFunction.setParameters(new ExpressionList(new Expression[]{new AllColumns()}));
                                    SelectExpressionItem newItem = new SelectExpressionItem((Expression)countFunction);
                                    selectItems.add(newItem);
                                }
                            }
                            pSelect.setGroupByElement(groupByElement);
                        } else if (elementExpression instanceof Function) {
                            Function function = (Function)elementExpression;
                            if (function.isAllColumns()) {
                                return;
                            }
                            Expression functionExpression = (Expression)((Function)elementExpression).getParameters().getExpressions().get(0);
                            VQBPanelQuerySelectItems.this.replaceFunctionToSelectItem(selectItems, functionExpression, selectExpressionItem);
                            VQBPanelQuerySelectItems.this.addExpressionInGroupBy(functionExpression, groupBy);
                        } else {
                            VQBPanelQuerySelectItems.this.addExpressionInGroupBy(elementExpression, groupBy);
                        }
                        VQBPanelQuerySelectItems.this.selectItemsAggregation(pSelect, element);
                    } else if (Boolean.FALSE.equals(value) && groupBy != null && VQBPanelQuerySelectItems.this.isExpressionInGroupBy(groupBy.getGroupByExpressions(), elementExpression)) {
                        VQBUtils.removeExpressionFromGrouping((PlainSelect)pSelect, (SelectExpressionItem)selectExpressionItem, (GroupByElement)groupBy);
                    }
                    VQBPanelQuerySelectItems.this.refreshDiagramAndStatement();
                }
            }
        };
        columnsController.addBooleanColumn(VQBMessages.editor_panel_select_items_columns_grouping_name, VQBMessages.editor_panel_select_items_columns_grouping_description, 16384, true, false, selectItem -> {
            GroupByElement groupBy;
            SelectBody selectBody = this.getQueryInfo().getParsedQuery().getSelectBody();
            if (selectBody instanceof PlainSelect && !(selectItem instanceof AllColumns) && !(selectItem instanceof AllTableColumns) && (groupBy = ((PlainSelect)selectBody).getGroupBy()) != null) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                Expression expression = selectExpressionItem.getExpression();
                List groupByExpr = groupBy.getGroupByExpressions();
                if (!(expression instanceof Function)) {
                    return this.isExpressionInGroupBy(groupByExpr, expression);
                }
            }
            return false;
        }, groupByEditingSupport);
        VQBPanelQueryElements.ExpressionEditingSupport<SelectItem> groupingExpressionEditSupport = new VQBPanelQueryElements.ExpressionEditingSupport<SelectItem>((VQBPanelQueryElements)this){

            @Override
            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQuerySelectItems.this.elementViewer, (Composite)VQBPanelQuerySelectItems.this.elementViewer.getTree(), new String[0], 4);
                editor.setItems(AGGREGATION_FUNCTIONS);
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQuerySelectItems.this.presentation.getSQLEditor().getSite(), (Control)editor.getControl());
                return editor;
            }

            @Override
            protected boolean setValue(SelectItem selectItem, String text) {
                return super.setValue(selectItem, text);
            }

            @Override
            protected String convertExpressionToString(SelectItem selectItem) {
                if (selectItem instanceof SelectExpressionItem) {
                    Expression expression = ((SelectExpressionItem)selectItem).getExpression();
                    if (expression instanceof Function) {
                        return ((Function)expression).getName();
                    }
                    return "";
                }
                return super.convertExpressionToString(selectItem);
            }

            @Override
            protected boolean updateElementExpression(SelectItem parent, SelectItem selectItem, Expression expression) {
                Expression selectItemExpression = ((SelectExpressionItem)selectItem).getExpression();
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                if (expression == null && plainSelect != null && selectItemExpression instanceof Function) {
                    Expression functionExpression = (Expression)((Function)selectItemExpression).getParameters().getExpressions().get(0);
                    VQBPanelQuerySelectItems.this.replaceFunctionToSelectItem(VQBPanelQuerySelectItems.this.getPlainSelect().getSelectItems(), functionExpression, (SelectExpressionItem)selectItem);
                    GroupByElement groupBy = plainSelect.getGroupBy();
                    if (groupBy != null) {
                        VQBPanelQuerySelectItems.this.addExpressionInGroupBy(functionExpression, groupBy);
                    }
                }
                if (expression instanceof Function) {
                    if (!(selectItemExpression instanceof Function)) {
                        Function function = (Function)expression;
                        Expression expressionSelect = ((SelectExpressionItem)selectItem).getExpression();
                        ExpressionList exprList = new ExpressionList();
                        exprList.setExpressions(Collections.singletonList(expressionSelect));
                        function.setParameters(exprList);
                        SelectExpressionItem newItem = new SelectExpressionItem((Expression)function);
                        VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)newItem);
                    } else {
                        ((Function)selectItemExpression).setName(((Function)expression).getName());
                    }
                } else {
                    ExpressionList expressionList;
                    Function customFunction = new Function();
                    if (!(selectItemExpression instanceof Function)) {
                        expressionList = new ExpressionList(Collections.singletonList(selectItemExpression));
                    } else {
                        ExpressionList expressionFunctionList = ((Function)selectItemExpression).getParameters();
                        if (expressionFunctionList == null) {
                            return false;
                        }
                        expressionList = new ExpressionList(((Function)selectItemExpression).getParameters().getExpressions());
                    }
                    customFunction.setParameters(expressionList);
                    if (expression != null) {
                        GroupByElement groupBy;
                        customFunction.setName(expression.toString());
                        SelectExpressionItem customSelectItem = new SelectExpressionItem((Expression)customFunction);
                        VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)customSelectItem);
                        if (plainSelect != null && (groupBy = plainSelect.getGroupBy()) != null) {
                            VQBUtils.removeExpressionFromGrouping((PlainSelect)plainSelect, (SelectExpressionItem)((SelectExpressionItem)selectItem), (GroupByElement)groupBy);
                        }
                    }
                }
                return true;
            }

            @Override
            protected boolean canEdit(Object element) {
                Expression expression;
                if (element instanceof SelectExpressionItem && (expression = ((SelectExpressionItem)element).getExpression()) instanceof Function) {
                    return !((Function)expression).isAllColumns();
                }
                return !(element instanceof AllColumns) && !(element instanceof AllTableColumns);
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_select_items_columns_function_name, VQBMessages.editor_panel_select_items_columns_function_description, 16384, true, true, selectItem -> {
            Expression expression;
            if (selectItem instanceof SelectExpressionItem && (expression = ((SelectExpressionItem)selectItem).getExpression()) instanceof Function) {
                return ((Function)expression).getName();
            }
            return "";
        }, (EditingSupport)groupingExpressionEditSupport);
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return DBIcon.TREE_COLUMN;
    }

    @Override
    protected void fillPanelContributions(IContributionManager contributionManager) {
        super.fillPanelContributions(contributionManager);
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_select_items_action_add_column, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                if (plainSelect != null) {
                    ArrayList<SelectExpressionItem> selectItems = plainSelect.getSelectItems();
                    if (selectItems == null) {
                        selectItems = new ArrayList<SelectExpressionItem>();
                        plainSelect.setSelectItems(selectItems);
                    }
                    SelectItem selectedItem = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                    SelectExpressionItem newElement = new SelectExpressionItem((Expression)new LongValue(1L));
                    if (selectedItem != null) {
                        selectItems.add(selectItems.indexOf(selectedItem) + 1, newElement);
                    } else {
                        selectItems.add(newElement);
                    }
                    VQBPanelQuerySelectItems.this.addNewElement(newElement, 1);
                }
            }
        });
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_select_items_action_remove, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                if (plainSelect == null) {
                    log.error((Object)"No plain select. Cannot remove condition.");
                    return;
                }
                SelectItem selectedExpression = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                if (selectedExpression != null) {
                    GroupByElement groupBy = plainSelect.getGroupBy();
                    List selectItems = plainSelect.getSelectItems();
                    selectItems.remove(selectedExpression);
                    if (groupBy != null) {
                        VQBUtils.removeExpressionFromGrouping((PlainSelect)plainSelect, (SelectExpressionItem)((SelectExpressionItem)selectedExpression), (GroupByElement)groupBy);
                    }
                    VQBPanelQuerySelectItems.this.refreshDiagramAndStatement();
                }
            }

            public boolean isEnabled() {
                return VQBPanelQuerySelectItems.this.getSelectedElement() != null;
            }
        });
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_select_items_action_move_up, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_UP)){

            public void run() {
                VQBPanelQuerySelectItems.this.moveElementTo(-1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                SelectItem selectedElement = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                return plainSelect != null && plainSelect.getSelectItems() != null && selectedElement != null && plainSelect.getSelectItems().indexOf(selectedElement) > 0;
            }
        });
        contributionManager.add((IAction)new Action(VQBMessages.editor_panel_select_items_action_move_down, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_DOWN)){

            public void run() {
                VQBPanelQuerySelectItems.this.moveElementTo(1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                SelectItem selectedElement = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                return plainSelect != null && plainSelect.getSelectItems() != null && selectedElement != null && plainSelect.getSelectItems().indexOf(selectedElement) < plainSelect.getSelectItems().size() - 1;
            }
        });
    }

    private void moveElementTo(int shift) {
        List selectItems;
        SelectItem selectedElement = (SelectItem)this.getSelectedElement();
        PlainSelect plainSelect = this.getPlainSelect();
        if (selectedElement != null && plainSelect != null && (selectItems = plainSelect.getSelectItems()) != null) {
            this.updateSelectedElementsAndRefresh(selectedElement, selectItems, selectItems.indexOf(selectedElement) + shift);
        }
    }

    @Override
    protected boolean supportsElementsMove() {
        return true;
    }

    @Override
    protected void moveElementTo(SelectItem srcElement, SelectItem dstElement) {
        List selectItems;
        PlainSelect plainSelect = this.getPlainSelect();
        if (plainSelect != null && (selectItems = plainSelect.getSelectItems()) != null) {
            this.updateSelectedElementsAndRefresh(srcElement, selectItems, selectItems.indexOf(dstElement));
        }
    }

    private void updateSelectedElementsAndRefresh(@NotNull SelectItem srcElement, @NotNull List<SelectItem> selectItems, int newIndex) {
        if (selectItems.remove(srcElement)) {
            selectItems.add(newIndex, srcElement);
            VQBEditorQueryPanel queryPanel = this.presentation.getQueryPanel();
            if (queryPanel != null) {
                queryPanel.refreshActions();
            }
            this.refreshDiagramAndStatement();
        }
    }

    private void selectItemsAggregation(PlainSelect plainSelect, Object element) {
        List selectItemsList = plainSelect.getSelectItems();
        GroupByElement groupBy = plainSelect.getGroupBy();
        for (SelectItem sItem : selectItemsList) {
            if (sItem.toString().equals(element.toString())) continue;
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)sItem;
            Expression expression = selectExpressionItem.getExpression();
            if (groupBy == null) {
                if (expression instanceof Function) continue;
                VQBUtils.addDefaultAggregateFunction((SelectExpressionItem)selectExpressionItem);
                continue;
            }
            if (expression instanceof Function || this.isExpressionInGroupBy(groupBy.getGroupByExpressions(), expression)) continue;
            VQBUtils.addDefaultAggregateFunction((SelectExpressionItem)selectExpressionItem);
        }
    }

    private boolean isExpressionInGroupBy(@NotNull List<Expression> groupingExpressions, @NotNull Expression expression) {
        Column column;
        if (expression instanceof Column && (column = (Column)expression).getTable() == null) {
            for (Expression expr : groupingExpressions) {
                String columnName = VQBUtils.getColumnNameFromExpression((Expression)expr);
                if (columnName == null || !columnName.equals(column.getColumnName())) continue;
                return true;
            }
        }
        return groupingExpressions.stream().anyMatch(e -> e.toString().equals(expression.toString()));
    }

    private void replaceFunctionToSelectItem(List<SelectItem> selectItems, Expression functionExpression, SelectExpressionItem element) {
        SelectExpressionItem newItem = new SelectExpressionItem(functionExpression);
        int index = selectItems.indexOf(element);
        selectItems.remove(element);
        selectItems.add(index, (SelectItem)newItem);
    }

    private void addExpressionInGroupBy(Expression expression, GroupByElement groupBy) {
        List groupByExpressions = groupBy.getGroupByExpressions();
        boolean hasExpression = false;
        if (this.isExpressionInGroupBy(groupByExpressions, expression)) {
            hasExpression = true;
        }
        if (!hasExpression) {
            groupBy.addGroupByExpression(expression);
        }
    }
}

