/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQuerySelectItems;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBJoinType;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.CommonUtils;

class VQBPanelQueryJoins
extends VQBPanelQueryElements<Object> {
    private static final Log log = Log.getLog(VQBPanelQuerySelectItems.class);

    protected VQBPanelQueryJoins(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected TreeContentProvider makeContentProvider() {
        return new TreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Join) {
                    return this.getChildren(inputElement);
                }
                return super.getElements(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Join) {
                    Expression conditions = VQBPanelQueryJoins.this.getJoinConditions((Join)parentElement);
                    if (conditions == null) {
                        return null;
                    }
                    ArrayList<Expression> result = new ArrayList<Expression>();
                    if (VQBUtils.isCompoundExpression((Expression)conditions)) {
                        VQBUtils.collectNestedConditions((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), result, (Expression)conditions, (Expression)conditions);
                    } else {
                        result.add(conditions);
                    }
                    return result.toArray();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Join) {
                    return VQBPanelQueryJoins.this.getJoinConditions((Join)element) != null;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void loadElements() {
        SelectBody selectBody = this.getQueryInfo().getParsedQuery().getSelectBody();
        SelectBody selectBody2 = selectBody;
        if (selectBody2 instanceof PlainSelect) {
            void select;
            PlainSelect plainSelect = (PlainSelect)selectBody2;
            PlainSelect cfr_ignored_0 = (PlainSelect)selectBody2;
            ArrayList<FromItem> items = new ArrayList<FromItem>();
            items.add(select.getFromItem());
            if (select.getJoins() != null) {
                items.addAll(select.getJoins());
            }
            this.elementViewer.setInput(items);
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
        this.elementViewer.expandAll();
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, Object> columnsController) {
        super.fillColumns(columnsController);
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_join_conditions_name, VQBMessages.editor_panel_joins_columns_join_conditions_description, 16384, true, true, item -> {
            Object object = item;
            if (object instanceof Join) {
                void join;
                Join join2 = (Join)object;
                Join cfr_ignored_0 = (Join)object;
                FromItem rightItem = join.getRightItem();
                if (rightItem instanceof Table) {
                    return ((Table)rightItem).getFullyQualifiedName();
                }
            } else {
                Object object2 = item;
                if (object2 instanceof Table) {
                    void from;
                    Table rightItem = (Table)object2;
                    Table cfr_ignored_1 = (Table)object2;
                    return from.getFullyQualifiedName();
                }
                if (item instanceof Expression) {
                    return item.toString();
                }
            }
            return null;
        }, null);
        EditingSupport typeEditingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object element) {
                CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryJoins.this.elementViewer, (Composite)VQBPanelQueryJoins.this.elementViewer.getTree(), new String[0], 12);
                VQBJoinType[] types = VQBJoinType.values();
                ArrayList<String> typeNames = new ArrayList<String>();
                VQBJoinType[] vQBJoinTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    VQBJoinType type = vQBJoinTypeArray[n2];
                    if (type.isSupported()) {
                        typeNames.add(type.getName());
                    }
                    ++n2;
                }
                editor.setItems(typeNames.toArray(new String[typeNames.size()]));
                return editor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Join;
            }

            protected Object getValue(Object element) {
                if (element instanceof Join) {
                    return VQBJoinType.getByJoin((Join)((Join)element)).getName();
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            protected void setValue(Object element, Object value) {
                Object object = element;
                if (object instanceof Join) {
                    void join;
                    Join join2 = (Join)object;
                    Join cfr_ignored_0 = (Join)object;
                    VQBJoinType oldType = VQBJoinType.getByJoin((Join)join);
                    VQBJoinType newType = VQBJoinType.getByName((String)((String)value));
                    if (oldType != newType) {
                        ERDJoin erdJoin;
                        newType.setJoinType((Join)join);
                        if (newType != VQBJoinType.SIMPLE && (erdJoin = VQBUtils.findERDJoin((ERDDiagram)VQBPanelQueryJoins.this.presentation.getVQBEditor().getDiagram(), (Join)join)) != null) {
                            join.setOnExpressions((Collection)erdJoin.makeExpressionFromConditions());
                        }
                        VQBPanelQueryJoins.this.refreshDiagramAndStatement();
                    }
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_join_type_name, VQBMessages.editor_panel_joins_columns_join_type_description, 16384, true, true, item -> {
            Object object = item;
            if (object instanceof Join) {
                void join;
                Join join2 = (Join)object;
                Join cfr_ignored_0 = (Join)object;
                return VQBJoinType.getByJoin((Join)join).getName();
            }
            if (item instanceof Table) {
                return VQBMessages.editor_panel_joins_columns_from_name;
            }
            return null;
        }, typeEditingSupport);
        VQBPanelQueryElements.TextEditingSupport<Object> aliasEditingSupport = new VQBPanelQueryElements.TextEditingSupport<Object>((VQBPanelQueryElements)this){

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof Join || element instanceof Table;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected String convertExpressionToString(Object object) {
                Object object2 = object;
                if (object2 instanceof Join) {
                    void join;
                    Join join2 = (Join)object2;
                    Join cfr_ignored_0 = (Join)object2;
                    Alias alias = join.getRightItem().getAlias();
                    return alias == null ? "" : alias.getName();
                }
                Object object3 = object;
                if (object3 instanceof Table) {
                    void from;
                    Table alias = (Table)object3;
                    Table cfr_ignored_1 = (Table)object3;
                    Alias alias2 = from.getAlias();
                    return alias2 == null ? "" : alias2.getName();
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected boolean validate(Object element, Object alias) {
                SelectBody selectBody = VQBPanelQueryJoins.this.getQueryInfo().getParsedQuery().getSelectBody();
                if (selectBody instanceof PlainSelect) {
                    void select;
                    PlainSelect plainSelect = (PlainSelect)selectBody;
                    PlainSelect cfr_ignored_0 = (PlainSelect)selectBody;
                    if (select.getFromItem() != null && select.getFromItem().getAlias().getName().equals(alias)) {
                        return false;
                    }
                    for (Join join : select.getJoins()) {
                        if (join.getRightItem() == null || join.getRightItem().getAlias() == null || !join.getRightItem().getAlias().getName().equals(alias)) continue;
                        return false;
                    }
                }
                return super.validate(element, alias);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void updateElementText(Object join, String text) {
                if (join instanceof Join) {
                    Alias alias;
                    Alias alias2 = alias = CommonUtils.isEmpty((String)text) ? null : new Alias(text);
                    if (((Join)join).getRightItem() instanceof Table) {
                        VQBUtils.updateTableAlias((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), (Table)((Table)((Join)join).getRightItem()), (Alias)alias);
                    }
                } else {
                    Object object = join;
                    if (object instanceof Table) {
                        void from;
                        Table alias = (Table)object;
                        Table cfr_ignored_0 = (Table)object;
                        Alias alias3 = CommonUtils.isEmpty((String)text) ? null : new Alias(text);
                        VQBUtils.updateTableAlias((VQBQueryInfo)VQBPanelQueryJoins.this.getQueryInfo(), (Table)from, (Alias)alias3);
                    }
                }
            }
        };
        columnsController.addColumn(VQBMessages.editor_panel_joins_columns_alias_name, VQBMessages.editor_panel_joins_columns_alias_description, 16384, true, true, item -> {
            if (item instanceof Join) {
                Alias alias = ((Join)item).getRightItem().getAlias();
                return alias == null ? null : alias.getName();
            }
            if (item instanceof Table) {
                Alias alias = ((Table)item).getAlias();
                return alias == null ? null : alias.getName();
            }
            return null;
        }, (EditingSupport)aliasEditingSupport);
    }

    @Override
    protected void fillPanelContributions(IContributionManager contributionManager) {
        super.fillPanelContributions(contributionManager);
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return null;
    }

    private Expression getJoinConditions(Join join) {
        if (join.isSimple()) {
            return null;
        }
        return VQBUtils.getJoinOnExpression((Join)join);
    }
}

