/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelProperties;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryJoins;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryOrderBy;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQuerySelectItems;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryWhere;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderComposite;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderInfo;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentationPanel;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class VQBEditorQueryPanel
implements SQLEditorPresentationPanel {
    private static final Log log = Log.getLog(VQBEditorQueryPanel.class);
    public static final String FOLDER_ID_PROPERTIES = "properties";
    public static final String FOLDER_ID_SELECT = "select";
    public static final String FOLDER_ID_WHERE = "where";
    public static final String FOLDER_ID_JOINS = "joins";
    public static final String FOLDER_ID_ORDER_BY = "orderBy";
    public static final String FOLDER_ID_OTHER = "other";
    public static final String PANEL_ID = "vqb_settings";
    private VQBEditorPresentation vqbPresentation;
    private CustomSashForm panelDivider;
    private SQLEditorBase previewEditor;
    private ToolBarManager panelsToolbar;
    private TabbedFolderComposite folderList;

    public static IDialogSettings getPanelSettings() {
        return UIUtils.getDialogSettings((String)"DBeaver.VQBEditorQueryPanel");
    }

    public Control createPanel(Composite parent, SQLEditor editor, SQLEditorPresentation presentation) {
        this.vqbPresentation = (VQBEditorPresentation)presentation;
        this.panelDivider = UIUtils.createPartDivider((IWorkbenchPart)this.vqbPresentation.getSQLEditor(), (Composite)parent, (int)256);
        this.panelDivider.setShowBorders(true);
        Composite leftSide = UIUtils.createPlaceholder((Composite)this.panelDivider, (int)2);
        this.folderList = new TabbedFolderComposite(leftSide, 16388);
        TabbedFolderInfo[] folders = new TabbedFolderInfo[]{new TabbedFolderInfo(FOLDER_ID_SELECT, "Columns", (DBPImage)UIIcon.CONFIGURATION, "SELECT items/columns", false, (ITabbedFolder)new VQBPanelQuerySelectItems(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_WHERE, "Conditions", (DBPImage)UIIcon.CONFIGURATION, "WHERE conditions", false, (ITabbedFolder)new VQBPanelQueryWhere(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_JOINS, "Joins", (DBPImage)UIIcon.CONFIGURATION, "Tables participating in query", false, (ITabbedFolder)new VQBPanelQueryJoins(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_ORDER_BY, "Sorting", (DBPImage)UIIcon.CONFIGURATION, "ORDER BY conditions", false, (ITabbedFolder)new VQBPanelQueryOrderBy(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_OTHER, "Miscellaneous", (DBPImage)UIIcon.CONFIGURATION, "Miscellaneous query settings (offset, limit, etc))", false, (ITabbedFolder)new VQBPanelProperties(this.vqbPresentation))};
        this.folderList.setFolders(PANEL_ID, folders);
        this.folderList.setLayoutData((Object)new GridData(1808));
        this.panelsToolbar = new ToolBarManager(512);
        ToolBar toolBar = this.panelsToolbar.createControl(leftSide);
        GridData gd = new GridData(1040);
        gd.horizontalIndent = 3;
        gd.verticalIndent = 3;
        toolBar.setLayoutData((Object)gd);
        this.folderList.addFolderListener(folderId -> {
            this.panelsToolbar.removeAll();
            ITabbedFolder activeFolder = this.folderList.getActiveFolder();
            if (activeFolder instanceof VQBPanelQueryElements) {
                ((VQBPanelQueryElements)activeFolder).fillPanelContributions((IContributionManager)this.panelsToolbar);
            }
            this.panelsToolbar.update(true);
        });
        if (this.folderList.getActiveFolder() == null) {
            this.folderList.switchFolder(FOLDER_ID_SELECT);
        }
        this.createPreviewPanel(this.panelDivider);
        if (VQBEditorQueryPanel.getPanelSettings().getBoolean("previewHidden")) {
            this.panelDivider.setMaximizedControl(this.panelDivider.getChildren()[0]);
        }
        return this.panelDivider;
    }

    private void createPreviewPanel(CustomSashForm parent) {
        this.previewEditor = new SQLEditorBase(){

            public DBCExecutionContext getExecutionContext() {
                return VQBEditorQueryPanel.this.vqbPresentation.getSQLEditor().getExecutionContext();
            }
        };
        IEditorInput previewInput = this.createQueryInput();
        try {
            this.previewEditor.init((IEditorSite)new SubEditorSite((IWorkbenchPartSite)this.vqbPresentation.getSQLEditor().getEditorSite()), previewInput);
            this.previewEditor.createPartControl((Composite)parent);
            this.previewEditor.reloadSyntaxRules();
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Create error", "Can't create SQL preview editor", (Throwable)e);
        }
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.vqbPresentation.getSQLEditor().getSite(), (Control)this.previewEditor.getTextViewer().getTextWidget());
    }

    private IEditorInput createQueryInput() {
        VQBQueryInfo queryInfo = this.vqbPresentation.getVQBEditor().getQueryInfo();
        return new StringEditorInput("SQL Preview", (CharSequence)(queryInfo == null ? "" : queryInfo.getQuery().getText()), true, GeneralUtils.getDefaultFileEncoding());
    }

    public SQLEditorBase getPreviewEditor() {
        return this.previewEditor;
    }

    public TabbedFolderComposite getFolderList() {
        return this.folderList;
    }

    public void activatePanel() {
    }

    public void deactivatePanel() {
    }

    public void refreshActions() {
        UIUtils.updateContributionItems((IContributionManager)this.panelsToolbar);
    }

    public void refreshFromStatement(boolean refreshPanels) {
        this.vqbPresentation.getVQBEditor().getQueryInfo().refreshStatement(true);
        if (refreshPanels) {
            TabbedFolderInfo[] tabbedFolderInfoArray = this.folderList.getFolders();
            int n = tabbedFolderInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabbedFolderInfo folder = tabbedFolderInfoArray[n2];
                if (folder.getContents() instanceof VQBPanelQueryElements) {
                    ((VQBPanelQueryElements)folder.getContents()).refreshElementsFromStatement();
                }
                ++n2;
            }
        }
        this.previewEditor.setInput(this.createQueryInput());
        this.previewEditor.reloadSyntaxRules();
    }

    public void updateActions() {
        UIUtils.updateContributionItems((IContributionManager)this.panelsToolbar);
    }

    public boolean isPreviewVisible() {
        return this.panelDivider.getMaximizedControl() == null;
    }

    public void togglePreview() {
        if (this.panelDivider.getMaximizedControl() == null) {
            this.panelDivider.setMaximizedControl((Control)this.folderList.getParent());
        } else {
            this.panelDivider.setMaximizedControl(null);
        }
        VQBEditorQueryPanel.getPanelSettings().put("previewHidden", this.panelDivider.getMaximizedControl() != null);
    }

    public boolean isTextEditMode() {
        if (!this.vqbPresentation.getSQLEditor().showPresentationPanel((SQLEditorPresentationPanel)this)) {
            return false;
        }
        ITabbedFolder activeFolder = this.folderList.getActiveFolder();
        return activeFolder instanceof VQBPanelQueryElements && ((VQBPanelQueryElements)activeFolder).isTextEditMode();
    }

    public void toggleEditMode() {
        if (!this.vqbPresentation.getSQLEditor().showPresentationPanel((SQLEditorPresentationPanel)this)) {
            return;
        }
        ITabbedFolder activeFolder = this.folderList.getActiveFolder();
        if (activeFolder instanceof VQBPanelQueryElements) {
            ((VQBPanelQueryElements)activeFolder).toggleEditMode();
        }
    }

    public void editElement(String folderId, Object element) {
        if (!this.vqbPresentation.getSQLEditor().showPresentationPanel((SQLEditorPresentationPanel)this)) {
            return;
        }
        this.folderList.switchFolder(folderId);
        ITabbedFolder activeFolder = this.folderList.getActiveFolder();
        if (activeFolder instanceof VQBPanelQueryElements) {
            ((VQBPanelQueryElements)activeFolder).editElement(element);
        }
    }
}

