/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.VQBFeatures;
import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.ui.CustomSelectionProvider;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class VQBEditorPresentation
implements SQLEditorPresentation,
ISaveablePart {
    private static final Log log = Log.getLog(VQBEditorPresentation.class);
    private SQLEditor sqlEditor;
    private VQBEditorPart vqbEditor;
    private SQLListener sqlListener;

    public SQLEditor getSQLEditor() {
        return this.sqlEditor;
    }

    public VQBEditorPart getVQBEditor() {
        return this.vqbEditor;
    }

    public void createPresentation(Composite parent, SQLEditor editor) {
        this.sqlEditor = editor;
        this.sqlListener = new SQLListener();
        this.sqlEditor.addListener((SQLEditorListener)this.sqlListener);
        this.vqbEditor = new VQBEditorPart(this);
        try {
            this.vqbEditor.init(editor.getEditorSite(), editor.getEditorInput());
            this.vqbEditor.createPartControl(parent);
            this.parseActiveQuery();
        }
        catch (Exception e) {
            log.error((Object)"Error creating ERD panel", (Throwable)e);
        }
        VQBFeatures.VQB_OPEN.use();
    }

    public void showPresentation(@NotNull SQLEditor editor, boolean isNew) {
        if (!isNew) {
            this.parseActiveQuery();
        }
        if (RuntimeUtils.isMacOS()) {
            this.forceRefresh();
        }
    }

    public boolean canHidePresentation(@NotNull SQLEditor editor) {
        if (this.isDirty()) {
            int result;
            ConfirmationDialog confirmationDialog = null;
            if (VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.save.query.always")) {
                result = 2;
            } else {
                confirmationDialog = new ConfirmationDialog(editor.getEditorControlWrapper().getShell(), VQBMessages.query_builder_handler_execute_confirmation_dialog_title, null, VQBMessages.query_builder_handler_execute_confirmation_dialog_message, 4, ConfirmationDialog.getButtonLabels((int)6), ConfirmationDialog.getDefaultIndex((int)6, (int)4), VQBMessages.query_builder_handler_execute_confirmation_dialog_toggle_message, false);
                result = confirmationDialog.open();
            }
            if (result == 1) {
                return false;
            }
            if (result == 3) {
                this.resetEditorChanges();
            }
            if (result == 2) {
                if (confirmationDialog != null && confirmationDialog.getToggleState()) {
                    VQBUIActivator.getDefault().getPreferences().setValue("vqb.save.query.always", true);
                }
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
        return true;
    }

    public void dispose() {
        this.vqbEditor.dispose();
        this.sqlEditor.removeListener((SQLEditorListener)this.sqlListener);
    }

    public ISelectionProvider getSelectionProvider() {
        return new CustomSelectionProvider(){

            public ISelection getSelection() {
                return VQBEditorPresentation.this.vqbEditor.getViewer().getSelection();
            }
        };
    }

    public void parseActiveQuery() {
        SQLQuery sqlQuery = null;
        SQLScriptElement scriptElement = this.sqlEditor.extractActiveQuery();
        if (scriptElement == null) {
            ITextSelection selection = (ITextSelection)this.sqlEditor.getSelectionProvider().getSelection();
            sqlQuery = new SQLQuery(this.sqlEditor.getDataSource(), "");
            sqlQuery.setOffset(selection.getOffset());
            sqlQuery.setLength(selection.getLength());
        } else if (scriptElement instanceof SQLQuery) {
            sqlQuery = (SQLQuery)scriptElement;
        }
        if (sqlQuery != null) {
            this.vqbEditor.loadQuery(sqlQuery);
            this.vqbEditor.loadDiagram(false);
        }
    }

    @Nullable
    public VQBEditorQueryPanel getQueryPanel() {
        VQBEditorQueryPanel panel = (VQBEditorQueryPanel)this.sqlEditor.getExtraPresentationPanel(VQBEditorQueryPanel.class);
        if (panel == null) {
            panel = (VQBEditorQueryPanel)this.sqlEditor.showPresentationPanel("vqb_settings");
        }
        return panel;
    }

    void refreshStatement() {
        VQBEditorQueryPanel queryPanel = this.getQueryPanel();
        if (queryPanel != null) {
            queryPanel.refreshFromStatement(true);
        }
        this.sqlEditor.updateDirtyFlag();
    }

    public void doSave(IProgressMonitor monitor) {
        if (EditorUtils.isInAutoSaveJob()) {
            return;
        }
        if (!this.updateQueryInEditor()) {
            monitor.setCanceled(true);
        }
    }

    private boolean updateQueryInEditor() {
        if (!this.vqbEditor.isDirty()) {
            return true;
        }
        VQBQueryInfo queryInfo = this.vqbEditor.getQueryInfo();
        SQLQuery query = queryInfo.getQuery();
        try {
            String queryText = query.getText();
            SQLDialect sqlDialect = this.sqlEditor.getSQLDialect();
            String newQueryText = (String)(SQLUtils.needQueryDelimiter((SQLDialect)sqlDialect, (String)queryText) ? queryText + SQLUtils.getScriptLineDelimiter((SQLDialect)sqlDialect) : queryText) + "\n";
            query.setText(newQueryText);
            this.sqlEditor.getDocument().replace(query.getOffset(), query.getLength(), newQueryText);
            query.setLength(newQueryText.length());
            this.sqlEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(query.getOffset(), 0));
            this.vqbEditor.resetDirtyFlag();
            return true;
        }
        catch (BadLocationException e) {
            log.error((Object)"Error updating query in SQL editor", (Throwable)e);
            return false;
        }
    }

    public void resetEditorChanges() {
        VQBQueryInfo queryInfo = this.vqbEditor.getQueryInfo();
        if (queryInfo != null) {
            SQLQuery query = queryInfo.getQuery();
            query.setText(query.getOriginalText());
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.vqbEditor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private void forceRefresh() {
        GraphicalViewer viewer = this.vqbEditor.getViewer();
        viewer.getControl().redraw();
    }

    private class SQLListener
    extends SQLEditorListenerDefault {
        private SQLListener() {
        }

        public void beforeQueryExecute(boolean script, boolean newTabs) {
            VQBEditorPresentation.this.updateQueryInEditor();
        }

        public void beforeQueryPlanExplain() {
            VQBEditorPresentation.this.updateQueryInEditor();
        }

        public void onDataSourceChanged(DBPPreferenceListener.PreferenceChangeEvent event) {
            VQBEditorPresentation.this.parseActiveQuery();
        }
    }
}

