/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.editor.VQBContentProvider;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorDecorator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.handlers.VQBNavigationHandler;
import com.dbeaver.ee.vqb.ui.part.QueryColumnPart;
import com.dbeaver.ee.vqb.ui.part.QueryJoinPart;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.builder.VQBQueryParser;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDContentProvider;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.ui.command.BendpointCommand;
import org.jkiss.dbeaver.erd.ui.command.NodeMoveCommand;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorContextMenuProvider;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class VQBEditorPart
extends ERDEditorPart {
    private static final Log log = Log.getLog(VQBEditorPart.class);
    @NotNull
    private final VQBEditorPresentation presentation;
    @Nullable
    private VQBQueryInfo queryInfo;
    @NotNull
    private final QueryGeneratorJob generatorJob = new QueryGeneratorJob();

    VQBEditorPart(VQBEditorPresentation presentation) {
        this.presentation = presentation;
    }

    public VQBEditorPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.presentation.getSQLEditor().getDataSource();
    }

    public boolean isReadOnly() {
        DBPProject project = this.getDiagramProject();
        return project == null || !project.hasRealmPermission("project-resource-edit");
    }

    protected void installKeyHandler(GraphicalViewer viewer) {
        viewer.setKeyHandler((KeyHandler)new VQBNavigationHandler(viewer));
    }

    protected boolean hasProgressControl() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite vqbHolder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        if (parent.getLayout() instanceof GridLayout) {
            vqbHolder.setLayoutData((Object)new GridData(1808));
        }
        Composite erdHolder = UIUtils.createPlaceholder((Composite)vqbHolder, (int)1);
        erdHolder.setLayout((Layout)new FillLayout());
        erdHolder.setLayoutData((Object)new GridData(1808));
        super.createPartControl(erdHolder);
        ToolBarManager tb = new ToolBarManager();
        this.fillDefaultEditorContributions((IContributionManager)tb);
        ToolBar toolBar = tb.createControl(vqbHolder);
        toolBar.setLayoutData((Object)new GridData(128));
        this.getCommandStack().addCommandStackEventListener(commandStackEvent -> {
            switch (commandStackEvent.getDetail()) {
                case 8: 
                case 16: 
                case 32: {
                    Command command = commandStackEvent.getCommand();
                    if (command instanceof NodeMoveCommand || command instanceof BendpointCommand) break;
                    this.processQueryChangeCommand(command);
                }
            }
        });
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.getSite(), (Control)this.getGraphicalControl());
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)this.getGraphicalControl(), (String)"org.jkiss.dbeaver.ui.editors.sql.script.focused");
    }

    protected void fillConfigurationContribution(IContributionManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("configuration"));
        Action configAction = new Action(VQBMessages.editor_control_action_configuration){

            public void run() {
                UIUtils.showPreferencesFor((Shell)VQBEditorPart.this.getSite().getShell(), (Object)((Object)VQBEditorPart.this), (String[])new String[]{"org.jkiss.dbeaver.preferences.erd.general"});
                VQBEditorPart.this.getDiagram().setAttributeStyles(ERDViewStyle.getDefaultStyles((DBPPreferenceStore)VQBUIActivator.getDefault().getPreferences()));
            }
        };
        configAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PANEL_CUSTOMIZE));
        toolBarManager.add((IAction)configAction);
    }

    public void doSave(IProgressMonitor monitor) {
        log.error((Object)"Save not supported in VQB");
    }

    private void processQueryChangeCommand(Command command) {
        this.scheduleQueryGenerator();
    }

    public void scheduleQueryGenerator() {
        this.generatorJob.schedule(100L);
    }

    protected void registerDropTargetListeners(GraphicalViewer viewer) {
        super.registerDropTargetListeners(viewer);
    }

    protected ERDContentProvider createContentProvider() {
        return new VQBContentProvider(this);
    }

    protected ERDDecorator createDecorator() {
        return new VQBEditorDecorator(this);
    }

    protected void loadDiagram(boolean refreshMetadata) {
        if (this.queryInfo == null || this.queryInfo.getQuery() == null || CommonUtils.isEmpty((String)this.queryInfo.getQuery().getText())) {
            this.setErrorMessage("No Active Query.\nDrag-and-drop tables from the database navigator or use the palette.\nDrag-n-drop columns to join tables.");
        }
        this.loadDiagramFromQuery();
    }

    @NotNull
    protected ERDEditorContextMenuProvider createContextProvider() {
        return new ERDEditorContextMenuProvider((ERDEditorPart)this, false);
    }

    @NotNull
    public DBPProject getDiagramProject() {
        return this.getPresentation().getSQLEditor().getProject();
    }

    public void loadQuery(SQLQuery query) {
        if (this.queryInfo != null && this.queryInfo.getQuery() != null && this.queryInfo.getQuery().equals((Object)query) && this.queryInfo.getQuery().getOffset() == query.getOffset() && this.queryInfo.getQuery().getLength() == query.getLength()) {
            return;
        }
        if (this.isDirty() && !UIUtils.confirmAction((Shell)this.getSite().getShell(), (String)"Query Builder", (String)VQBMessages.editor_part_query_confirm_action_question_unsaved_changes)) {
            return;
        }
        DBCExecutionContext executionContext = this.presentation.getSQLEditor().getExecutionContext();
        Statement statement = null;
        if (!CommonUtils.isEmptyTrimmed((String)query.getText())) {
            statement = query.getStatement();
            if (statement == null) {
                Throwable error = query.getParseError();
                if (error != null) {
                    error = GeneralUtils.getRootCause((Throwable)error);
                    DBWorkbench.getPlatformUI().showError("Query parse failed", "Could not parse SQL query:\n" + query.getText(), error);
                }
            } else if (!(statement instanceof Select)) {
                this.setErrorMessage("Only SELECT queries are supported");
                query = new SQLQuery(query.getDataSource(), "");
                statement = null;
            } else {
                this.setErrorMessage(null);
            }
        }
        if (statement == null || !(statement instanceof Select)) {
            statement = VQBUtils.createEmptySelectStatement();
        }
        this.queryInfo = new VQBQueryInfo(executionContext, query, (Select)statement);
    }

    private void loadDiagramFromQuery() {
        if (this.getDiagramPart() == null) {
            return;
        }
        UIUtils.runUIJob((String)VQBMessages.vqb_rearrange_job_title, monitor -> this.getDiagramPart().getDiagram().clear());
        DatabaseLoadService<EntityDiagram> loadService = new DatabaseLoadService<EntityDiagram>("Parse query", this.queryInfo.getQuery().getDataSource()){

            /*
             * WARNING - void declaration
             */
            public EntityDiagram evaluate(DBRProgressMonitor monitor) {
                EditPart oldContents;
                EntityDiagram entityDiagram = new EntityDiagram(null, "Query Builder", VQBEditorPart.this.getContentProvider(), VQBEditorPart.this.getDecorator());
                entityDiagram.setLayoutManualAllowed(true);
                VQBQueryParser parser = new VQBQueryParser(VQBEditorPart.this.queryInfo, VQBEditorPart.this.presentation.getSQLEditor().getSyntaxManager());
                try {
                    parser.loadDiagramFromQuery(monitor, (ERDDiagram)entityDiagram, VQBUIActivator.getDefault().getPreferences());
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error in query", "SQL query can't be properly parsed", (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return entityDiagram;
                }
                monitor.worked(1);
                boolean restoreSettingsCompleted = false;
                EditPart editPart = oldContents = VQBEditorPart.this.getGraphicalViewer().getContents();
                if (editPart instanceof DiagramPart) {
                    void diagramPart;
                    DiagramPart diagramPart2 = (DiagramPart)editPart;
                    DiagramPart cfr_ignored_0 = (DiagramPart)editPart;
                    if (VQBEditorPart.this.restoreVisualSettings((DiagramPart)diagramPart, entityDiagram)) {
                        entityDiagram.setLayoutManualAllowed(true);
                        entityDiagram.setLayoutManualDesired(true);
                        restoreSettingsCompleted = true;
                    }
                }
                UIUtils.syncExec(() -> {
                    ERDGraphicalViewer graphicalViewer = VQBEditorPart.this.getGraphicalViewer();
                    graphicalViewer.setContents((Object)entityDiagram);
                });
                if (!restoreSettingsCompleted) {
                    UIUtils.syncExec(() -> {
                        ERDGraphicalViewer graphicalViewer = VQBEditorPart.this.getGraphicalViewer();
                        graphicalViewer.getEditor().getDiagramPart().resetArrangement();
                    });
                }
                monitor.done();
                return entityDiagram;
            }
        };
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)loadService, (ILoadVisualizer)new ERDEditorPart.DiagramLoaderVisualizer(this, (ILoadService)loadService, (Composite)this.getGraphicalControl()){

            protected void finishLoading() {
                VQBEditorPart.this.presentation.refreshStatement();
                VQBEditorPart.this.resetDirtyFlag();
            }
        });
        this.diagramLoadingJob.schedule();
    }

    public VQBQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    void resetDirtyFlag() {
        this.setDirty(false);
    }

    public void markEditorDirty() {
        this.setDirty(true);
    }

    private void refreshDiagramState() {
        for (EntityPart part : this.getDiagramPart().getEntityParts()) {
            for (Object ec : part.getChildren()) {
                if (!(ec instanceof QueryColumnPart)) continue;
                ((QueryColumnPart)((Object)ec)).updateCheckState();
            }
            for (Object ec : part.getSourceConnections()) {
                if (!(ec instanceof QueryJoinPart)) continue;
                ((QueryJoinPart)((Object)ec)).updateJoinType();
            }
        }
    }

    public void fillNotationsMenu(IMenuManager menu) {
    }

    private class QueryGeneratorJob
    extends AbstractJob {
        QueryGeneratorJob() {
            super("Generate SQL query from diagram");
            this.setUser(false);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (VQBEditorPart.this.getDataSource() == null) {
                return GeneralUtils.makeErrorStatus((String)"Can't generate query - not connected to a database");
            }
            VQBQueryParser parser = new VQBQueryParser(VQBEditorPart.this.getQueryInfo());
            parser.updateDiagramFromQuery(monitor, (ERDDiagram)VQBEditorPart.this.getDiagram());
            UIUtils.asyncExec(() -> {
                VQBEditorPart.this.markEditorDirty();
                VQBEditorPart.this.refreshDiagramState();
                VQBEditorPart.this.presentation.refreshStatement();
            });
            return Status.OK_STATUS;
        }
    }
}

