/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.itemlist;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.DataSourcePropertyFilter;
import org.jkiss.dbeaver.runtime.properties.IPropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ObjectAttributeDescriptor;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceAbstract;
import org.jkiss.dbeaver.ui.ClipboardData;
import org.jkiss.dbeaver.ui.CopyMode;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DefaultViewerToolTipSupport;
import org.jkiss.dbeaver.ui.IClipboardSource;
import org.jkiss.dbeaver.ui.ILabelProviderEx;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ObjectListControl<OBJECT_TYPE>
extends ProgressPageControl
implements IClipboardSource {
    private static final Log log = Log.getLog(ObjectListControl.class);
    private static final LazyValue DEF_LAZY_VALUE = new LazyValue("...");
    private static final int LAZY_LOAD_DELAY = 100;
    private static final Object NULL_VALUE = new Object();
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_GROUPING_LABEL = "<None>";
    private boolean isFitWidth = false;
    private boolean isTree;
    private ColumnViewer itemsViewer;
    private IDoubleClickListener doubleClickHandler;
    private PropertySourceAbstract listPropertySource;
    private ObjectViewerRenderer renderer;
    protected ViewerColumnController<ObjectColumn, Object> columnController;
    private transient boolean sampleItems = false;
    private volatile OBJECT_TYPE curListObject;
    private volatile LoadingJob<Collection<OBJECT_TYPE>> loadingJob;
    private Job lazyLoadingJob = null;
    private Map<OBJECT_TYPE, List<ObjectColumn>> lazyObjects;
    private final Map<OBJECT_TYPE, Map<String, Object>> lazyCache = new IdentityHashMap<OBJECT_TYPE, Map<String, Object>>();
    private volatile boolean lazyLoadCanceled;
    private List<OBJECT_TYPE> objectList = null;
    private Object focusObject;
    private ObjectColumn focusColumn;
    private ObjectColumn groupingColumn;
    private IContentProvider originalContentProvider;

    public ObjectListControl(Composite parent, int style, IContentProvider contentProvider) {
        super(parent, style);
        this.originalContentProvider = contentProvider;
        int viewerStyle = this.getDefaultListStyle();
        if ((style & 0x10000000) == 0) {
            viewerStyle |= 0x800;
        }
        TraverseListener traverseListener = e -> {
            if (e.detail == 4 && this.doubleClickHandler != null) {
                this.doubleClickHandler.doubleClick(new DoubleClickEvent((Viewer)this.itemsViewer, this.itemsViewer.getSelection()));
                e.doit = false;
            }
        };
        boolean showTableGrid = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.editor.showGrid");
        if (UIStyles.isDarkTheme()) {
            showTableGrid = false;
        }
        if (contentProvider instanceof ITreeContentProvider) {
            this.isTree = true;
        }
        if (contentProvider instanceof ITreeContentProvider) {
            TreeViewer treeViewer = new TreeViewer((Composite)this, viewerStyle);
            Tree tree = treeViewer.getTree();
            tree.setHeaderVisible(true);
            if (showTableGrid) {
                tree.setLinesVisible(true);
            }
            this.itemsViewer = treeViewer;
            EditorActivationStrategy editorActivationStrategy = new EditorActivationStrategy((ColumnViewer)treeViewer);
            TreeViewerEditor.create((TreeViewer)treeViewer, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)4);
            treeViewer.getControl().addListener(41, event -> {});
            tree.addTraverseListener(traverseListener);
        } else {
            Object tableViewer = (viewerStyle & 0x20) == 32 ? CheckboxTableViewer.newCheckList((Composite)this, (int)viewerStyle) : new TableViewer((Composite)this, viewerStyle);
            Table table = tableViewer.getTable();
            table.setHeaderVisible(true);
            if (showTableGrid) {
                table.setLinesVisible(true);
            }
            this.itemsViewer = tableViewer;
            EditorActivationStrategy editorActivationStrategy = new EditorActivationStrategy((ColumnViewer)tableViewer);
            TableViewerEditor.create((TableViewer)tableViewer, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)24);
            table.addTraverseListener(traverseListener);
        }
        this.renderer = this.createRenderer();
        this.itemsViewer.getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)new EditorActivationListener());
        this.itemsViewer.setContentProvider(contentProvider);
        this.itemsViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ObjectListControl.this.doubleClickHandler != null) {
                    ObjectListControl.this.doubleClickHandler.doubleClick(new DoubleClickEvent((Viewer)ObjectListControl.this.itemsViewer, ObjectListControl.this.itemsViewer.getSelection()));
                }
            }
        });
        this.itemsViewer.getControl().addListener(42, (Listener)new PaintListener());
        GridData gd = new GridData(1808);
        this.itemsViewer.getControl().setLayoutData((Object)gd);
        new DefaultViewerToolTipSupport(this.itemsViewer);
        this.itemsViewer.addSelectionChangedListener(event -> {
            String status;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                this.setCurListObject(null);
            } else {
                this.setCurListObject(selection.getFirstElement());
            }
            if (selection.isEmpty()) {
                status = EMPTY_STRING;
            } else if (selection.size() == 1) {
                Object selectedNode = selection.getFirstElement();
                status = ObjectViewerRenderer.getCellString((Object)selectedNode, (boolean)false);
            } else {
                status = NLS.bind((String)UINavigatorMessages.controls_object_list_status_objects, (Object)selection.size());
            }
            this.setInfo(status);
        });
        UIUtils.installAndUpdateMainFont((Control)this.itemsViewer.getControl());
    }

    @NotNull
    protected abstract String getListConfigId(List<Class<?>> var1);

    protected int getDefaultListStyle() {
        return 65538;
    }

    public ObjectViewerRenderer getRenderer() {
        return this.renderer;
    }

    public PropertySourceAbstract getListPropertySource() {
        if (this.listPropertySource == null) {
            this.listPropertySource = this.createListPropertySource();
        }
        return this.listPropertySource;
    }

    protected PropertySourceAbstract createListPropertySource() {
        return new DefaultListPropertySource();
    }

    protected CellLabelProvider getColumnLabelProvider(ObjectColumn objectColumn) {
        return new ObjectColumnLabelProvider(objectColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelProgress() {
        ObjectListControl objectListControl = this;
        synchronized (objectListControl) {
            block4: {
                if (this.loadingJob == null) break block4;
                this.loadingJob.cancel();
                return true;
            }
        }
        return false;
    }

    public OBJECT_TYPE getCurrentListObject() {
        return this.curListObject;
    }

    protected void setCurListObject(@Nullable OBJECT_TYPE curListObject) {
        this.curListObject = curListObject;
    }

    public ColumnViewer getItemsViewer() {
        return this.itemsViewer;
    }

    public Composite getControl() {
        return (Composite)this.itemsViewer.getControl();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.itemsViewer;
    }

    protected ObjectColumn getColumnByIndex(int index) {
        return this.columnController.getColumnData(index);
    }

    public void setFitWidth(boolean fitWidth) {
        this.isFitWidth = fitWidth;
    }

    public boolean supportsDataGrouping() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeControl() {
        ObjectListControl objectListControl = this;
        synchronized (objectListControl) {
            if (this.loadingJob != null) {
                this.loadingJob.cancel();
                this.loadingJob = null;
            }
        }
        this.renderer.dispose();
        super.disposeControl();
    }

    public synchronized boolean isLoading() {
        return this.loadingJob != null;
    }

    public void loadData() {
        this.loadData(true, false);
    }

    public void loadData(boolean lazy) {
        this.loadData(lazy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadData(boolean lazy, boolean forUpdate) {
        if (this.loadingJob != null) {
            int dataLoadUpdatePeriod = 200;
            int dataLoadTimes = this.getDataLoadTimeout() / dataLoadUpdatePeriod;
            try {
                int i = 0;
                while (i < dataLoadTimes) {
                    Thread.sleep(dataLoadUpdatePeriod);
                    if (this.loadingJob != null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {}
            if (this.loadingJob != null) {
                DBWorkbench.getPlatformUI().showMessageBox("Load", "Service is busy", true);
                return;
            }
            return;
        }
        this.getListPropertySource();
        this.clearLazyCache();
        this.lazyLoadCanceled = false;
        if (lazy) {
            ObjectListControl dataLoadUpdatePeriod = this;
            synchronized (dataLoadUpdatePeriod) {
                this.loadingJob = this.createLoadService(forUpdate);
                if (this.loadingJob != null) {
                    this.loadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            ObjectListControl.this.loadingJob = null;
                        }
                    });
                    this.loadingJob.schedule(100L);
                }
            }
        } else {
            LoadingJob<Collection<OBJECT_TYPE>> loadService = this.createLoadService(forUpdate);
            if (loadService != null) {
                loadService.syncRun();
            }
        }
    }

    public ViewerColumnController<ObjectColumn, Object> getColumnController() {
        return this.columnController;
    }

    protected int getDataLoadTimeout() {
        return 10000;
    }

    protected void setListData(Collection<OBJECT_TYPE> items, boolean append, boolean forUpdate) {
        this.setListData(items, append, forUpdate, false);
    }

    protected void setListData(Collection<OBJECT_TYPE> items, boolean append, boolean forUpdate, boolean forceUpdateItems) {
        block41: {
            if (items == null) {
                return;
            }
            Control itemsControl = this.itemsViewer.getControl();
            if (itemsControl.isDisposed()) {
                return;
            }
            itemsControl.setRedraw(false);
            try {
                boolean reload = !append && CommonUtils.isEmpty(this.objectList) || this.columnController == null;
                ArrayList classList = new ArrayList();
                Class<?>[] baseTypes = this.getListBaseTypes(items);
                if (!ArrayUtils.isEmpty((Object[])baseTypes)) {
                    Collections.addAll(classList, baseTypes);
                }
                if (!CommonUtils.isEmpty(items)) {
                    for (OBJECT_TYPE item : items) {
                        Class theClass;
                        Object object = this.getObjectValue(item);
                        if (object != null && !classList.contains(theClass = ObjectPropertyDescriptor.getObjectClass((Object)object))) {
                            int i = 0;
                            while (i < classList.size()) {
                                Class c = (Class)classList.get(i);
                                if (!c.isInterface() && c.isAssignableFrom(theClass)) {
                                    classList.remove(i);
                                } else {
                                    ++i;
                                }
                                ++i;
                            }
                            classList.add(theClass);
                        }
                        if (!this.isTree) continue;
                        IdentityHashMap collectedSet = new IdentityHashMap();
                        this.collectItemClasses(item, classList, collectedSet);
                    }
                }
                DataSourcePropertyFilter propertyFilter = new DataSourcePropertyFilter(this instanceof DBPDataSourceContainerProvider ? ((DBPDataSourceContainerProvider)this).getDataSourceContainer() : null);
                PropertySourceAbstract propertySource = this.getListPropertySource();
                List allProps = ObjectAttributeDescriptor.extractAnnotations((DBPPropertySource)propertySource, classList, (IPropertyFilter)propertyFilter);
                if (!CommonUtils.isEmpty(items)) {
                    try {
                        allProps.removeIf(p -> {
                            for (Object item : items) {
                                Object objectValue = this.getObjectValue(item);
                                if (objectValue == null || !p.isPropertyVisible(objectValue, objectValue)) continue;
                                return false;
                            }
                            return true;
                        });
                    }
                    catch (Throwable e) {
                        log.debug((Object)e);
                    }
                }
                if (reload) {
                    this.clearListData();
                    this.columnController = new GroupingViewerColumnController<ObjectColumn, Object>(this.getListConfigId(classList), this.getItemsViewer());
                }
                for (ObjectPropertyDescriptor prop : allProps) {
                    if (propertySource.hasProperty(prop)) continue;
                    if (prop.isOptional()) {
                        boolean propHasValue = false;
                        if (!CommonUtils.isEmpty(items)) {
                            for (OBJECT_TYPE item : items) {
                                try {
                                    Object propValue = prop.readValue(this.getObjectValue(item), null, true);
                                    if (propValue == null) continue;
                                    propHasValue = true;
                                    break;
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        if (!propHasValue) continue;
                    }
                    propertySource.addProperty((DBPPropertyDescriptor)prop);
                    this.createColumn(prop);
                }
                this.addExtraColumns(this.columnController, items);
                if (itemsControl.isDisposed()) {
                    return;
                }
                if (reload) {
                    this.columnController.createColumns(false);
                }
                if (reload || this.objectList.isEmpty()) {
                    this.objectList = this.createViewerInput(items);
                    this.sampleItems = true;
                    try {
                        List<OBJECT_TYPE> sampleList = this.objectList.size() > 200 ? this.objectList.subList(0, 100) : this.objectList;
                        this.itemsViewer.setInput(this.createViewerInput(sampleList));
                        if (this.isTree) {
                            ((TreeViewer)this.itemsViewer).expandToLevel(4);
                        }
                        if (reload) {
                            this.columnController.repackColumns();
                        }
                    }
                    finally {
                        this.sampleItems = false;
                    }
                    this.itemsViewer.setInput(this.objectList);
                    break block41;
                }
                if (items == null) break block41;
                if (append) {
                    for (Object newObject : items) {
                        if (this.objectList.contains(newObject)) continue;
                        this.objectList.add(newObject);
                    }
                } else if (!this.objectList.equals(items) || forceUpdateItems) {
                    int newListSize = items.size();
                    int itemIndex = 0;
                    for (OBJECT_TYPE newObject : items) {
                        if (itemIndex >= this.objectList.size()) {
                            this.objectList.add(itemIndex, newObject);
                        } else {
                            OBJECT_TYPE oldObject = this.objectList.get(itemIndex);
                            if (!CommonUtils.equalObjects(oldObject, newObject) || forceUpdateItems) {
                                this.objectList.set(itemIndex, newObject);
                            }
                        }
                        ++itemIndex;
                    }
                    while (this.objectList.size() > newListSize) {
                        this.objectList.remove(this.objectList.size() - 1);
                    }
                }
                this.itemsViewer.refresh();
            }
            finally {
                itemsControl.setRedraw(true);
            }
        }
        this.setInfo(this.getItemsLoadMessage(this.objectList.size()));
    }

    protected List<OBJECT_TYPE> createViewerInput(Collection<OBJECT_TYPE> objectList) {
        return new ArrayList<OBJECT_TYPE>(objectList);
    }

    protected void addExtraColumns(ViewerColumnController<ObjectColumn, Object> columnController, Collection<OBJECT_TYPE> items) {
    }

    public void appendListData(Collection<OBJECT_TYPE> items) {
        this.setListData(items, true, false);
    }

    public void repackColumns() {
        if (this.columnController != null) {
            this.columnController.repackColumns();
        }
    }

    public Collection<OBJECT_TYPE> getListData() {
        return this.objectList;
    }

    public void clearListData() {
        if (this.columnController != null) {
            this.columnController.dispose();
            this.columnController = null;
        }
        if (!this.itemsViewer.getControl().isDisposed()) {
            this.itemsViewer.setInput(this.createViewerInput(Collections.emptyList()));
        }
        if (this.listPropertySource != null) {
            this.listPropertySource.clearProperties();
        }
        this.clearLazyCache();
    }

    private void collectItemClasses(OBJECT_TYPE item, List<Class<?>> classList, Map<OBJECT_TYPE, Boolean> collectedSet) {
        if (collectedSet.containsKey(item)) {
            log.warn((Object)("Cycled object tree: " + String.valueOf(item)));
            return;
        }
        collectedSet.put(item, Boolean.TRUE);
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.itemsViewer.getContentProvider();
        if (!contentProvider.hasChildren(item)) {
            return;
        }
        Object[] children = contentProvider.getChildren(item);
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                Object childItem = child;
                Object objectValue = this.getObjectValue(childItem);
                if (objectValue != null && !classList.contains(objectValue.getClass())) {
                    classList.add(objectValue.getClass());
                }
                this.collectItemClasses(childItem, classList, collectedSet);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetLazyPropertyCache(OBJECT_TYPE object, String property) {
        Map<OBJECT_TYPE, Map<String, Object>> map = this.lazyCache;
        synchronized (map) {
            Map<String, Object> cache = this.lazyCache.get(object);
            if (cache != null) {
                cache.remove(property);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLazyCache() {
        Map<OBJECT_TYPE, Map<String, Object>> map = this.lazyCache;
        synchronized (map) {
            this.lazyCache.clear();
        }
    }

    protected String getItemsLoadMessage(int count) {
        if (count == 0) {
            return UINavigatorMessages.controls_object_list_message_no_items;
        }
        return NLS.bind((String)UINavigatorMessages.controls_object_list_message_items, (Object)count);
    }

    public void setDoubleClickHandler(IDoubleClickListener doubleClickHandler) {
        this.doubleClickHandler = doubleClickHandler;
    }

    private Tree getTree() {
        return ((TreeViewer)this.itemsViewer).getTree();
    }

    private Table getTable() {
        return ((TableViewer)this.itemsViewer).getTable();
    }

    private synchronized void addLazyObject(OBJECT_TYPE object, ObjectColumn column) {
        List<ObjectColumn> objectColumns;
        if (this.lazyObjects == null) {
            this.lazyObjects = new LinkedHashMap<OBJECT_TYPE, List<ObjectColumn>>();
        }
        if ((objectColumns = this.lazyObjects.get(object)) == null) {
            objectColumns = new ArrayList<ObjectColumn>();
            this.lazyObjects.put(object, objectColumns);
        }
        if (!objectColumns.contains(column)) {
            objectColumns.add(column);
        }
        if (this.lazyLoadingJob == null) {
            this.lazyLoadingJob = new LazyLoaderJob();
            this.lazyLoadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    ObjectListControl objectListControl = ObjectListControl.this;
                    synchronized (objectListControl) {
                        if (ObjectListControl.this.lazyObjects == null || ObjectListControl.this.lazyObjects.isEmpty()) {
                            ObjectListControl.this.lazyLoadingJob = null;
                        } else {
                            ObjectListControl.this.lazyLoadingJob.schedule(100L);
                        }
                    }
                }
            });
            this.lazyLoadingJob.schedule(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Map<OBJECT_TYPE, List<ObjectColumn>> obtainLazyObjects() {
        Map<OBJECT_TYPE, Map<String, Object>> map = this.lazyCache;
        synchronized (map) {
            block4: {
                if (this.lazyObjects != null) break block4;
                return null;
            }
            Map<OBJECT_TYPE, List<ObjectColumn>> tmp = this.lazyObjects;
            this.lazyObjects = null;
            return tmp;
        }
    }

    @Nullable
    protected final Object getCellValue(Object element, int columnIndex) {
        ObjectColumn columnInfo = this.getColumnByIndex(columnIndex);
        if (columnInfo == null) {
            return null;
        }
        return this.getCellValue(element, columnInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Object getCellValue(Object element, ObjectColumn objectColumn, boolean formatValue) {
        ObjectPropertyDescriptor prop;
        Object objectValue;
        block13: {
            Object previewValue;
            block14: {
                if (element instanceof ObjectsGroupingWrapper) {
                    if (objectColumn == this.groupingColumn) {
                        Object groupingKey = ((ObjectsGroupingWrapper)element).groupingKey;
                        List<Object> elements = ((ObjectsGroupingWrapper)element).groupedElements;
                        int groupElementsSize = 0;
                        if (!CommonUtils.isEmpty(elements)) {
                            groupElementsSize = elements.size();
                        }
                        if (groupingKey == null || EMPTY_STRING.equals(groupingKey)) {
                            return EMPTY_GROUPING_LABEL + (String)(groupElementsSize > 0 ? " (" + groupElementsSize + ")" : EMPTY_STRING);
                        }
                        return String.valueOf(groupingKey) + (String)(groupElementsSize > 0 ? " (" + groupElementsSize + ")" : EMPTY_STRING);
                    }
                    return null;
                }
                Object object = element;
                objectValue = this.getObjectValue(object);
                if (objectValue == null) {
                    return null;
                }
                prop = ObjectListControl.getPropertyByObject(objectColumn, objectValue);
                if (prop == null) {
                    return null;
                }
                if (!prop.isLazy(objectValue, true)) break block13;
                Map<OBJECT_TYPE, Map<String, Object>> map = this.lazyCache;
                synchronized (map) {
                    Object value;
                    block12: {
                        Map<String, Object> cache = this.lazyCache.get(object);
                        if (cache == null || (value = cache.get(objectColumn.id)) == null) break block14;
                        if (value != NULL_VALUE) break block12;
                        return null;
                    }
                    if (formatValue) {
                        value = prop.formatValue(object, value);
                    }
                    return value;
                }
            }
            if (prop.supportsPreview() && (previewValue = this.getListPropertySource().getPropertyValue(null, objectValue, prop, formatValue)) != null) {
                return new LazyValue(previewValue);
            }
            return DEF_LAZY_VALUE;
        }
        return this.getListPropertySource().getPropertyValue(null, objectValue, prop, formatValue);
    }

    @Nullable
    private static ObjectPropertyDescriptor getPropertyByObject(@NotNull ObjectColumn column, @Nullable Object objectValue) {
        if (objectValue == null) {
            return null;
        }
        ObjectPropertyDescriptor prop = null;
        Class<?> valueClass = objectValue.getClass();
        while (prop == null && valueClass != Object.class) {
            prop = column.propMap.get(valueClass);
            valueClass = valueClass.getSuperclass();
        }
        if (prop == null) {
            for (Map.Entry<Class<?>, ObjectPropertyDescriptor> entry : column.propMap.entrySet()) {
                if (!entry.getKey().isInstance(objectValue)) continue;
                prop = entry.getValue();
                break;
            }
        }
        return prop;
    }

    @Nullable
    protected Class<?>[] getListBaseTypes(Collection<OBJECT_TYPE> items) {
        return null;
    }

    @Nullable
    public <T> T getSuitableSelectedElement(@NotNull Class<T> adapterType) {
        Object firstElement;
        Object adapter;
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (adapter = DBUtils.getAdapter(adapterType, (Object)(firstElement = ((IStructuredSelection)selection).getFirstElement()))) != null) {
            return (T)firstElement;
        }
        return null;
    }

    protected Object getObjectValue(OBJECT_TYPE item) {
        return item;
    }

    @Nullable
    protected DBPImage getObjectImage(OBJECT_TYPE item) {
        return null;
    }

    protected Color getObjectBackground(OBJECT_TYPE item) {
        return null;
    }

    protected Color getObjectForeground(OBJECT_TYPE item) {
        return null;
    }

    protected boolean isNewObject(OBJECT_TYPE objectValue) {
        return false;
    }

    protected boolean isReadOnlyList() {
        return false;
    }

    @NotNull
    protected Set<DBPPropertyDescriptor> getAllProperties() {
        ObjectColumn[] columns = this.columnController.getColumnsData(ObjectColumn.class);
        LinkedHashSet<DBPPropertyDescriptor> props = new LinkedHashSet<DBPPropertyDescriptor>();
        ObjectColumn[] objectColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectColumn column = objectColumnArray[n2];
            props.addAll(column.propMap.values());
            ++n2;
        }
        return props;
    }

    public void setIsColumnVisibleById(String id, boolean visible) {
        if (this.columnController != null) {
            ObjectColumn[] columnsData = this.columnController.getColumnsData(ObjectColumn.class);
            int i = 0;
            while (i < columnsData.length) {
                if (columnsData[i].id.equals(id)) {
                    this.columnController.setIsColumnVisible(i, visible);
                }
                ++i;
            }
        }
    }

    protected void createColumn(ObjectPropertyDescriptor prop) {
        Class propClass;
        ObjectColumn objectColumn = null;
        ObjectColumn[] objectColumnArray = this.columnController.getColumnsData(ObjectColumn.class);
        int n = objectColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectColumn col = objectColumnArray[n2];
            if (CommonUtils.equalObjects((Object)col.id, (Object)prop.getId()) || CommonUtils.equalObjects((Object)col.displayName, (Object)prop.getDisplayName())) {
                objectColumn = col;
                break;
            }
            ++n2;
        }
        Class clazz = propClass = prop.getParent() == null ? prop.getDeclaringClass() : prop.getParent().getDeclaringClass();
        if (objectColumn == null) {
            if (prop.isHidden()) {
                return;
            }
            objectColumn = new ObjectColumn(prop.getId(), prop.getDisplayName());
            objectColumn.addProperty(propClass, prop);
            CellLabelProvider labelProvider = this.getColumnLabelProvider(objectColumn);
            EditingSupport editingSupport = this.makeEditingSupport(objectColumn);
            this.columnController.addColumn(prop.getDisplayName(), prop.getDescription(), prop.isNumeric() ? 131072 : (prop.isBoolean() ? 0x1000000 : 0), prop.isViewable(), prop.isNameProperty(), prop.isNumeric(), objectColumn, labelProvider, editingSupport);
        } else {
            objectColumn.addProperty(propClass, prop);
        }
    }

    protected abstract LoadingJob<Collection<OBJECT_TYPE>> createLoadService(boolean var1);

    protected ObjectViewerRenderer createRenderer() {
        return new ViewerRenderer();
    }

    @Nullable
    protected EditingSupport makeEditingSupport(ObjectColumn objectColumn) {
        return null;
    }

    protected void setFocusCell(Object object, ObjectColumn objectColumn) {
        this.focusObject = object;
        this.focusColumn = objectColumn;
    }

    public void addClipboardData(CopyMode mode, ClipboardData clipboardData) {
        String selectedText;
        if (mode == CopyMode.ADVANCED) {
            selectedText = this.copyGridToText();
            if (!CommonUtils.isEmpty((String)selectedText)) {
                clipboardData.addTransfer((Transfer)TextTransfer.getInstance(), (Object)selectedText);
            }
        } else {
            IStructuredSelection selection = this.itemsViewer.getStructuredSelection();
            if (selection.size() > 1) {
                StringBuilder buf = new StringBuilder();
                for (Object o : selection) {
                    Object[] paths;
                    Object object = this.getObjectValue(o);
                    ObjectColumn nameColumn = null;
                    int columnsCount = this.columnController.getColumnsCount();
                    int i = 0;
                    while (i < columnsCount) {
                        ObjectColumn column = this.getColumnByIndex(i);
                        if (column.isNameColumn(object)) {
                            nameColumn = column;
                            break;
                        }
                        ++i;
                    }
                    String objectName = null;
                    if (nameColumn != null) {
                        try {
                            ObjectPropertyDescriptor nameProperty = nameColumn.getProperty(object);
                            if (nameProperty != null) {
                                objectName = CommonUtils.toString((Object)nameProperty.readValue(object, null, true));
                            }
                        }
                        catch (Throwable e) {
                            log.debug((Object)e);
                        }
                    }
                    if (objectName == null) {
                        objectName = object instanceof DBPNamedObject ? ((DBPNamedObject)object).getName() : DBValueFormatting.getDefaultValueDisplayString((Object)object, (DBDDisplayFormat)DBDDisplayFormat.UI);
                    }
                    if (buf.length() > 0) {
                        buf.append("\n");
                    }
                    if (selection instanceof TreeSelection && !ArrayUtils.isEmpty((Object[])(paths = ((TreeSelection)selection).getPathsFor(o)))) {
                        int count = paths[0].getSegmentCount();
                        int i2 = 1;
                        while (i2 < count) {
                            buf.append('\t');
                            ++i2;
                        }
                    }
                    buf.append(objectName);
                }
                selectedText = buf.toString();
            } else {
                selectedText = this.getRenderer().getSelectedText();
            }
        }
        if (!CommonUtils.isEmpty((String)selectedText)) {
            clipboardData.addTransfer((Transfer)TextTransfer.getInstance(), (Object)selectedText);
        }
    }

    protected void addColumnConfigAction(IContributionManager contributionManager) {
        Action configColumnsAction = new Action(UINavigatorMessages.obj_editor_properties_control_action_configure_columns, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION)){

            public void run() {
                ObjectListControl.this.columnController.configureColumns();
            }
        };
        configColumnsAction.setDescription(UINavigatorMessages.obj_editor_properties_control_action_configure_columns_description);
        contributionManager.add((IAction)configColumnsAction);
    }

    private String copyGridToText() {
        StringBuilder buf = new StringBuilder();
        int columnsCount = this.columnController.getColumnsCount();
        int i = 0;
        while (i < columnsCount) {
            ObjectColumn column = this.getColumnByIndex(i);
            if (i > 0) {
                buf.append("\t");
            }
            buf.append(column.displayName);
            ++i;
        }
        buf.append("\n");
        List elementList = this.itemsViewer.getStructuredSelection().toList();
        for (Object element : elementList) {
            Object object = this.getObjectValue(element);
            int i2 = 0;
            while (i2 < columnsCount) {
                ObjectPropertyDescriptor property = this.getColumnByIndex(i2).getProperty(object);
                try {
                    Object strValue;
                    Object cellValue;
                    Object object2 = cellValue = property == null ? null : property.readValue(object, (DBRProgressMonitor)new VoidProgressMonitor(), true);
                    if (i2 > 0) {
                        buf.append("\t");
                    }
                    if (((String)(strValue = DBValueFormatting.getDefaultValueDisplayString((Object)cellValue, (DBDDisplayFormat)DBDDisplayFormat.UI))).contains("\n") || ((String)strValue).contains("\t")) {
                        strValue = "\"" + (String)strValue + "\"";
                    }
                    buf.append((String)strValue);
                }
                catch (Throwable throwable) {}
                ++i2;
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private class DefaultListPropertySource
    extends PropertySourceAbstract {
        DefaultListPropertySource() {
            super((Object)ObjectListControl.this, (Object)ObjectListControl.this, true);
        }

        public Object getSourceObject() {
            return ObjectListControl.this.getCurrentListObject();
        }

        public Object getEditableValue() {
            return ObjectListControl.this.getObjectValue(ObjectListControl.this.getCurrentListObject());
        }

        public DBPPropertyDescriptor[] getProperties() {
            return ObjectListControl.this.getAllProperties().toArray(new DBPPropertyDescriptor[0]);
        }
    }

    private static class EditorActivationListener
    extends ColumnViewerEditorActivationListener {
        private EditorActivationListener() {
        }

        public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
        }

        public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
        }

        public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
        }

        public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
        }
    }

    private class EditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        public EditorActivationStrategy(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            if (ObjectListControl.this.isReadOnlyList()) {
                return false;
            }
            ViewerCell cell = (ViewerCell)event.getSource();
            if (ObjectListControl.this.renderer.isHyperlink(cell.getElement(), ObjectListControl.this.getCellValue(cell.getElement(), cell.getColumnIndex())) && ObjectListControl.this.getItemsViewer().getControl().getCursor() == ObjectListControl.this.getItemsViewer().getControl().getDisplay().getSystemCursor(21)) {
                return false;
            }
            return super.isEditorActivationEvent(event);
        }
    }

    private class GroupingTreeProvider
    extends TreeContentProvider {
        private GroupingTreeProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (ObjectListControl.this.groupingColumn != null) {
                Object[] elements = super.getElements(inputElement);
                if (ArrayUtils.isEmpty((Object[])elements)) {
                    return elements;
                }
                int columnIndex = ObjectListControl.this.groupingColumn.columnIndex;
                HashMap<Object, List> groups = new HashMap<Object, List>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    Object key = ObjectListControl.this.getCellValue(element, columnIndex);
                    List group = groups.computeIfAbsent(key, x -> new ArrayList());
                    group.add(element);
                    ++n2;
                }
                return groups.entrySet().stream().map(x -> new ObjectsGroupingWrapper(x.getKey(), (List)x.getValue())).toArray();
            }
            return super.getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (ObjectListControl.this.groupingColumn != null && parentElement instanceof ObjectsGroupingWrapper) {
                return ((ObjectsGroupingWrapper)parentElement).groupedElements.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (ObjectListControl.this.groupingColumn != null) {
                return element instanceof ObjectsGroupingWrapper;
            }
            return false;
        }
    }

    private class GroupingViewerColumnController<COLUMN, ELEMENT>
    extends ViewerColumnController<COLUMN, ELEMENT> {
        private int[] originalColumnOrder;

        GroupingViewerColumnController(String id, ColumnViewer viewer) {
            super(id, viewer);
        }

        @Override
        public void fillConfigMenu(IContributionManager menuManager) {
            super.fillConfigMenu(menuManager);
            if (ObjectListControl.this.isTree && ObjectListControl.this.supportsDataGrouping()) {
                boolean columnPersist;
                menuManager.add((IContributionItem)new Separator());
                final int selectedColumnNumber = ObjectListControl.this.columnController.getSelectedColumnNumber();
                String columnName = null;
                boolean bl = columnPersist = selectedColumnNumber != -1;
                if (columnPersist) {
                    columnName = ObjectListControl.this.columnController.getColumnName(selectedColumnNumber);
                }
                menuManager.add((IAction)new Action(NLS.bind((String)UINavigatorMessages.object_list_control_group_by_label, (Object)CommonUtils.notEmpty((String)columnName)), null){

                    public void run() {
                        if (columnPersist) {
                            ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.groupingColumn = ObjectListControl.this.getColumnByIndex(selectedColumnNumber);
                            ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.groupingColumn.columnIndex = selectedColumnNumber;
                            GroupingViewerColumnController.this.originalColumnOrder = ((TreeViewer)((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.itemsViewer).getTree().getColumnOrder();
                            GroupingViewerColumnController.this.moveGroupingColumnInTheBeginning(selectedColumnNumber);
                            ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.itemsViewer.setContentProvider((IContentProvider)new GroupingTreeProvider());
                            ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.itemsViewer.refresh();
                            ((TreeViewer)((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.itemsViewer).expandToLevel(2);
                        }
                    }

                    public boolean isEnabled() {
                        return columnPersist;
                    }
                });
                menuManager.add((IAction)new Action(UINavigatorMessages.object_list_control_clear_grouping_label, null){

                    public void run() {
                        ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.groupingColumn = null;
                        GroupingViewerColumnController.this.restoreOriginalColumnsOrder();
                        ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.itemsViewer.setContentProvider(((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.originalContentProvider);
                        ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.itemsViewer.refresh();
                    }

                    public boolean isEnabled() {
                        return ((GroupingViewerColumnController)GroupingViewerColumnController.this).ObjectListControl.this.groupingColumn != null;
                    }
                });
            }
        }

        private void moveGroupingColumnInTheBeginning(int groupingColumnPosition) {
            Tree tree = ((TreeViewer)ObjectListControl.this.itemsViewer).getTree();
            int[] originalColumnOrder = tree.getColumnOrder();
            int[] newColumnOrder = new int[originalColumnOrder.length];
            newColumnOrder[0] = groupingColumnPosition;
            int originalNumber = 0;
            int[] nArray = originalColumnOrder;
            int n = originalColumnOrder.length;
            int n2 = 0;
            while (n2 < n) {
                int element = nArray[n2];
                if (element != groupingColumnPosition) {
                    newColumnOrder[++originalNumber] = element;
                }
                ++n2;
            }
            tree.setColumnOrder(newColumnOrder);
            ObjectListControl.this.columnController.repackColumns();
        }

        private void restoreOriginalColumnsOrder() {
            if (!ArrayUtils.isEmpty((int[])this.originalColumnOrder)) {
                ((TreeViewer)ObjectListControl.this.itemsViewer).getTree().setColumnOrder(this.originalColumnOrder);
            }
            ObjectListControl.this.columnController.repackColumns();
        }
    }

    private class LazyLoaderJob
    extends AbstractJob {
        public LazyLoaderJob() {
            super(UINavigatorMessages.controls_object_list_job_props_read);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            Map objectMap = ObjectListControl.this.obtainLazyObjects();
            if (ObjectListControl.this.isDisposed()) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(UINavigatorMessages.controls_object_list_monitor_load_lazy_props, objectMap.size());
            for (Map.Entry entry : objectMap.entrySet()) {
                Map<String, Object> objectCache;
                if (monitor.isCanceled() || ObjectListControl.this.isDisposed()) break;
                Object element = entry.getKey();
                Object object = ObjectListControl.this.getObjectValue(element);
                if (object == null) continue;
                Map map = ObjectListControl.this.lazyCache;
                synchronized (map) {
                    objectCache = ObjectListControl.this.lazyCache.get(element);
                    if (objectCache == null) {
                        objectCache = new HashMap<String, Object>();
                        ObjectListControl.this.lazyCache.put(element, objectCache);
                    }
                }
                String objectName = GeneralUtils.makeDisplayString((Object)ObjectListControl.this.getObjectValue(element)).toString();
                monitor.subTask(NLS.bind((String)UINavigatorMessages.controls_object_list_monitor_load_props, (Object)objectName));
                for (ObjectColumn column : entry.getValue()) {
                    if (monitor.isCanceled() || ObjectListControl.this.isDisposed()) break;
                    ObjectPropertyDescriptor prop = ObjectListControl.getPropertyByObject(column, object);
                    if (prop == null) continue;
                    try {
                        Map map2 = ObjectListControl.this.lazyCache;
                        synchronized (map2) {
                            if (objectCache.containsKey(prop.getId())) {
                                continue;
                            }
                        }
                        Object lazyValue = prop.readValue(object, monitor, false);
                        if (lazyValue == null) {
                            lazyValue = NULL_VALUE;
                        }
                        Map map3 = ObjectListControl.this.lazyCache;
                        synchronized (map3) {
                            objectCache.put(prop.getId(), lazyValue);
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof InvocationTargetException) {
                            e = ((InvocationTargetException)e).getTargetException();
                        }
                        log.error((Object)("Error reading property '" + prop.getId() + "' from " + String.valueOf(object)), e);
                    }
                }
                monitor.worked(1);
            }
            monitor.done();
            if (!ObjectListControl.this.isDisposed()) {
                UIUtils.asyncExec(() -> {
                    if (!ObjectListControl.this.isDisposed()) {
                        ObjectListControl.this.itemsViewer.refresh();
                    }
                });
            }
            if (monitor.isCanceled()) {
                ObjectListControl.this.lazyLoadCanceled = true;
                ObjectListControl.this.obtainLazyObjects();
            }
            return Status.OK_STATUS;
        }
    }

    private static class LazyValue {
        private final Object value;

        private LazyValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public class ObjectActionVisualizer
    extends ProgressPageControl.ProgressVisualizer<Void> {
        public ObjectActionVisualizer() {
            super((ProgressPageControl)ObjectListControl.this);
        }

        public void completeLoading(Void v) {
            super.completeLoading((Object)v);
        }
    }

    public static class ObjectColumn {
        String id;
        String displayName;
        int columnIndex;
        Map<Class<?>, ObjectPropertyDescriptor> propMap = new IdentityHashMap();

        private ObjectColumn(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        void addProperty(Class<?> objectClass, ObjectPropertyDescriptor prop) {
            this.propMap.put(objectClass, prop);
        }

        public boolean isNameColumn(Object object) {
            ObjectPropertyDescriptor property = this.getProperty(object);
            return property != null && property.isNameProperty();
        }

        @Nullable
        public ObjectPropertyDescriptor getProperty(Object object) {
            return object == null ? null : ObjectListControl.getPropertyByObject(this, object);
        }
    }

    protected class ObjectColumnLabelProvider
    extends ColumnLabelProvider
    implements ILabelProviderEx {
        protected final ObjectColumn objectColumn;

        protected ObjectColumnLabelProvider(ObjectColumn objectColumn) {
            this.objectColumn = objectColumn;
        }

        @Nullable
        public Image getImage(Object element) {
            Object object;
            Object objectValue;
            if (element instanceof ObjectsGroupingWrapper) {
                if (this.objectColumn == ObjectListControl.this.groupingColumn) {
                    List<Object> groupedElements = ((ObjectsGroupingWrapper)element).groupedElements;
                    element = groupedElements.get(0);
                } else {
                    return null;
                }
            }
            if ((objectValue = ObjectListControl.this.getObjectValue(object = element)) == null) {
                return null;
            }
            ObjectPropertyDescriptor prop = ObjectListControl.getPropertyByObject(this.objectColumn, objectValue);
            if (prop != null && prop.isNameProperty()) {
                DBPImage objectImage = ObjectListControl.this.getObjectImage(object);
                return objectImage == null ? null : DBeaverIcons.getImage((DBPImage)objectImage);
            }
            return null;
        }

        public String getText(Object element) {
            return this.getText(element, true);
        }

        public Color getBackground(Object element) {
            if (element instanceof ObjectsGroupingWrapper) {
                return null;
            }
            return ObjectListControl.this.getObjectBackground(element);
        }

        public Color getForeground(Object element) {
            if (element instanceof ObjectsGroupingWrapper) {
                return null;
            }
            return ObjectListControl.this.getObjectForeground(element);
        }

        public String getText(Object element, boolean forUI) {
            return this.getText(element, forUI, false);
        }

        public String getText(Object element, boolean forUI, boolean forTip) {
            Object cellValue = ObjectListControl.this.getCellValue(element, this.objectColumn, forUI);
            if (cellValue instanceof LazyValue) {
                cellValue = ((LazyValue)cellValue).value;
            }
            if (forUI && !ObjectListControl.this.sampleItems && ObjectListControl.this.renderer.isHyperlink(element, cellValue)) {
                return ObjectListControl.EMPTY_STRING;
            }
            if (element instanceof ObjectsGroupingWrapper) {
                return CommonUtils.toString((Object)cellValue);
            }
            Object objectValue = ObjectListControl.this.getObjectValue(element);
            if (objectValue == null) {
                return ObjectListControl.EMPTY_STRING;
            }
            ObjectPropertyDescriptor prop = ObjectListControl.getPropertyByObject(this.objectColumn, objectValue);
            if (prop != null) {
                if (forUI && cellValue instanceof Boolean) {
                    return ObjectListControl.EMPTY_STRING;
                }
                if (prop.isPassword() && cellValue instanceof String) {
                    return CommonUtils.isEmpty((String)((String)cellValue)) ? ObjectListControl.EMPTY_STRING : "************";
                }
                return ObjectViewerRenderer.getCellString((Object)cellValue, (boolean)prop.isNameProperty());
            }
            return ObjectListControl.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            String text = this.getText(element, true, true);
            if (CommonUtils.isEmpty((String)text)) {
                return null;
            }
            return text;
        }
    }

    private static class ObjectsGroupingWrapper {
        private final Object groupingKey;
        private final List<Object> groupedElements;

        private ObjectsGroupingWrapper(@Nullable Object groupingKey, @NotNull List<Object> groupedElements) {
            this.groupingKey = groupingKey;
            this.groupedElements = groupedElements;
        }

        public String toString() {
            return (String)(this.groupingKey != null ? "Grouped by: " + this.groupingKey.toString() + ". " : ObjectListControl.EMPTY_STRING) + "Elements amount: " + this.groupedElements.size();
        }
    }

    public class ObjectsLoadVisualizer
    extends ProgressPageControl.ProgressVisualizer<Collection<OBJECT_TYPE>> {
        private final boolean forUpdate;

        public ObjectsLoadVisualizer(boolean forUpdate) {
            super((ProgressPageControl)ObjectListControl.this);
            this.forUpdate = forUpdate;
        }

        public ObjectsLoadVisualizer() {
            this(false);
        }

        public void completeLoading(Collection<OBJECT_TYPE> items) {
            super.completeLoading(items);
            this.afterCompleteLoading(items);
        }

        protected void afterCompleteLoading(@NotNull Collection<OBJECT_TYPE> items) {
            ObjectListControl.this.setListData(items, false, this.forUpdate);
        }
    }

    class PaintListener
    implements Listener {
        PaintListener() {
        }

        public void handleEvent(Event e) {
            if (ObjectListControl.this.isDisposed()) {
                return;
            }
            switch (e.type) {
                case 42: {
                    boolean isFocusCell;
                    if (e.index >= ObjectListControl.this.columnController.getColumnsCount()) break;
                    ObjectColumn objectColumn = ObjectListControl.this.getColumnByIndex(e.index);
                    if (objectColumn == null) {
                        return;
                    }
                    Object object = e.item.getData();
                    boolean bl = isFocusCell = ObjectListControl.this.focusObject == object && ObjectListControl.this.focusColumn == objectColumn;
                    if (object instanceof ObjectsGroupingWrapper) break;
                    Object objectValue = ObjectListControl.this.getObjectValue(object);
                    Object cellValue = ObjectListControl.this.getCellValue(object, objectColumn, true);
                    if (cellValue instanceof LazyValue) {
                        if (ObjectListControl.this.lazyLoadCanceled) break;
                        ObjectListControl.this.addLazyObject(object, objectColumn);
                        break;
                    }
                    ObjectPropertyDescriptor prop = ObjectListControl.getPropertyByObject(objectColumn, objectValue);
                    if (ObjectListControl.this.itemsViewer.isCellEditorActive() && isFocusCell) {
                        return;
                    }
                    if (cellValue != null && prop != null) {
                        ObjectListControl.this.renderer.paintCell(e, object, cellValue, e.item, prop.getDataType(), e.index, prop.isEditable(objectValue), (e.detail & 2) == 2);
                        break;
                    }
                    if (prop != null) break;
                    ObjectListControl.this.renderer.paintInvalidCell(e, e.item, e.index);
                }
            }
        }
    }

    private static final class SearchFilter
    extends ViewerFilter {
        private final Pattern pattern;

        private SearchFilter(String searchString, boolean caseSensitiveSearch) {
            this.pattern = Pattern.compile(SQLUtils.makeLikePattern((String)searchString), caseSensitiveSearch ? 0 : 2);
        }

        /*
         * WARNING - void declaration
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block3: {
                block4: {
                    void owd;
                    Object object;
                    block2: {
                        void namedObject;
                        Object object2 = element;
                        if (!(object2 instanceof DBPNamedObject)) break block2;
                        DBPNamedObject dBPNamedObject = (DBPNamedObject)object2;
                        DBPNamedObject cfr_ignored_0 = (DBPNamedObject)object2;
                        if (this.matches(namedObject.getName())) break block3;
                    }
                    if (!((object = element) instanceof DBPObjectWithDescription)) break block4;
                    DBPObjectWithDescription dBPObjectWithDescription = (DBPObjectWithDescription)object;
                    DBPObjectWithDescription cfr_ignored_1 = (DBPObjectWithDescription)object;
                    if (this.matches(owd.getDescription())) break block3;
                }
                return false;
            }
            return true;
        }

        private boolean matches(@Nullable CharSequence charSequence) {
            if (charSequence == null) {
                return false;
            }
            Matcher matcher = this.pattern.matcher(charSequence);
            return matcher.find();
        }
    }

    public class SearcherFilter
    implements ISearchExecutor {
        public boolean performSearch(String searchString, int options) {
            try {
                SearchFilter searchFilter = new SearchFilter(searchString, (options & 1) != 0);
                ObjectListControl.this.getItemsViewer().setFilters(new ViewerFilter[]{searchFilter});
                return true;
            }
            catch (PatternSyntaxException e) {
                log.error((Object)e.getMessage());
                return false;
            }
        }

        public void cancelSearch() {
            ObjectListControl.this.getItemsViewer().setFilters(new ViewerFilter[0]);
        }
    }

    protected class ViewerRenderer
    extends ObjectViewerRenderer {
        protected ViewerRenderer() {
            super(ObjectListControl.this.itemsViewer);
        }

        @Nullable
        public Object getCellValue(Object element, int columnIndex) {
            return ObjectListControl.this.getCellValue(element, columnIndex);
        }
    }
}

