/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dnd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.ui.part.EditorInputTransfer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNStreamData;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dnd.DatabaseObjectTransfer;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.navigator.dnd.NavigatorTransferInfo;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorDragSourceListener
implements DragSourceListener {
    private static final Log log = Log.getLog(NavigatorDragSourceListener.class);
    private final Viewer viewer;
    private IStructuredSelection selection;
    private Path tempFolder;

    public NavigatorDragSourceListener(Viewer viewer) {
        this.viewer = viewer;
    }

    private synchronized Path getTempFolder() {
        if (this.tempFolder == null) {
            try {
                this.tempFolder = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "dnd-files");
            }
            catch (IOException e) {
                log.error((Object)e);
                this.tempFolder = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
            }
        }
        return this.tempFolder;
    }

    public void dragStart(DragSourceEvent event) {
        this.selection = (IStructuredSelection)this.viewer.getSelection();
    }

    public void dragSetData(DragSourceEvent event) {
        if (!this.selection.isEmpty()) {
            Map<DBNNode, NavigatorTransferInfo> info = this.collectNodesInfo(event);
            if (TreeNodeTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = info.keySet();
            } else if (DatabaseObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = info.values().stream().map(NavigatorTransferInfo::getObject).filter(Objects::nonNull).collect(Collectors.toList());
            } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = info.values().stream().map(NavigatorTransferInfo::getName).collect(Collectors.joining(CommonUtils.getLineSeparator()));
            } else if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = info.values().stream().map(NavigatorTransferInfo::createEditorInputData).filter(Objects::nonNull).toArray(EditorInputTransfer.EditorInputData[]::new);
            } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = info.values().stream().map(NavigatorTransferInfo::getName).filter(name -> Files.exists(Path.of(name, new String[0]), new LinkOption[0])).toArray(String[]::new);
            }
        } else {
            this.setEmptyData(event);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Map<DBNNode, NavigatorTransferInfo> collectNodesInfo(DragSourceEvent event) {
        LinkedHashMap<DBNNode, NavigatorTransferInfo> info = new LinkedHashMap<DBNNode, NavigatorTransferInfo>();
        for (Object nextSelected : this.selection) {
            void node;
            String nodeName;
            Object nodeObject;
            block9: {
                Object e = nextSelected;
                if (!(e instanceof DBNNode)) continue;
                DBNNode cfr_ignored_0 = (DBNNode)e;
                DBNNode cfr_ignored_1 = (DBNNode)e;
                nodeObject = null;
                if (nextSelected instanceof DBNDatabaseNode && !(nextSelected instanceof DBNDataSource)) {
                    object = ((DBNDatabaseNode)nextSelected).getObject();
                    if (object == null) continue;
                    nodeName = DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI);
                    nodeObject = object;
                } else if (nextSelected instanceof DBNDataSource) {
                    object = ((DBNDataSource)nextSelected).getDataSourceContainer();
                    nodeName = object.getName();
                    nodeObject = object;
                } else {
                    Object e2 = nextSelected;
                    if (e2 instanceof DBNStreamData) {
                        void streamData;
                        DBNStreamData cfr_ignored_2 = (DBNStreamData)e2;
                        DBNStreamData cfr_ignored_3 = (DBNStreamData)e2;
                        if (streamData.supportsStreamData() && (EditorInputTransfer.getInstance().isSupportedType(event.dataType) || FileTransfer.getInstance().isSupportedType(event.dataType))) {
                            String fileName = node.getNodeDisplayName();
                            try {
                                Path tmpFile = this.copyStreamToTempFile((DBNStreamData)streamData, fileName);
                                if (tmpFile == null) continue;
                                nodeObject = tmpFile;
                                nodeName = tmpFile.toAbsolutePath().toString();
                                break block9;
                            }
                            catch (Exception e3) {
                                log.error((Object)e3.getMessage());
                                continue;
                            }
                        }
                    }
                    nodeName = node.getNodeTargetName();
                }
            }
            info.put((DBNNode)node, new NavigatorTransferInfo(nodeName, (DBNNode)node, nodeObject));
        }
        return info;
    }

    @Nullable
    private Path copyStreamToTempFile(DBNStreamData streamData, String fileName) throws InvocationTargetException, InterruptedException {
        Path tmpFile = this.getTempFolder().resolve(CommonUtils.escapeFileName((String)fileName));
        if (!Files.exists(tmpFile, new LinkOption[0])) {
            try {
                Files.createFile(tmpFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Can't create new file" + String.valueOf(tmpFile.toAbsolutePath())), (Throwable)e);
                return null;
            }
            UIUtils.runInProgressService(monitor -> {
                try {
                    long streamSize = streamData.getStreamSize();
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (InputStream is = streamData.openInputStream();){
                        Throwable throwable2 = null;
                        Object var9_12 = null;
                        try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                            ContentUtils.copyStreams((InputStream)is, (long)streamSize, (OutputStream)out, (DBRProgressMonitor)monitor);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    try {
                        Files.delete(tmpFile);
                    }
                    catch (IOException iOException) {
                        log.error((Object)("Error deleting temp file " + String.valueOf(tmpFile.toAbsolutePath())), (Throwable)e);
                    }
                    throw new InvocationTargetException(e);
                }
            });
        }
        return tmpFile;
    }

    private void setEmptyData(DragSourceEvent event) {
        if (TreeNodeTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = Collections.emptyList();
        } else if (DatabaseObjectTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = Collections.emptyList();
        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = "";
        } else if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = new EditorInputTransfer.EditorInputData[0];
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = new String[0];
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.selection = null;
    }
}

