/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.DefaultViewerToolTipSupport;
import org.jkiss.dbeaver.ui.navigator.INavigatorItemRenderer;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;

class DatabaseNavigatorToolTipSupport
extends DefaultViewerToolTipSupport {
    private DatabaseNavigatorTree databaseNavigatorTree;

    DatabaseNavigatorToolTipSupport(DatabaseNavigatorTree databaseNavigatorTree) {
        super((ColumnViewer)databaseNavigatorTree.getViewer());
        this.databaseNavigatorTree = databaseNavigatorTree;
    }

    protected boolean shouldCreateToolTip(Event event) {
        Tree tree = (Tree)event.widget;
        TreeItem item = tree.getItem(new Point(event.x, event.y));
        if (item == null) {
            return false;
        }
        Rectangle bounds = item.getBounds(0);
        if (event.x >= bounds.x && event.x <= bounds.x + bounds.width) {
            return super.shouldCreateToolTip(event);
        }
        INavigatorItemRenderer itemRenderer = this.databaseNavigatorTree.getItemRenderer();
        Object data = item.getData();
        if (data instanceof DBNNode) {
            itemRenderer.showDetailsToolTip((DBNNode)data, tree, event);
        }
        return false;
    }

    protected Object getToolTipArea(Event event) {
        TreeItem item = ((Tree)event.widget).getItem(new Point(event.x, event.y));
        if (item == null) {
            return false;
        }
        Rectangle bounds = item.getBounds(0);
        if (event.x >= bounds.x && event.x <= bounds.x + bounds.width) {
            return super.getToolTipArea(event);
        }
        return null;
    }

    protected String getText(Event event) {
        return super.getText(event);
    }
}

