/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseObject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInputFactory;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseNodeEditorInput;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.ui.editors.NodeEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.entity.FolderEditor;
import org.jkiss.dbeaver.ui.editors.object.ObjectEditorInput;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectOpen
extends NavigatorHandlerObjectBase
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerObjectOpen.class);
    private static final int MAX_OBJECT_SIZE_NO_CONFIRM = 3;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (UIUtils.isInDialog()) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            if (structSelection.size() > 3 && !UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)NLS.bind((String)UINavigatorMessages.actions_navigator_open_editors_title, (Object)structSelection.size()), (String)NLS.bind((String)UINavigatorMessages.actions_navigator_open_editors_question, (Object)structSelection.size()))) {
                return null;
            }
            for (Object element : structSelection) {
                DBNNode node = null;
                if (element instanceof IResource) {
                    UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                    if (serviceSQL == null) continue;
                    serviceSQL.openResource((IResource)element);
                    continue;
                }
                if (element instanceof DBNNode) {
                    node = (DBNNode)element;
                } else {
                    DBSObject object = (DBSObject)RuntimeUtils.getObjectAdapter(element, DBSObject.class);
                    if (object != null) {
                        node = NavigatorHandlerObjectOpen.getNodeByObject(object);
                    }
                }
                if (node == null) continue;
                NavigatorUtils.openNavigatorNode(node, HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), event.getParameters());
            }
        }
        return null;
    }

    @Nullable
    public static IEditorPart openEntityEditor(DBSObject object) {
        DBNDatabaseNode node = NavigatorHandlerObjectOpen.getNodeByObject(object);
        if (node != null) {
            return NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)node, null, UIUtils.getActiveWorkbenchWindow());
        }
        return null;
    }

    public static IEditorPart openEntityEditor(DBNNode selectedNode, @Nullable String defaultPageId, IWorkbenchWindow workbenchWindow) {
        return NavigatorHandlerObjectOpen.openEntityEditor(selectedNode, defaultPageId, null, null, workbenchWindow, true, true);
    }

    public static IEditorPart openEntityEditor(@NotNull DBNNode selectedNode, @Nullable String defaultPageId, @Nullable String defaultFolderId, @Nullable Map<String, Object> attributes, IWorkbenchWindow workbenchWindow, boolean activate) {
        return NavigatorHandlerObjectOpen.openEntityEditor(selectedNode, defaultPageId, defaultFolderId, attributes, workbenchWindow, activate, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IEditorPart openEntityEditor(@NotNull DBNNode selectedNode, @Nullable String defaultPageId, @Nullable String defaultFolderId, @Nullable Map<String, Object> attributes, IWorkbenchWindow workbenchWindow, boolean activate, boolean connectionEditorAllowed) {
        DBPDataSourceContainer dataSourceContainer;
        if (connectionEditorAllowed && selectedNode instanceof DBNDataSource && (dataSourceContainer = ((DBNDataSource)selectedNode).getDataSourceContainer()).getProject().hasRealmPermission("project-datasource-edit")) {
            NavigatorHandlerObjectOpen.openConnectionEditor(workbenchWindow, dataSourceContainer);
            return null;
        }
        try {
            IEditorPart editor;
            if (selectedNode instanceof DBNDatabaseFolder && !(selectedNode.getParentNode() instanceof DBNDatabaseFolder) && selectedNode.getParentNode() instanceof DBNDatabaseNode) {
                if (defaultFolderId == null) {
                    defaultFolderId = selectedNode.getNodeTypeLabel();
                }
                selectedNode = selectedNode.getParentNode();
            }
            if ((editor = NavigatorHandlerObjectOpen.findEntityEditor(workbenchWindow, selectedNode)) != null) {
                IEditorPart pageEditor;
                boolean settingsChanged = false;
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput instanceof DatabaseEditorInput) {
                    settingsChanged = NavigatorHandlerObjectOpen.setInputAttributes((DatabaseEditorInput)editorInput, defaultPageId, defaultFolderId, attributes);
                }
                if (editor instanceof EntityEditor && defaultPageId != null && (pageEditor = ((EntityEditor)editor).getPageEditor(defaultPageId)) != null && pageEditor != ((EntityEditor)editor).getActiveEditor()) {
                    ((EntityEditor)editor).setActiveEditor(pageEditor);
                }
                if (editor instanceof ITabbedFolderContainer && defaultFolderId != null && ((ITabbedFolderContainer)editor).switchFolder(defaultFolderId)) {
                    settingsChanged = true;
                }
                if (settingsChanged && editor instanceof IRefreshablePart) {
                    ((IRefreshablePart)editor).refreshPart((Object)selectedNode, true);
                }
                if (workbenchWindow.getActivePage().getActiveEditor() != editor || activate) {
                    workbenchWindow.getActivePage().activate((IWorkbenchPart)editor);
                }
                return editor;
            }
            if (!(selectedNode instanceof DBNDatabaseNode)) {
                NodeEditorInput folderInput = new NodeEditorInput(selectedNode);
                return workbenchWindow.getActivePage().openEditor((IEditorInput)folderInput, FolderEditor.class.getName());
            }
            DBNDatabaseNode dnNode = (DBNDatabaseNode)selectedNode;
            DBSObject databaseObject = dnNode.getObject();
            if (databaseObject == null) {
                DBWorkbench.getPlatformUI().showError("No object", "Node has no associated database object");
                return null;
            }
            if (!databaseObject.isPersisted()) {
                return null;
            }
            try {
                DBUtils.getOrOpenDefaultContext((DBSObject)databaseObject, (boolean)false);
            }
            catch (DBCException dBCException) {
                return null;
            }
            if (selectedNode instanceof DBNDatabaseObject) {
                DBNDatabaseObject objectNode = (DBNDatabaseObject)selectedNode;
                if (!objectNode.isPersisted()) {
                    return null;
                }
                ObjectEditorInput objectInput = new ObjectEditorInput(objectNode);
                NavigatorHandlerObjectOpen.setInputAttributes(objectInput, defaultPageId, defaultFolderId, attributes);
                return workbenchWindow.getActivePage().openEditor((IEditorInput)objectInput, objectNode.getMeta().getEditorId());
            }
            DatabaseNodeEditorInput editorInput = new DatabaseNodeEditorInput(dnNode);
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.refresh.editor.open")) {
                NavigatorHandlerObjectOpen.refreshDatabaseNode(dnNode);
            }
            NavigatorHandlerObjectOpen.setInputAttributes(editorInput, defaultPageId, defaultFolderId, attributes);
            return workbenchWindow.getActivePage().openEditor((IEditorInput)editorInput, EntityEditor.class.getName());
        }
        catch (Exception ex) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_error_dialog_open_entity_title, "Can't open entity '" + selectedNode.getNodeDisplayName() + "'", (Throwable)ex);
            return null;
        }
    }

    public static IEditorPart findEntityEditor(IWorkbenchWindow workbenchWindow, DBNNode node) {
        if (node == null) {
            return null;
        }
        DatabaseEditorInputFactory.setLookupEditor((boolean)true);
        try {
            IEditorReference[] iEditorReferenceArray = workbenchWindow.getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    IEditorInput editorInput;
                    IEditorReference ref = iEditorReferenceArray[n2];
                    try {
                        editorInput = ref.getEditorInput();
                    }
                    catch (Throwable throwable) {
                        break block12;
                    }
                    if (editorInput instanceof INavigatorEditorInput) {
                        boolean matches;
                        if (editorInput instanceof DatabaseLazyEditorInput) {
                            matches = node.getNodeUri().equals(((DatabaseLazyEditorInput)editorInput).getNodePath());
                        } else {
                            boolean bl = matches = ((INavigatorEditorInput)editorInput).getNavigatorNode() == node;
                        }
                        if (matches) {
                            IEditorPart iEditorPart = ref.getEditor(true);
                            return iEditorPart;
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            DatabaseEditorInputFactory.setLookupEditor((boolean)false);
        }
        return null;
    }

    private static void refreshDatabaseNode(@NotNull DBNDatabaseNode selectedNode) throws InvocationTargetException, InterruptedException {
        DBNDatabaseNode nodeToRefresh = selectedNode;
        UIUtils.runInProgressService(monitor -> {
            try {
                nodeToRefresh.refreshNode(monitor, (Object)nodeToRefresh);
            }
            catch (DBException e) {
                log.error((Object)"Error refreshing database object", (Throwable)e);
            }
        });
    }

    public static void openConnectionEditor(IWorkbenchWindow workbenchWindow, DBPDataSourceContainer dataSourceContainer) {
        UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
        if (serviceConnections != null) {
            serviceConnections.openConnectionEditor(dataSourceContainer, null);
        }
    }

    private static boolean setInputAttributes(DatabaseEditorInput<?> editorInput, String defaultPageId, String defaultFolderId, Map<String, Object> attributes) {
        boolean changed = false;
        if (defaultFolderId != null && !CommonUtils.equalObjects((Object)defaultFolderId, (Object)editorInput.getDefaultFolderId())) {
            editorInput.setDefaultFolderId(defaultFolderId);
            changed = true;
            if (defaultPageId == null) {
                defaultPageId = "default.object.editor";
            }
        }
        if (defaultPageId != null && !CommonUtils.equalObjects((Object)defaultPageId, (Object)editorInput.getDefaultPageId())) {
            editorInput.setDefaultPageId(defaultPageId);
            changed = true;
        }
        if (!CommonUtils.isEmpty(attributes)) {
            for (Map.Entry<String, Object> attr : attributes.entrySet()) {
                if (CommonUtils.equalObjects((Object)editorInput.getAttribute(attr.getKey()), (Object)attr.getValue())) continue;
                editorInput.setAttribute(attr.getKey(), attr.getValue());
                changed = true;
            }
        }
        return changed;
    }

    public void updateElement(UIElement element, Map parameters) {
        ISelection selection;
        DBNNode node;
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider((IServiceLocator)element.getServiceLocator());
        if (selectionProvider != null && (node = NavigatorUtils.getSelectedNode(selection = selectionProvider.getSelection())) != null) {
            String actionName = UINavigatorMessages.actions_navigator_open;
            if (node instanceof DBNDataSource && node.getOwnerProject().hasRealmPermission("project-datasource-edit")) {
                actionName = UINavigatorMessages.actions_navigator_edit;
            } else if (node instanceof DBNDatabaseNode) {
                DBSObject object = ((DBNDatabaseNode)node).getObject();
                if (object != null) {
                    actionName = UINavigatorMessages.actions_navigator_view;
                }
            } else if (node instanceof DBNNodeWithResource) {
                actionName = UINavigatorMessages.actions_navigator_error_dialog_open_resource_title;
            }
            Object label = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1 ? NLS.bind((String)actionName, (Object)UINavigatorMessages.actions_navigator__objects) : (node instanceof DBNNodeWithResource ? actionName + " '" + node.getNodeDisplayName() + "'" : NLS.bind((String)actionName, (Object)node.getNodeTypeLabel()));
            element.setText((String)label);
        }
    }
}

