/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.navigator.project.ProjectExplorerView;
import org.jkiss.dbeaver.ui.navigator.project.ProjectNavigatorView;

public class NavigatorHandlerLinkEditor
extends AbstractHandler {
    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor == null) {
            return null;
        }
        NavigatorViewBase navigatorView = NavigatorUtils.getActiveNavigatorView(event);
        if (navigatorView == null) {
            return null;
        }
        if (navigatorView instanceof ProjectExplorerView || navigatorView instanceof ProjectNavigatorView && activeEditor instanceof ITextEditor) {
            IFile file = EditorUtils.getFileFromInput((IEditorInput)activeEditor.getEditorInput());
            if (file != null) {
                this.showResourceInNavigator(navigatorView, file);
            }
        } else {
            DBNModel globalNavigatorModel = NavigatorViewBase.getGlobalNavigatorModel();
            IEditorInput iEditorInput = activeEditor.getEditorInput();
            if (iEditorInput instanceof IDatabaseEditorInput) {
                DBSObject databaseObject;
                void editorInput;
                IDatabaseEditorInput iDatabaseEditorInput = (IDatabaseEditorInput)iEditorInput;
                IDatabaseEditorInput cfr_ignored_0 = (IDatabaseEditorInput)iEditorInput;
                DBNDatabaseNode dbnNode = editorInput.getNavigatorNode();
                if (dbnNode == null && (databaseObject = editorInput.getDatabaseObject()) != null) {
                    dbnNode = globalNavigatorModel.findNode(databaseObject);
                }
                if (dbnNode != null) {
                    navigatorView.showNode((DBNNode)dbnNode);
                }
            } else {
                IEditorPart iEditorPart = activeEditor;
                if (iEditorPart instanceof DBPDataSourceContainerProvider) {
                    void provider;
                    DBPDataSourceContainerProvider dbnNode = (DBPDataSourceContainerProvider)iEditorPart;
                    DBPDataSourceContainerProvider cfr_ignored_1 = (DBPDataSourceContainerProvider)iEditorPart;
                    DBPDataSourceContainer dsContainer = provider.getDataSourceContainer();
                    Object activeObject = null;
                    if (dsContainer != null) {
                        IEditorPart iEditorPart2 = activeEditor;
                        if (iEditorPart2 instanceof DBPContextProvider) {
                            DBCExecutionContextDefaults contextDefaults;
                            void contextProvider;
                            DBPContextProvider dBPContextProvider = (DBPContextProvider)iEditorPart2;
                            DBPContextProvider cfr_ignored_2 = (DBPContextProvider)iEditorPart2;
                            DBCExecutionContext executionContext = contextProvider.getExecutionContext();
                            if (executionContext != null && (contextDefaults = executionContext.getContextDefaults()) != null && (activeObject = contextDefaults.getDefaultSchema()) == null) {
                                activeObject = contextDefaults.getDefaultCatalog();
                            }
                        }
                        if (activeObject == null) {
                            DBPDataSource dataSource = dsContainer.getDataSource();
                            activeObject = dataSource != null ? DBUtils.getDefaultOrActiveObject((DBSInstance)dataSource.getDefaultInstance()) : dsContainer;
                        }
                        DBPDataSourceContainer objectToSelect = activeObject;
                        NavigatorViewBase view = navigatorView;
                        UIUtils.runInUI((IRunnableContext)activePage.getWorkbenchWindow(), arg_0 -> NavigatorHandlerLinkEditor.lambda$0((DBSObject)objectToSelect, globalNavigatorModel, view, arg_0));
                    }
                }
            }
        }
        activePage.activate((IWorkbenchPart)navigatorView);
        return null;
    }

    private void showResourceInNavigator(NavigatorViewBase activePart, IFile editorFile) {
        DBNResource resource;
        DBNProject projectNode = NavigatorViewBase.getGlobalNavigatorModel().getRoot().getProjectNode(editorFile.getProject());
        if (projectNode != null && (resource = projectNode.findResource((IResource)editorFile)) != null) {
            activePart.showNode((DBNNode)resource);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$0(DBSObject dBSObject, DBNModel dBNModel, NavigatorViewBase navigatorViewBase, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DBNDatabaseNode objectNode;
        DBSObject dBSObject2;
        DBSObject showObject = dBSObject;
        if (showObject instanceof DBSInstance && !(showObject instanceof DBPDataSourceContainer)) {
            showObject = dBSObject.getParentObject();
        }
        if ((dBSObject2 = showObject) instanceof DBPDataSource) {
            void dataSource;
            DBPDataSource dBPDataSource = (DBPDataSource)dBSObject2;
            DBPDataSource cfr_ignored_0 = (DBPDataSource)dBSObject2;
            showObject = dataSource.getContainer();
        }
        if ((objectNode = dBNModel.getNodeByObject(monitor, showObject, true)) != null) {
            navigatorViewBase.showNode((DBNNode)objectNode);
        }
    }
}

