/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class FloatTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Double>
implements TimeSeriesFieldDefinition<Double> {
    public FloatTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.DOUBLE);
    }

    public static FloatTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.DOUBLE.getInformixTypeName())) {
            return new FloatTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Double read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        return stream.readDouble();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Double value) throws SQLException {
        stream.writeDouble(value);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::float";
        }
        if (value instanceof Double) {
            return String.valueOf(((Double)value).toString()) + "::" + this.toSqlString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Double.class, value.getClass()));
    }

    @Override
    public Double convertValueTo(Object value) throws IllegalArgumentException {
        if (value == null || value instanceof Double) {
            return (Double)value;
        }
        return ObjectConversionUtilities.convertObjectToDouble(value, Double.class.getName());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FloatTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Double> {
        @Override
        public TimeSeriesFieldDefinition<Double> parse(String s) {
            return FloatTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

