/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class BigIntTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Long>
implements TimeSeriesFieldDefinition<Long> {
    public BigIntTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.LONG);
    }

    @Override
    public Long read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        long s = 0xFFFFFFFFL;
        int i1 = stream.readInt();
        int i2 = stream.readInt();
        long v = ((s & (long)i1) << 32) + ((long)i2 & s);
        return new Long(v);
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Long value) throws SQLException {
        if (!(value instanceof Long)) {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", Long.class.getName(), value.getClass().getName()));
        }
        long v = value;
        int i1 = (int)(v >> 32);
        int i2 = (int)(v & 0xFFFFFFFFL);
        stream.writeInt(i1);
        stream.writeInt(i2);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::bigint";
        }
        if (value instanceof Long) {
            return String.valueOf(((Long)value).toString()) + "::" + this.toSqlString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Long.class, value.getClass()));
    }

    @Override
    public Long convertValueTo(Object value) throws IllegalArgumentException {
        return ObjectConversionUtilities.convertObjectToLong(value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BigIntTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static BigIntTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.LONG.getInformixTypeName())) {
            return new BigIntTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Long> {
        @Override
        public TimeSeriesFieldDefinition<Long> parse(String s) {
            return BigIntTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

