/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

import com.informix.timeseries.IfmxCalendar;
import com.informix.timeseries.IfmxCalendarPattern;
import com.informix.timeseries.IfmxTimeSeries;
import com.informix.timeseries.PatternClassMap;
import java.util.Collections;
import java.util.Map;

public final class TimeSeriesTypeMap {
    private TimeSeriesTypeMap() {
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean caseSensitive = false;
        private boolean includeCalendar = true;
        private boolean includeCalendarPattern = true;
        private boolean includeTimeSeries = true;
        private boolean immutable = false;

        public final Builder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public final Builder includeCalendar(boolean includeCalendar) {
            this.includeCalendar = includeCalendar;
            return this;
        }

        public final Builder includeCalendarPattern(boolean includeCalendarPattern) {
            this.includeCalendarPattern = includeCalendarPattern;
            return this;
        }

        public final Builder includeTimeSeries(boolean includeTimeSeries) {
            this.includeTimeSeries = includeTimeSeries;
            return this;
        }

        public final Builder immutable(boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public final Map<String, Class<?>> build() {
            int initialSize = (this.includeCalendar ? 1 : 0) + (this.includeCalendarPattern ? 1 : 0) + (this.includeTimeSeries ? 1 : 0);
            PatternClassMap map = this.caseSensitive ? new PatternClassMap(initialSize, 0) : new PatternClassMap(initialSize, 2);
            if (this.includeTimeSeries) {
                map.put("^timeseries.*", IfmxTimeSeries.class);
            }
            if (this.includeCalendar) {
                map.put("^calendar", IfmxCalendar.class);
            }
            if (this.includeCalendarPattern) {
                map.put("^calendarpattern", IfmxCalendarPattern.class);
            }
            if (this.immutable) {
                return Collections.unmodifiableMap(map);
            }
            return map;
        }
    }
}

