/*
 * Decompiled with CFR 0.152.
 */
package com.informix.timeseries;

import com.informix.timeseries.JdbcUtilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public class TimeSeriesContainer {
    private static final int DEFAULT_FIRST_EXTENT = 16;
    private static final int DEFAULT_NEXT_EXTENT = 16;
    private final String name;
    private final String rowTypeName;
    private final String dbspaceName;
    private final int firstExtent;
    private final int nextExtent;

    TimeSeriesContainer(String containerName, String rowTypeName, String dbspaceName, int firstExtent, int nextExtent) {
        this.name = containerName;
        this.rowTypeName = rowTypeName;
        this.dbspaceName = dbspaceName;
        this.firstExtent = firstExtent;
        this.nextExtent = nextExtent;
    }

    public String getName() {
        return this.name;
    }

    public String getRowTypeName() {
        return this.rowTypeName;
    }

    public String getDbspaceName() {
        return this.dbspaceName;
    }

    public int getFirstExtent() {
        return this.firstExtent;
    }

    public int getNextExtent() {
        return this.nextExtent;
    }

    public void create(Connection connection) throws SQLException {
        String sql = "EXECUTE PROCEDURE TSContainerCreate(?, ?, ?, ?, ?)";
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("EXECUTE PROCEDURE TSContainerCreate(?, ?, ?, ?, ?)");
            statement.setString(1, this.name);
            statement.setString(2, this.dbspaceName);
            statement.setString(3, this.rowTypeName);
            statement.setInt(4, this.firstExtent);
            statement.setInt(5, this.nextExtent);
            statement.execute();
        }
        finally {
            JdbcUtilities.closeWithoutException(statement);
        }
    }

    public boolean delete(Connection connection) throws SQLException {
        String sql = "DELETE FROM tscontainertable WHERE name=?";
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("DELETE FROM tscontainertable WHERE name=?");
            statement.setString(1, this.name);
            boolean bl = statement.executeUpdate() > 0;
            return bl;
        }
        finally {
            JdbcUtilities.closeWithoutException(statement);
        }
    }

    public boolean exists(Connection connection) throws SQLException {
        try {
            TimeSeriesContainer other = TimeSeriesContainer.getContainer(connection, this.getName());
            return this.equals(other);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -206) {
                return false;
            }
            throw e;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TimeSeriesContainer getContainer(Connection connection, String name) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            TimeSeriesContainer timeSeriesContainer;
            String sql = "SELECT name,subtype,partitiondesc,flags,pool FROM tscontainertable WHERE name = ?";
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement("SELECT name,subtype,partitiondesc,flags,pool FROM tscontainertable WHERE name = ?");
                preparedStatement.setString(1, name);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                String containerName = resultSet.getString(1);
                String rowTypeName = resultSet.getString(2);
                String partitionDescription = resultSet.getString(3);
                String[] split = partitionDescription.split("\\ ");
                String dbspaceName = split[1];
                int firstExtent = Integer.parseInt(split[2]);
                int nextExtent = Integer.parseInt(split[3]);
                timeSeriesContainer = new TimeSeriesContainer(containerName, rowTypeName, dbspaceName, firstExtent, nextExtent);
            }
            catch (SQLException e) {
                try {
                    throw new SQLException(MessageFormat.format("Unable to get time series container {0}", name), e.getSQLState(), e.getErrorCode(), e);
                }
                catch (Throwable throwable) {
                    JdbcUtilities.closeWithoutException(resultSet);
                    JdbcUtilities.closeWithoutException(preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtilities.closeWithoutException(resultSet);
            JdbcUtilities.closeWithoutException(preparedStatement);
            return timeSeriesContainer;
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(preparedStatement);
        return null;
    }

    public static Set<TimeSeriesContainer> getContainers(Connection connection) throws SQLException {
        HashSet<TimeSeriesContainer> hashSet;
        HashSet<TimeSeriesContainer> containers = new HashSet<TimeSeriesContainer>();
        String sql = "SELECT name,subtype,partitiondesc,flags,pool FROM tscontainertable";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT name,subtype,partitiondesc,flags,pool FROM tscontainertable");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String calendarName = resultSet.getString(1);
                String rowTypeName = resultSet.getString(2);
                String partitionDescription = resultSet.getString(3);
                String[] split = partitionDescription.split("\\ ");
                String dbspaceName = split[1];
                int firstExtent = Integer.parseInt(split[2]);
                int nextExtent = Integer.parseInt(split[3]);
                containers.add(new TimeSeriesContainer(calendarName, rowTypeName, dbspaceName, firstExtent, nextExtent));
            }
            hashSet = containers;
        }
        catch (SQLException e) {
            try {
                throw new SQLException("Unable to time series containers", e);
            }
            catch (Throwable throwable) {
                JdbcUtilities.closeWithoutException(resultSet);
                JdbcUtilities.closeWithoutException(preparedStatement);
                throw throwable;
            }
        }
        JdbcUtilities.closeWithoutException(resultSet);
        JdbcUtilities.closeWithoutException(preparedStatement);
        return hashSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dbspaceName == null ? 0 : this.dbspaceName.hashCode());
        result = 31 * result + this.firstExtent;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.nextExtent;
        result = 31 * result + (this.rowTypeName == null ? 0 : this.rowTypeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesContainer)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSeriesContainer other = (TimeSeriesContainer)obj;
        if (this.dbspaceName == null ? other.dbspaceName != null : !this.dbspaceName.equals(other.dbspaceName)) {
            return false;
        }
        if (this.firstExtent != other.firstExtent) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nextExtent != other.nextExtent) {
            return false;
        }
        return !(this.rowTypeName == null ? other.rowTypeName != null : !this.rowTypeName.equals(other.rowTypeName));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeSeriesContainer [name=");
        builder.append(this.name);
        builder.append(", rowTypeName=");
        builder.append(this.rowTypeName);
        builder.append(", dbspaceName=");
        builder.append(this.dbspaceName);
        builder.append(", firstExtent=");
        builder.append(this.firstExtent);
        builder.append(", nextExtent=");
        builder.append(this.nextExtent);
        builder.append(']');
        return builder.toString();
    }

    public static final class Builder {
        private String containerName;
        private String rowTypeName;
        private String dbspaceName;
        private int firstExtent = 16;
        private int nextExtent = 16;

        public Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public Builder rowTypeName(String rowTypeName) {
            this.rowTypeName = rowTypeName;
            return this;
        }

        public String getRowTypeName() {
            return this.rowTypeName;
        }

        public Builder dbspaceName(String dbspaceName) {
            this.dbspaceName = dbspaceName;
            return this;
        }

        public String getDbspacename() {
            return this.dbspaceName;
        }

        public Builder firstExtent(int firstExtent) {
            this.firstExtent = firstExtent;
            return this;
        }

        public int getFirstExtent() {
            return this.firstExtent;
        }

        public Builder nextExtent(int nextExtent) {
            this.nextExtent = nextExtent;
            return this;
        }

        public int getNextExtent() {
            return this.nextExtent;
        }

        public TimeSeriesContainer build() {
            if (this.containerName == null) {
                throw new IllegalArgumentException("the container name must not be null");
            }
            IllegalArgumentException validationException = JdbcUtilities.validateInformixIdentifier(this.containerName);
            if (validationException != null) {
                throw new IllegalArgumentException(MessageFormat.format("Unable to create container ''{0}'' because it contains illegal characters", this.containerName), validationException);
            }
            if (this.containerName.length() > 128) {
                throw new IllegalArgumentException(MessageFormat.format("Unable to create container ''{0}'' because the container name is greater than 128 characters in length (was {1})", this.containerName, this.containerName.length()));
            }
            if (this.dbspaceName == null) {
                throw new IllegalArgumentException("the dbspace name must not be null");
            }
            validationException = JdbcUtilities.validateInformixIdentifier(this.dbspaceName);
            if (validationException != null) {
                throw new IllegalArgumentException(MessageFormat.format("Unable to create container ''{0}'' because the dbspace name contains illegal characters", this.containerName), validationException);
            }
            if (this.dbspaceName.length() > 128) {
                throw new IllegalArgumentException(MessageFormat.format("Unable to create container ''{0}'' because the dbspace name is greater than 128 characters in length (was {1})", this.containerName, this.dbspaceName.length()));
            }
            if (this.rowTypeName == null) {
                throw new IllegalArgumentException("the row type name must not be null");
            }
            validationException = JdbcUtilities.validateInformixIdentifier(this.rowTypeName);
            if (validationException != null) {
                throw new IllegalArgumentException(MessageFormat.format("Unable to create container ''{0}'' because the row type name contains illegal characters", this.containerName), validationException);
            }
            if (this.rowTypeName.length() > 128) {
                throw new IllegalArgumentException(MessageFormat.format("Unable to create container ''{0}'' because the row type name is greater than 128 characters in length (was {1})", this.containerName, this.rowTypeName.length()));
            }
            return new TimeSeriesContainer(this.containerName, this.rowTypeName, this.dbspaceName, this.firstExtent, this.nextExtent);
        }
    }
}

