/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ui.views;

import com.dbeaver.db.ui.internal.OdbcUIMessages;
import com.dbeaver.jdbc.odbc.JdbcOdbcUtils;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.IConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class OdbcConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Button modeDsnButton;
    private Button modeManualButton;
    private Composite dsnGroup;
    private Composite manualGroup;
    private ToolItem refreshDsnItem;
    private ToolItem refreshDriversItem;
    private Combo dsnCombo;
    private Combo driverCombo;
    private Text hostNameText;
    private Text hostPortText;
    private Text databaseNameText;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Group group = UIUtils.createControlGroup((Composite)composite, (String)OdbcUIMessages.page_connection_title, (int)1, (int)768, (int)0);
        ModifyListener modifyListener = e -> UIUtils.asyncExec(() -> {
            this.validate();
            this.getSite().updateButtons();
        });
        SelectionListener visibilityListener = SelectionListener.widgetSelectedAdapter(e -> this.updateGroupVisibility((String)e.widget.getData()));
        Composite selectorGroup = new Composite((Composite)group, 0);
        selectorGroup.setLayoutData((Object)new GridData(1808));
        selectorGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        UIUtils.createControlLabel((Composite)selectorGroup, (String)OdbcUIMessages.page_connection_mode);
        this.modeDsnButton = UIUtils.createRadioButton((Composite)selectorGroup, (String)OdbcUIMessages.page_connection_datasource, (Object)"dsn", (SelectionListener)visibilityListener);
        this.modeManualButton = UIUtils.createRadioButton((Composite)selectorGroup, (String)OdbcUIMessages.page_connection_manual, (Object)"manual", (SelectionListener)visibilityListener);
        if (((IConnectionWizard)this.getSite().getWizard()).getDriverSubstitution() != null) {
            ++((GridLayout)selectorGroup.getLayout()).numColumns;
            this.createDriverSubstitutionControls(selectorGroup);
        }
        this.dsnGroup = new Composite((Composite)group, 0);
        this.dsnGroup.setLayoutData((Object)new GridData(1808));
        this.dsnGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.dsnCombo = UIUtils.createLabelCombo((Composite)this.dsnGroup, (String)OdbcUIMessages.page_connection_datasource_datasource, (int)4);
        this.dsnCombo.addModifyListener(modifyListener);
        this.dsnCombo.setToolTipText(OdbcUIMessages.page_connection_dataSource_tooltip);
        this.refreshDsnItem = UIUtils.createToolItem((ToolBar)new ToolBar(this.dsnGroup, 256), (String)OdbcUIMessages.page_connection_datasource_refresh, (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.refreshDataSources()));
        if (RuntimeUtils.isWindows()) {
            UIUtils.createPlaceholder((Composite)this.dsnGroup, (int)1);
            UIUtils.createInfoLabel((Composite)this.dsnGroup, (String)OdbcUIMessages.page_connection_datasource_hint, (int)768, (int)2, () -> {
                boolean bl = ShellUtils.launchProgram((String)"odbcad32");
            });
        }
        this.manualGroup = new Composite((Composite)group, 0);
        this.manualGroup.setLayoutData((Object)new GridData(1808));
        this.manualGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
        UIUtils.createControlLabel((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_driver);
        Composite driverComposite = new Composite(this.manualGroup, 0);
        driverComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        driverComposite.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.driverCombo = new Combo(driverComposite, 12);
        this.driverCombo.addModifyListener(modifyListener);
        this.driverCombo.setLayoutData((Object)new GridData(768));
        this.refreshDriversItem = UIUtils.createToolItem((ToolBar)new ToolBar(driverComposite, 256), (String)OdbcUIMessages.page_connection_manual_driver_refresh, (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.refreshDrivers()));
        this.hostNameText = UIUtils.createLabelText((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_host_name, (String)"");
        this.hostNameText.addModifyListener(modifyListener);
        this.hostNameText.setLayoutData((Object)new GridData(768));
        this.hostPortText = UIUtils.createLabelText((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_host_port, (String)"");
        this.hostPortText.addModifyListener(modifyListener);
        this.hostPortText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.hostPortText.setLayoutData((Object)new GridData(32));
        ((GridData)this.hostPortText.getLayoutData()).widthHint = UIUtils.getFontHeight((Font)this.hostPortText.getFont()) * 10;
        this.databaseNameText = UIUtils.createLabelText((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_database_name, (String)"");
        ((GridData)this.databaseNameText.getLayoutData()).horizontalSpan = 3;
        this.createAuthPanel(composite, 1);
        this.createDriverPanel(composite);
        this.setControl((Control)composite);
    }

    public void loadSettings() {
        DBPConnectionConfiguration configuration = this.site.getActiveDataSource().getConnectionConfiguration();
        String mode = configuration.getProviderProperty("odbc-connection-mode");
        this.updateGroupVisibility(mode);
        if (CommonUtils.isNotEmpty((String)configuration.getHostName())) {
            this.hostNameText.setText(CommonUtils.notEmpty((String)configuration.getHostName()));
        } else {
            this.hostNameText.setText(CommonUtils.toString((Object)this.site.getDriver().getDefaultHost(), (String)"localhost"));
        }
        if (CommonUtils.isEmpty((String)configuration.getHostPort()) && this.site.isNew()) {
            this.hostPortText.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultPort()));
        } else {
            this.hostPortText.setText(CommonUtils.notEmpty((String)configuration.getHostPort()));
        }
        if (CommonUtils.isEmpty((String)configuration.getDatabaseName()) && this.site.isNew()) {
            this.databaseNameText.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultDatabase()));
        } else {
            this.databaseNameText.setText(CommonUtils.notEmpty((String)configuration.getDatabaseName()));
        }
        if ("manual".equals(mode)) {
            this.modeManualButton.setSelection(true);
        } else {
            this.modeDsnButton.setSelection(true);
        }
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (this.modeDsnButton.getSelection()) {
            configuration.setProviderProperty("odbc-connection-mode", "dsn");
            configuration.setDatabaseName(this.dsnCombo.getText());
        } else {
            configuration.setProviderProperty("odbc-connection-mode", "manual");
            configuration.setServerName(this.driverCombo.getText());
            configuration.setHostName(this.hostNameText.getText());
            configuration.setHostPort(this.hostPortText.getText());
            configuration.setDatabaseName(this.databaseNameText.getText());
        }
    }

    public boolean isComplete() {
        if (this.modeDsnButton.getSelection()) {
            return super.isComplete() && ArrayUtils.contains((Object[])this.dsnCombo.getItems(), (Object)this.dsnCombo.getText());
        }
        return super.isComplete() && ArrayUtils.contains((Object[])this.driverCombo.getItems(), (Object)this.driverCombo.getText()) && CommonUtils.isNotEmpty((String)this.hostNameText.getText()) && CommonUtils.isNotEmpty((String)this.hostPortText.getText());
    }

    public Image getImage() {
        return DBeaverIcons.getImage((DBPImage)this.getSite().getDriver().getIconBig());
    }

    @NotNull
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    private void updateGroupVisibility(@NotNull String mode) {
        if ("manual".equals(mode)) {
            UIUtils.setControlVisible((Control)this.dsnGroup, (boolean)false);
            UIUtils.setControlVisible((Control)this.manualGroup, (boolean)true);
            this.refreshDrivers();
        } else {
            UIUtils.setControlVisible((Control)this.dsnGroup, (boolean)true);
            UIUtils.setControlVisible((Control)this.manualGroup, (boolean)false);
            this.refreshDataSources();
        }
        this.getShell().layout(true, true);
        UIUtils.resizeShell((Shell)this.getShell());
        this.site.updateButtons();
    }

    private void refreshDataSources() {
        DBPConnectionConfiguration configuration = this.site.getActiveDataSource().getConnectionConfiguration();
        final String selection = this.dsnCombo.getText().isEmpty() ? configuration.getDatabaseName() : this.dsnCombo.getText();
        final JdbcOdbcUtils.DataSourceInfo[][] dataSources = new JdbcOdbcUtils.DataSourceInfo[1][];
        this.dsnCombo.setEnabled(false);
        this.refreshDsnItem.setEnabled(false);
        AbstractJob job = new AbstractJob(OdbcUIMessages.page_connection_datasource_refresh){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    monitor.beginTask(OdbcUIMessages.page_connection_datasource_refresh, 1);
                    dataSources[0] = JdbcOdbcUtils.listDataSources((JdbcOdbcUtils.DataSourceType)JdbcOdbcUtils.DataSourceType.ALL);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((String)OdbcUIMessages.page_connection_datasource_refresh_error_message, (Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIUtils.syncExec(() -> {
                    if (event.getResult() == Status.OK_STATUS) {
                        OdbcConnectionPage.this.dsnCombo.removeAll();
                        JdbcOdbcUtils.DataSourceInfo[] dataSourceInfoArray2 = dataSources[0];
                        int n = dataSourceInfoArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JdbcOdbcUtils.DataSourceInfo info = dataSourceInfoArray2[n2];
                            OdbcConnectionPage.this.dsnCombo.add(info.getName());
                            ++n2;
                        }
                        OdbcConnectionPage.this.dsnCombo.setText(CommonUtils.notEmpty((String)selection));
                        OdbcConnectionPage.this.dsnCombo.notifyListeners(13, new Event());
                    }
                    OdbcConnectionPage.this.dsnCombo.setEnabled(true);
                    OdbcConnectionPage.this.refreshDsnItem.setEnabled(true);
                });
            }
        });
        job.schedule();
    }

    private void refreshDrivers() {
        DBPConnectionConfiguration configuration = this.site.getActiveDataSource().getConnectionConfiguration();
        final String selection = this.driverCombo.getText().isEmpty() ? CommonUtils.notEmpty((String)configuration.getServerName()) : this.driverCombo.getText();
        final JdbcOdbcUtils.DriverInfo[][] drivers = new JdbcOdbcUtils.DriverInfo[1][];
        this.driverCombo.setEnabled(false);
        this.refreshDriversItem.setEnabled(false);
        AbstractJob job = new AbstractJob(OdbcUIMessages.page_connection_manual_driver_refresh){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    monitor.beginTask(OdbcUIMessages.page_connection_manual_driver_refresh, 1);
                    drivers[0] = JdbcOdbcUtils.listDrivers();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((String)OdbcUIMessages.page_connection_manual_driver_refresh_error_message, (Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIUtils.syncExec(() -> {
                    if (event.getResult() == Status.OK_STATUS) {
                        OdbcConnectionPage.this.driverCombo.removeAll();
                        JdbcOdbcUtils.DriverInfo[] driverInfoArray2 = drivers[0];
                        int n = driverInfoArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JdbcOdbcUtils.DriverInfo info = driverInfoArray2[n2];
                            OdbcConnectionPage.this.driverCombo.add(info.getDescription());
                            ++n2;
                        }
                        OdbcConnectionPage.this.driverCombo.setText(CommonUtils.notEmpty((String)selection));
                        OdbcConnectionPage.this.driverCombo.notifyListeners(13, new Event());
                    }
                    OdbcConnectionPage.this.driverCombo.setEnabled(true);
                    OdbcConnectionPage.this.refreshDriversItem.setEnabled(true);
                });
            }
        });
        job.schedule();
    }

    public void validate() {
        IWizard wizard = this.site.getWizard();
        IWizardPage currentPage = wizard.getContainer().getCurrentPage();
        DialogPage dialogPage = null;
        if (currentPage instanceof DialogPage) {
            dialogPage = (DialogPage)currentPage;
        }
        if (dialogPage != null) {
            if (this.dsnCombo.getText().isEmpty() || this.dsnCombo.getText().isBlank()) {
                dialogPage.setErrorMessage(OdbcUIMessages.page_connection_validation_odbc_not_specified);
                this.dsnCombo.setBackground(UIUtils.COLOR_VALIDATION_ERROR);
            } else if (!ArrayUtils.contains((Object[])this.dsnCombo.getItems(), (Object)this.dsnCombo.getText())) {
                dialogPage.setErrorMessage(OdbcUIMessages.page_connection_validation_odbc_not_valid);
                this.dsnCombo.setBackground(UIUtils.COLOR_VALIDATION_ERROR);
            } else {
                dialogPage.setErrorMessage(null);
                this.dsnCombo.setBackground(null);
            }
        }
        wizard.getContainer().updateMessage();
    }
}

