/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.tipoftheday;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TipsXmlHandler
extends DefaultHandler {
    private static final Log log = Log.getLog(TipsXmlHandler.class);
    private static final String TIP = "tip";
    private static final String COMMAND_REF = "commandRef";
    private static final String COMMAND_ID = "commandId";
    private final String productEdition;
    private boolean tipTagStarted;
    private boolean tipApplicable;
    private StringBuilder tipTagContent = new StringBuilder();
    private final List<String> tips = new ArrayList<String>();
    private static final List<String> HTML_TAGS = Arrays.asList("br", "b", "i", "u", "q", "a", "p", "div");
    private static final String TAG_BRACKET_BEGIN = "<";
    private static final String TAG_BRACKET_END = ">";
    private static final String SLASH = "/";

    public TipsXmlHandler() {
        this.productEdition = Platform.getProduct().getProperty("appEdition");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (HTML_TAGS.contains(qName) && this.tipTagStarted) {
            this.tipTagContent.append(TAG_BRACKET_BEGIN).append(qName);
            int i = 0;
            while (i < attributes.getLength()) {
                this.tipTagContent.append(" ").append(attributes.getQName(i)).append("=\"").append(XMLUtils.escapeXml((CharSequence)attributes.getValue(i))).append("\"");
                ++i;
            }
            this.tipTagContent.append(TAG_BRACKET_END);
        }
        if (qName.equalsIgnoreCase(TIP)) {
            this.tipTagStarted = true;
            this.tipApplicable = true;
            String tipProducts = attributes.getValue("product");
            if (!CommonUtils.isEmpty((String)tipProducts) && !CommonUtils.isEmpty((String)this.productEdition)) {
                this.tipApplicable = ArrayUtils.contains((Object[])tipProducts.split(","), (Object)this.productEdition);
            }
        } else if (qName.equalsIgnoreCase(COMMAND_REF)) {
            String commandId = attributes.getValue(COMMAND_ID);
            String description = ActionUtils.findCommandDescription((String)commandId, (IServiceLocator)PlatformUI.getWorkbench(), (boolean)false);
            if (!CommonUtils.isEmpty((String)description)) {
                this.tipTagContent.append("<b>").append(description).append("</b>");
            } else {
                log.error((Object)("No command found by id: " + commandId + ". Consider removing obsolete tip or fixing command id."));
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tipTagStarted) {
            this.tipTagContent.append(new String(ch, start, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase(TIP)) {
            if (this.tipApplicable) {
                this.tips.add(this.tipTagContent.toString());
            }
            this.tipTagStarted = false;
            this.tipApplicable = true;
            this.tipTagContent = new StringBuilder();
        }
        if (HTML_TAGS.contains(qName) && this.tipTagStarted) {
            this.tipTagContent.append(TAG_BRACKET_BEGIN).append(SLASH).append(qName).append(TAG_BRACKET_END);
        }
    }

    public List<String> getTips() {
        return this.tips;
    }
}

