/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.ClobConverter;
import com.raima.rdm.util.ClobPageInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

class ClobCacheFile {
    int pagesize;
    long fileend = 0L;
    File tmpfile;
    RandomAccessFile rfile;
    ClobConverter converter;
    Hashtable<Long, ClobPageInfo> pages;
    LinkedList<ClobPageInfo> freelist;

    public ClobCacheFile(int pagesize) throws IOException {
        this.pagesize = pagesize;
        this.converter = new ClobConverter();
        this.pages = new Hashtable();
        this.freelist = new LinkedList();
    }

    public void close() {
        try {
            if (this.rfile != null) {
                this.rfile.close();
                this.rfile = null;
            }
            if (this.tmpfile != null && !this.tmpfile.delete()) {
                System.err.println("Failed to delete temporary file: " + this.tmpfile.getName());
                this.tmpfile = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.converter = null;
        this.pages = null;
        this.freelist = null;
    }

    private void openFile() throws IOException {
        try {
            this.tmpfile = File.createTempFile("rcch", null);
            this.tmpfile.deleteOnExit();
            this.rfile = new RandomAccessFile(this.tmpfile, "rw");
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
    }

    private void releasePageLocation(ClobPageInfo pageinfo) {
        ListIterator<ClobPageInfo> it = this.freelist.listIterator(0);
        while (it.hasNext()) {
            ClobPageInfo listpageinfo = (ClobPageInfo)it.next();
            if (listpageinfo.offset + (long)listpageinfo.size == pageinfo.offset) {
                it.remove();
                pageinfo.offset = listpageinfo.offset;
                pageinfo.size += listpageinfo.size;
                continue;
            }
            if (pageinfo.offset + (long)pageinfo.size != listpageinfo.offset) continue;
            it.remove();
            pageinfo.size += listpageinfo.size;
        }
        if (pageinfo.offset + (long)pageinfo.size == this.fileend) {
            this.fileend = pageinfo.offset;
        } else {
            this.freelist.add(pageinfo);
        }
    }

    private ClobPageInfo getPageLocation(int size) {
        ClobPageInfo pageinfo = null;
        ListIterator<ClobPageInfo> it = this.freelist.listIterator(0);
        while (it.hasNext()) {
            ClobPageInfo listpageinfo = (ClobPageInfo)it.next();
            if (listpageinfo.size == size) {
                pageinfo = listpageinfo;
                it.remove();
                break;
            }
            if (listpageinfo.size <= size) continue;
            pageinfo = new ClobPageInfo(listpageinfo.offset, size);
            listpageinfo.offset += (long)size;
            listpageinfo.size -= size;
            break;
        }
        if (pageinfo == null) {
            pageinfo = new ClobPageInfo(this.fileend, size);
            this.fileend += (long)size;
        }
        return pageinfo;
    }

    void write(long pageno, char[] carr) throws IOException {
        ClobPageInfo newpageinfo = null;
        byte[] barr = this.converter.convert(carr);
        ClobPageInfo currpageinfo = this.pages.get(pageno);
        if (currpageinfo != null) {
            if (barr.length == currpageinfo.size) {
                newpageinfo = currpageinfo;
            } else {
                this.releasePageLocation(currpageinfo);
                this.pages.remove(pageno);
            }
        }
        if (newpageinfo == null) {
            newpageinfo = this.getPageLocation(barr.length);
            this.pages.put(pageno, newpageinfo);
        }
        if (this.rfile == null) {
            this.openFile();
        }
        this.rfile.seek(newpageinfo.offset);
        this.rfile.write(barr);
    }

    char[] read(long pageno) throws IOException {
        ClobPageInfo pageinfo = this.pages.get(pageno);
        if (pageinfo == null) {
            char[] carr = new char[this.pagesize];
            Arrays.fill(carr, ' ');
            return carr;
        }
        byte[] barr = new byte[pageinfo.size];
        this.rfile.seek(pageinfo.offset);
        if (this.rfile.read(barr) != pageinfo.size) {
            throw new IOException();
        }
        return this.converter.convert(barr, this.pagesize);
    }

    void truncate(long pageno) {
        Iterator<Long> it = this.pages.keySet().iterator();
        while (it.hasNext()) {
            long pno = it.next();
            if (pno < pageno) continue;
            ClobPageInfo pageinfo = this.pages.get(pno);
            this.releasePageLocation(pageinfo);
            it.remove();
        }
    }

    boolean exists(long pageno) {
        return this.pages.contains(pageno);
    }
}

