/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.BinaryConverter;
import java.io.IOException;
import java.io.InputStream;

public class CharBLOBInputStream
extends InputStream {
    InputStream is;
    String str;

    public CharBLOBInputStream(InputStream is) {
        this.is = is;
        this.str = "";
    }

    @Override
    public int available() throws IOException {
        this.validateOpen();
        return 2 * this.is.available() + this.str.length();
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is = null;
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private char nextChar() {
        char tmp = this.str.charAt(0);
        this.str = this.str.substring(1);
        return tmp;
    }

    @Override
    public int read() throws IOException {
        this.validateOpen();
        if (this.str.length() != 0) {
            return this.nextChar();
        }
        int tmp = this.is.read();
        if (tmp == -1) {
            return -1;
        }
        this.str = BinaryConverter.convertToString((byte)tmp);
        return this.nextChar();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int tmp;
        int ii;
        this.validateOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (ii = 0; ii < len && (tmp = this.read()) != -1; ++ii) {
            b[ii + off] = (byte)tmp;
        }
        if (ii == off) {
            return -1;
        }
        return ii - off;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        long ii;
        this.validateOpen();
        if (n <= 0L) {
            return 0L;
        }
        for (ii = 0L; ii < n && this.read() != -1; ++ii) {
        }
        return ii;
    }

    private void validateOpen() throws IOException {
        if (this.is == null) {
            throw new IOException("InputStream is closed");
        }
    }
}

