/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.BlobCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BlobHandler {
    private static final int PAGESIZE = 4096;
    private long blobSize;
    private BlobCache cache;

    public BlobHandler() throws IOException {
        this._init();
    }

    public BlobHandler(byte[] data) throws IOException {
        this._init();
        this.write(0L, data, 0, data.length);
    }

    public BlobHandler(InputStream is) throws IOException {
        int len;
        this._init();
        long pos = 0L;
        byte[] page = new byte[4096];
        while ((len = is.read(page)) > 0) {
            this.write(pos, page, 0, len);
            pos += (long)len;
        }
    }

    private void _init() throws IOException {
        this.cache = new BlobCache(4096);
        this.blobSize = 0L;
    }

    public void close() {
        this.cache.close();
        this.cache = null;
    }

    private int read_bytes_from_page(long pageno, int page_offset, byte[] data, int data_off, int data_len) throws IOException {
        int bytes = Math.min(data_len, 4096 - page_offset);
        byte[] page = this.cache.readPage(pageno);
        System.arraycopy(page, page_offset, data, data_off, bytes);
        return bytes;
    }

    private void validate(long pos, byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (pos < 0L || len < 0 || off + len < 0 || off + len > b.length || this.cache == null) {
            throw new IOException();
        }
    }

    public int read(long pos, byte[] b, int off, int len) throws IOException {
        int bytes;
        this.validate(pos, b, off, len);
        if (pos >= this.blobSize) {
            return -1;
        }
        if (pos + (long)len > this.blobSize) {
            len = (int)(this.blobSize - pos);
        }
        int page_offset = (int)(pos % 4096L);
        long pageno = pos / 4096L;
        for (int ii = 0; ii < len; ii += bytes) {
            bytes = this.read_bytes_from_page(pageno, page_offset, b, off, len - ii);
            off += bytes;
            ++pageno;
            page_offset = 0;
        }
        return len;
    }

    public int read(long pos, byte[] b) throws IOException {
        return this.read(pos, b, 0, b.length);
    }

    public int read(long pos) throws IOException {
        byte[] buff = new byte[1];
        int bytes = this.read(pos, buff, 0, 1);
        if (bytes != 1) {
            return -1;
        }
        return buff[0];
    }

    public long size() throws IOException {
        if (this.cache == null) {
            throw new IOException();
        }
        return this.blobSize;
    }

    public void truncate(long pos) throws IOException {
        if (pos < 0L || this.cache == null) {
            throw new IOException();
        }
        int page_offset = (int)(pos % 4096L);
        long pageno = pos / 4096L;
        if (page_offset > 0 && this.cache.exists(pageno)) {
            byte[] page = this.cache.readPage(pageno);
            Arrays.fill(page, page_offset, 4096, (byte)0);
            this.cache.writePage(pageno, page);
        }
        this.cache.truncate(pageno + 1L);
        this.blobSize = pos;
    }

    private int write_chunk_to_page(long pageno, int page_offset, byte[] data, int data_off, int data_len) throws IOException {
        int bytes = (int)Math.min((long)data_len, (long)(4096 - page_offset));
        byte[] page = this.cache.readPage(pageno);
        System.arraycopy(data, data_off, page, page_offset, bytes);
        this.cache.writePage(pageno, page);
        return bytes;
    }

    public void write(long pos, byte[] data, int off, int len) throws IOException {
        int bytes;
        this.validate(pos, data, off, len);
        int page_offset = (int)(pos % 4096L);
        long pageno = pos / 4096L;
        pageno = pos / 4096L;
        page_offset = (int)(pos % 4096L);
        for (int ii = 0; ii < len; ii += bytes) {
            bytes = this.write_chunk_to_page(pageno, page_offset, data, off, len - ii);
            off += bytes;
            ++pageno;
            page_offset = 0;
        }
        if (pos + (long)len > this.blobSize) {
            this.blobSize = pos + (long)len;
        }
    }

    public void write(long pos, byte data) throws IOException {
        byte[] barr = new byte[]{data};
        this.write(pos, barr, 0, 1);
    }

    public void write(long pos, byte[] data) throws IOException {
        this.write(pos, data, 0, data.length);
    }
}

