/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.RDMConversionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public class BinaryConverter {
    static final char[] HEXES = "0123456789ABCDEF".toCharArray();

    public static String convertToString(byte b) {
        StringBuilder hex = new StringBuilder();
        hex.append(HEXES[b >> 4 & 0xF]).append(HEXES[b & 0xF]);
        return hex.toString();
    }

    public static String convertToString(byte[] barr) {
        StringBuilder hex = new StringBuilder();
        for (byte b : barr) {
            hex.append(HEXES[b >> 4 & 0xF]).append(HEXES[b & 0xF]);
        }
        return hex.toString();
    }

    public static boolean convertToBoolean(byte b) throws RDMConversionException {
        byte[] barr = new byte[]{b};
        return BinaryConverter.convertToBoolean(barr);
    }

    public static boolean convertToBoolean(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 1).readBoolean();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte convertToByte(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 1).readByte();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static short convertToShort(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 2).readShort();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static int convertToInt(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 4).readInt();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static long convertToLong(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 8).readLong();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static float convertToFloat(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 4).readFloat();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static double convertToDouble(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 8).readDouble();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static int convertToDate(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 4).readInt();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static int convertToTime(byte[] barr) throws RDMConversionException {
        try {
            return BinaryConverter.process(barr, 4).readInt();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static int[] convertToTimestamp(byte[] barr) throws RDMConversionException {
        try {
            int[] ts = new int[2];
            DataInputStream is = BinaryConverter.process(barr, 8);
            ts[0] = is.readInt();
            ts[1] = is.readInt();
            return ts;
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static UUID convertToGuid(byte[] barr) throws RDMConversionException {
        try {
            DataInputStream is = BinaryConverter.process(barr, 16);
            long hi = is.readLong();
            long lo = is.readLong();
            return new UUID(hi, lo);
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static char[] convertToChar(byte b) {
        char[] carr = new char[]{HEXES[b >> 4 & 0xF], HEXES[b & 0xF]};
        return carr;
    }

    public static byte[] convertFromString(String str) throws RDMConversionException {
        boolean first = true;
        byte tmp = 0;
        char[] carr = str.toCharArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (char c : carr) {
            int digit = Character.digit(c, 16);
            if (digit == -1) {
                throw new RDMConversionException("Invalid binary array: invalid hexadecimal character '" + c + "'");
            }
            if (first) {
                tmp = (byte)(digit << 4);
            } else {
                baos.write(tmp | (byte)digit);
            }
            first = !first;
        }
        if (!first) {
            throw new RDMConversionException("Invalid binary array: odd number of characters");
        }
        return baos.toByteArray();
    }

    public static byte[] convertFromBoolean(boolean b) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeBoolean(b);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromByte(byte b) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeByte(b);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromShort(short s) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeShort(s);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromInt(int i) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(i);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromLong(long l) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeLong(l);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromFloat(float f) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeFloat(f);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromDouble(double d) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeDouble(d);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromDate(int i) throws RDMConversionException {
        return BinaryConverter.convertFromInt(i);
    }

    public static byte[] convertFromTime(int i) throws RDMConversionException {
        return BinaryConverter.convertFromInt(i);
    }

    public static byte[] convertFromTimestamp(int[] ts) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(ts[0]);
            dos.writeInt(ts[1]);
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    public static byte[] convertFromGuid(UUID uuid) throws RDMConversionException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeLong(uuid.getMostSignificantBits());
            dos.writeLong(uuid.getLeastSignificantBits());
            dos.flush();
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RDMConversionException(e.getMessage());
        }
    }

    private static void validate(byte[] barr, int len) throws RDMConversionException {
        if (barr.length > len) {
            throw BinaryConverter.LengthTooLong();
        }
        if (barr.length < len) {
            throw BinaryConverter.LengthTooShort();
        }
    }

    private static DataInputStream process(byte[] barr, int len) throws IOException, RDMConversionException {
        BinaryConverter.validate(barr, len);
        return new DataInputStream(new ByteArrayInputStream(barr));
    }

    private static RDMConversionException LengthTooLong() {
        return new RDMConversionException("Invalid binary array: length too long");
    }

    private static RDMConversionException LengthTooShort() {
        return new RDMConversionException("Invalid binary array: length too short");
    }
}

