/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnTypeException;
import com.raima.rdm.util.RPC;
import com.raima.rdm.util.StringInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class RSQLTimestampColumn
implements RSQLColumn {
    int[] ts;

    public RSQLTimestampColumn(int[] ts) {
        this.ts = (int[])ts.clone();
    }

    public RSQLTimestampColumn(Timestamp ts) throws RDMException {
        this.ts = DateTimeConverter.RTimestampFromTimestamp(Calendar.getInstance(TimeZone.getDefault()), ts);
    }

    public RSQLTimestampColumn(Timestamp ts, Calendar cal) throws RDMException {
        this.ts = DateTimeConverter.RTimestampFromTimestamp(cal, ts);
    }

    @Override
    public boolean isNull() throws RDMException {
        return false;
    }

    @Override
    public String getString() throws RDMException {
        return this.getTimestamp().toString();
    }

    @Override
    public byte[] getBytes() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public boolean getBoolean() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public byte getByte() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public short getShort() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public int getInt() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public long getLong() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public float getFloat() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public double getDouble() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public BigDecimal getBigDecimal() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Date getDate() throws RDMException {
        return this.getDate(Calendar.getInstance(TimeZone.getDefault()));
    }

    @Override
    public Date getDate(Calendar cal) throws RDMException {
        return DateTimeConverter.DateFromRDate(cal, this.ts[0]);
    }

    @Override
    public Time getTime() throws RDMException {
        return this.getTime(Calendar.getInstance(TimeZone.getDefault()));
    }

    @Override
    public Time getTime(Calendar cal) throws RDMException {
        return DateTimeConverter.TimeFromRTime(cal, this.ts[1]);
    }

    @Override
    public Timestamp getTimestamp() throws RDMException {
        return this.getTimestamp(Calendar.getInstance(TimeZone.getDefault()));
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws RDMException {
        return DateTimeConverter.TimestampFromRTimestamp(cal, this.ts[0], this.ts[1]);
    }

    @Override
    public UUID getUUID() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public InputStream getAsciiStream() throws RDMException {
        return new StringInputStream(this.getString());
    }

    @Override
    public InputStream getBinaryStream() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Reader getCharacterStream() throws RDMException {
        return new StringReader(this.getString());
    }

    @Override
    public Object getObject() throws RDMException {
        return this.getTimestamp();
    }

    public int getInternalDate() {
        return this.ts[0];
    }

    public int getInternalTime() {
        return this.ts[1];
    }

    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(772);
        rpc.sendInt32(this.ts[0]);
        rpc.sendInt32(this.ts[1]);
    }
}

