/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class RSQLTimeParam
extends RSQLParam {
    int t;
    Time time;

    public RSQLTimeParam() {
        super(516, (short)3);
    }

    public RSQLTimeParam(Time t) throws SQLException {
        super(516);
        this.time = (Time)t.clone();
        try {
            this.t = DateTimeConverter.RTimeFromTime(t);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLTimeParam(short t, Time tm) throws SQLException {
        super(516, t);
        this.time = (Time)tm.clone();
        try {
            this.t = DateTimeConverter.RTimeFromTime(tm);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLTimeParam(Time t, Calendar cal) throws SQLException {
        super(516);
        this.time = (Time)t.clone();
        try {
            this.t = DateTimeConverter.RTimeFromTime(cal, t);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    public RSQLTimeParam(short t, Time tm, Calendar cal) throws SQLException {
        super(516, t);
        this.time = (Time)tm.clone();
        try {
            this.t = DateTimeConverter.RTimeFromTime(cal, tm);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public String getString() throws RDMException {
        return this.time.toString();
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromTime(this.t);
    }

    @Override
    public int getInt() throws RDMException {
        return this.t;
    }

    @Override
    public long getLong() throws RDMException {
        return this.t;
    }

    @Override
    public int getTime() throws RDMException {
        return this.t;
    }

    @Override
    public int[] getTimestamp() throws RDMException {
        int[] ts = new int[]{0, this.t};
        return ts;
    }

    @Override
    public BigDecimal getDecimal() throws RDMException {
        return new BigDecimal(this.t);
    }

    @Override
    public void setInt(int i) throws RDMException {
        this.t = i;
    }

    @Override
    public void setTime(int t) throws RDMException {
        this.t = t;
    }

    @Override
    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(516);
        rpc.sendInt32(this.t);
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.t = rpc.getInt32();
    }
}

