/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLDesc;
import com.raima.rdm.sql.RSQLError;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.sql.RSQLParamDesc;
import com.raima.rdm.sql.RSQLRowArray;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.sql.RSQLTCP;
import com.raima.rdm.sql.RSQLTCPDesc;
import com.raima.rdm.sql.RSQLTCPRowArray;
import com.raima.rdm.sql.RSQLTCPRowSet;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMNoMoreDataException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.SQLWarning;

public class RSQLTCPStatement
implements RSQLStatement {
    private long handle = -1L;
    private SQLWarning warnings;
    private int type;
    private int numparms;
    private int next_parm;
    private int numcols;
    private long numrows;
    private int maxFieldSize;
    private int[] paramTypes;
    private int lineNum;
    private String fileName;
    private short needKeys;
    private int[] columnIndexes;
    private String[] columnNames;
    private int generatedKeyId;
    private String generatedKeyName;
    private long[] generatedKeys;
    private boolean cursorScrollable;
    private boolean cursorUpdateable;
    private RPC rpc;
    private RSQL rsql;
    private int errorCode;
    private String errorInfoMsg;

    public RSQLTCPStatement(RSQLTCP sql) throws RDMException {
        this(sql, false, false);
    }

    public RSQLTCPStatement(RSQLTCP sql, boolean cursorScrollable, boolean cursorUpdateable) throws RDMException {
        this.rsql = sql;
        if (sql == null) {
            throw new RDMSQLException();
        }
        this.cursorScrollable = cursorScrollable;
        this.cursorUpdateable = cursorUpdateable;
        this.rpc = sql.getRPC();
        this.sqlAllocStmt(sql.getConnHandle());
        this.warnings = null;
        this.numparms = 0;
        this.numcols = 0;
        this.numrows = 0L;
        this.generatedKeys = null;
        this.generatedKeyName = null;
        this.maxFieldSize = 0;
        this.lineNum = -1;
        this.fileName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sqlAllocStmt(long conn) throws RDMException {
        try {
            short sScrollable = this.cursorScrollable ? (short)1 : 0;
            short sUpdateable = this.cursorUpdateable ? (short)1 : 0;
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL AllocStmtJNI");
                this.rpc.sendInt64(conn);
                this.rpc.sendInt16(sScrollable);
                this.rpc.sendInt16(sUpdateable);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0) {
                    throw new RDMSQLException(this, "sqlAllocStmt()");
                }
                this.handle = this.rpc.getInt64();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmStmtClose() throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL CloseStmt");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                return this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmStmtFree() throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL FreeStmt");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                return this.rpc.getInt32();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rdmStmtPrepare(String str) throws RDMException {
        try {
            short has_fileName = 0;
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL PrepareJNI");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendString(str);
                this.rpc.sendInt32(this.lineNum);
                if (this.fileName != null) {
                    has_fileName = 1;
                }
                this.rpc.sendInt16(has_fileName);
                if (has_fileName == 1) {
                    this.rpc.sendString(this.fileName);
                }
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0) {
                    throw new RDMSQLException(this, "rdmStmtPrepare(" + str + ")");
                }
                this.type = this.rpc.getInt32();
                this.numparms = this.rpc.getInt16();
                this.numcols = this.rpc.getInt16();
                this.paramTypes = new int[this.numparms];
                for (int ii = 0; ii < this.numparms; ++ii) {
                    this.paramTypes[ii] = this.rpc.getInt32();
                }
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rdmStmtExecDirect(String str) throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL ExecDirectEx");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16(this.needKeys);
                this.rpc.sendString(str);
                this.rpc.sendInt16((short)0);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret == 10012) {
                    this.addWarning(new SQLWarning("truncation of a parameter"));
                } else if (ret != 0) {
                    throw new RDMSQLException(this, "rdmStmtExecDirect(" + str + ")");
                }
                this.type = this.rpc.getInt32();
                this.numparms = this.rpc.getInt16();
                this.numcols = this.rpc.getInt16();
                this.rpc.getInt16();
                if (this.needKeys != 0) {
                    this.getGeneratedKeyInfo();
                }
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    private void sendParams(RSQLParam[] params) throws IOException, RDMException {
        this.rpc.sendInt16((short)this.numparms);
        block17: for (int ii = 0; ii < this.numparms; ++ii) {
            this.rpc.sendInt16((short)(ii + 1));
            short mode = params[ii].getMode();
            this.rpc.sendInt32(mode);
            this.rpc.sendInt16(params[ii].isNull() ? (short)1 : 0);
            if (mode != 1) {
                this.rpc.sendInt64(0L);
            }
            if (this.paramTypes[ii] == 0 || this.paramTypes[ii] != params[ii].type) {
                params[ii].send(this.rpc);
                continue;
            }
            this.rpc.sendInt32(this.paramTypes[ii]);
            if (params[ii].isNull()) continue;
            switch (this.paramTypes[ii]) {
                case 8: 
                case 2056: {
                    this.rpc.sendString(params[ii].getString());
                    continue block17;
                }
                case 6: 
                case 2054: {
                    this.rpc.sendBytes(params[ii].getBytes());
                    continue block17;
                }
                case 32769: {
                    this.rpc.sendInt8((byte)(params[ii].getBoolean() ? 1 : 0));
                    continue block17;
                }
                case 2: {
                    this.rpc.sendInt8(params[ii].getByte());
                    continue block17;
                }
                case 258: {
                    this.rpc.sendInt16(params[ii].getShort());
                    continue block17;
                }
                case 514: {
                    this.rpc.sendInt32(params[ii].getInt());
                    continue block17;
                }
                case 7: 
                case 770: {
                    this.rpc.sendInt64(params[ii].getLong());
                    continue block17;
                }
                case 515: {
                    this.rpc.sendFloat(params[ii].getFloat());
                    continue block17;
                }
                case 771: {
                    this.rpc.sendDouble(params[ii].getDouble());
                    continue block17;
                }
                case 5: {
                    this.rpc.sendDecimal(params[ii].getDecimal());
                    continue block17;
                }
                case 260: {
                    this.rpc.sendInt32(params[ii].getDate());
                    continue block17;
                }
                case 516: {
                    this.rpc.sendInt32(params[ii].getTime());
                    continue block17;
                }
                case 772: {
                    int[] ts = params[ii].getTimestamp();
                    this.rpc.sendInt32(ts[0]);
                    this.rpc.sendInt32(ts[1]);
                    continue block17;
                }
                case 9: {
                    this.rpc.sendGuid(params[ii].getGuid());
                    continue block17;
                }
                case 4102: 
                case 4104: {
                    continue block17;
                }
                default: {
                    throw new RDMUnexpectedException("ERROR: Unexpected type in parameter");
                }
            }
        }
    }

    private void getParam(RSQLParam param) throws IOException, RDMException {
        if (this.rpc.getInt32() == 0) {
            throw new RDMUnexpectedException("ERROR: Unexpected type in parameter");
        }
        param.set(this.rpc);
    }

    private void getParams(RSQLParam[] params) throws IOException, RDMException {
        int numOutParms = this.rpc.getInt16();
        for (int ii = 0; ii < numOutParms; ++ii) {
            short mode = params[ii].getMode();
            if (mode != 2 && mode != 3) continue;
            params[ii].setNull(this.rpc.getInt16() != 0);
            if (params[ii].isNull()) continue;
            this.getParam(params[ii]);
        }
    }

    private boolean validateColumnIndex(int columnIndex) {
        boolean ret = false;
        if (this.columnIndexes == null) {
            ret = true;
        } else {
            for (int ii : this.columnIndexes) {
                if (ii != columnIndex) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private boolean validateColumnName(String columnName) {
        boolean ret = false;
        if (this.columnNames == null) {
            ret = true;
        } else {
            for (String s : this.columnNames) {
                if (!s.equals(columnName)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private void getGeneratedKeyInfo() throws IOException {
        int numKeys = this.rpc.getInt32();
        if (numKeys > 0) {
            int columnIndex = this.rpc.getInt32();
            String columnName = this.rpc.getString();
            long[] rowIds = new long[numKeys];
            for (int ii = 0; ii < rowIds.length; ++ii) {
                rowIds[ii] = this.rpc.getInt64();
            }
            if (this.validateColumnIndex(columnIndex) && this.validateColumnName(columnName)) {
                this.generatedKeyId = columnIndex;
                this.generatedKeyName = columnName;
                this.generatedKeys = rowIds;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmStmtExecute(RSQLParam[] params) throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL ExecuteEx");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16(this.needKeys);
                this.sendParams(params);
                this.rpc.flush();
                ret = this.rpc.getInt32();
                if (ret == 0 || ret == 10012) {
                    this.numcols = this.rpc.getInt16();
                    this.getParams(params);
                    if (this.needKeys != 0) {
                        this.getGeneratedKeyInfo();
                    }
                }
            }
            if (ret == 10012) {
                this.addWarning(new SQLWarning("truncation of a parameter"));
            } else if (ret != 0) {
                throw new RDMSQLException(this, "rdmStmtExecute");
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        if (ret == 10012) {
            this.addWarning(new SQLWarning("truncation of a parameter"));
        } else if (ret != 0 && ret != 10009) {
            throw new RDMSQLException(this, "rdmStmtExecute()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rdmStmtParamData() throws RDMException {
        int ret;
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL ParamData");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                ret = this.rpc.getInt32();
                if (ret == 10009) {
                    this.next_parm = this.rpc.getInt16();
                } else if (ret != 0) {
                    throw new RDMSQLException(this, "rdmStmtParamData()");
                }
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rdmStmtPutData(int type, byte[] data) throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL PutData");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt32(type);
                this.rpc.sendBytes(data);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0) {
                    throw new RDMSQLException(this, "rdmStmtPutData()");
                }
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rdmStmtGetRowCount() throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetRowCount");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0) {
                    throw new RDMSQLException(this, "rdmStmtGetRowCount()");
                }
                this.numrows = this.rpc.getInt64();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    protected RPC getRPC() {
        return this.rpc;
    }

    protected long getStmtHandle() {
        return this.handle;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getNumParms() {
        return this.numparms;
    }

    @Override
    public int getNumCols() {
        return this.numcols;
    }

    @Override
    public long getNumRows() {
        return this.numrows;
    }

    @Override
    public void close() throws RDMException {
        if (this.handle != -1L) {
            this.rdmStmtClose();
        }
    }

    @Override
    public void free() {
        if (this.handle != -1L) {
            try {
                this.rdmStmtFree();
            }
            catch (RDMException rDMException) {
                // empty catch block
            }
            this.handle = -1L;
        }
    }

    protected void finalize() {
        this.free();
    }

    private void initGeneratedKeyInfo(int autoGeneratedKeys) {
        this.needKeys = autoGeneratedKeys == 1 ? (short)1 : 0;
        this.columnIndexes = null;
        this.columnNames = null;
    }

    private void initGeneratedKeyInfo(int[] columnIndexes) {
        this.needKeys = columnIndexes != null ? (short)1 : 0;
        this.columnIndexes = columnIndexes;
        this.columnNames = null;
    }

    private void initGeneratedKeyInfo(String[] columnNames) {
        this.needKeys = columnNames != null ? (short)1 : 0;
        this.columnIndexes = null;
        this.columnNames = columnNames;
    }

    @Override
    public void execDirect(String sql, int autoGeneratedKeys) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.generatedKeys = null;
        this.generatedKeyName = null;
        this.initGeneratedKeyInfo(autoGeneratedKeys);
        this.rdmStmtExecDirect(sql);
        this.rdmStmtGetRowCount();
    }

    @Override
    public void execDirect(String sql, int[] columnIndexes) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.generatedKeys = null;
        this.generatedKeyName = null;
        this.initGeneratedKeyInfo(columnIndexes);
        this.rdmStmtExecDirect(sql);
        this.rdmStmtGetRowCount();
    }

    @Override
    public void execDirect(String sql, String[] columnNames) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.generatedKeys = null;
        this.generatedKeyName = null;
        this.initGeneratedKeyInfo(columnNames);
        this.rdmStmtExecDirect(sql);
        this.rdmStmtGetRowCount();
    }

    @Override
    public void prepare(String sql, int autoGeneratedKeys) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.generatedKeys = null;
        this.generatedKeyName = null;
        this.initGeneratedKeyInfo(autoGeneratedKeys);
        this.rdmStmtPrepare(sql);
    }

    @Override
    public void prepare(String sql, int[] columnIndexes) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.generatedKeys = null;
        this.generatedKeyName = null;
        this.initGeneratedKeyInfo(columnIndexes);
        this.rdmStmtPrepare(sql);
    }

    @Override
    public void prepare(String sql, String[] columnNames) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.generatedKeys = null;
        this.generatedKeyName = null;
        this.initGeneratedKeyInfo(columnNames);
        this.rdmStmtPrepare(sql);
    }

    @Override
    public void putData(int type, byte[] barr) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.rdmStmtPutData(type, barr);
    }

    @Override
    public void execute(RSQLParam[] params) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        if (this.rdmStmtExecute(params) == 10009) {
            while (this.rdmStmtParamData() == 10009) {
                params[this.next_parm - 1].sendDataAtExec(this);
            }
        }
        this.rdmStmtGetRowCount();
    }

    @Override
    public RSQLRowArray fetchFirst(int fetchSize) throws RDMException {
        RSQLTCPRowArray rowarray = null;
        this.warnings = null;
        try {
            rowarray = new RSQLTCPRowArray(this, 2, 0, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchAbsolute(int rowNumber, int fetchSize) throws RDMException {
        RSQLTCPRowArray rowarray = null;
        this.warnings = null;
        try {
            rowarray = new RSQLTCPRowArray(this, 4, rowNumber, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchLast() throws RDMException {
        RSQLTCPRowArray rowarray = null;
        this.warnings = null;
        try {
            rowarray = new RSQLTCPRowArray(this, 3, 0, 1, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchNext(int fetchSize) throws RDMException {
        RSQLTCPRowArray rowarray = null;
        this.warnings = null;
        try {
            rowarray = new RSQLTCPRowArray(this, 0, 0, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchPrior(int fetchSize) throws RDMException {
        RSQLTCPRowArray rowarray = null;
        this.warnings = null;
        try {
            rowarray = new RSQLTCPRowArray(this, 1, 0, 1, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    @Override
    public RSQLRowArray fetchRelative(int rowNumber, int fetchSize) throws RDMException {
        RSQLTCPRowArray rowarray = null;
        this.warnings = null;
        try {
            rowarray = new RSQLTCPRowArray(this, 5, rowNumber, fetchSize, this.maxFieldSize);
        }
        catch (RDMNoMoreDataException rDMNoMoreDataException) {
            // empty catch block
        }
        return rowarray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getCursorStatus() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetCursorStatus");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0) {
                    throw new RDMSQLException(this, "rdmStmtGetCursorStatus()");
                }
                return this.rpc.getInt16();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    @Override
    public int getNumGeneratedKeys() {
        int numKeys = 0;
        if (this.generatedKeys != null) {
            numKeys = Array.getLength(this.generatedKeys);
        }
        return numKeys;
    }

    @Override
    public RSQLRowSet getGeneratedKey(int row) throws RDMException {
        RSQLTCPRowSet rs = null;
        int numKeys = 0;
        if (this.generatedKeys != null) {
            numKeys = Array.getLength(this.generatedKeys);
        }
        if (row < numKeys) {
            rs = new RSQLTCPRowSet(this, this.generatedKeys[row], this.maxFieldSize);
        }
        return rs;
    }

    @Override
    public String getGeneratedKeyName() {
        return this.generatedKeyName;
    }

    @Override
    public RSQLDesc describeCol(int col) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return new RSQLTCPDesc(this, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RSQLParamDesc describeParam(int param) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        try {
            short nullable;
            int len;
            int type;
            int parType;
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetParameterDescr");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16((short)param);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0) {
                    throw new RDMSQLException(this, "rdmStmtGetParameterDescr()");
                }
                parType = this.rpc.getInt32();
                type = this.rpc.getInt32();
                len = this.rpc.getInt32();
                nullable = this.rpc.getInt16();
            }
            return new RSQLParamDesc(parType, type, len, nullable > 0);
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    @Override
    public String errorInfo() throws RDMException {
        String str = null;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return str;
    }

    @Override
    public String getCursorName() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParamName(int param) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetParamName");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16((short)param);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0 && ret != 10012) {
                    throw new RDMSQLException(this, "rdmStmtGetParamName()");
                }
                return this.rpc.getString();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    @Override
    public void setCursorName(String name) throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rdmStmtGetMoreResults() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        try {
            int ret;
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL MoreResults");
                this.rpc.sendInt64(this.handle);
                this.rpc.flush();
                ret = this.rpc.getInt32();
                if (ret != 0 && ret != 10009) {
                    throw new RDMSQLException(this, "rdmStmtMoreResults()");
                }
                if (ret == 0) {
                    this.numcols = this.rpc.getInt16();
                }
            }
            return ret == 0;
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    @Override
    public boolean getMoreResults() throws RDMException {
        boolean ret = this.rdmStmtGetMoreResults();
        if (!ret) {
            this.rdmStmtGetRowCount();
        }
        return ret;
    }

    @Override
    public void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    protected void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public int seqno() throws RDMException {
        int seq = 0;
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return seq;
    }

    @Override
    public RSQLError getErrorMsg(int errno) throws RDMException {
        return this.rsql.getErrorMsg(errno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getErrorInfo() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        try {
            int ret;
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetErrorInfo");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt64(1024L);
                this.rpc.flush();
                ret = this.rpc.getInt32();
            }
            if (ret != 0 && ret != 10012) {
                throw new RDMSQLException(ret);
            }
            this.errorCode = this.rpc.getInt32();
            this.errorInfoMsg = this.rpc.getString();
        }
        catch (IOException e) {
            return -15045;
        }
        return this.errorCode;
    }

    @Override
    public String getErrorInfoMsg() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.errorInfoMsg;
    }
}

