/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQLBinaryColumn;
import com.raima.rdm.sql.RSQLBlobColumn;
import com.raima.rdm.sql.RSQLBoolColumn;
import com.raima.rdm.sql.RSQLByteColumn;
import com.raima.rdm.sql.RSQLClobColumn;
import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.sql.RSQLDateColumn;
import com.raima.rdm.sql.RSQLDecimalColumn;
import com.raima.rdm.sql.RSQLDoubleColumn;
import com.raima.rdm.sql.RSQLFloatColumn;
import com.raima.rdm.sql.RSQLGuidColumn;
import com.raima.rdm.sql.RSQLIntColumn;
import com.raima.rdm.sql.RSQLLongColumn;
import com.raima.rdm.sql.RSQLNullColumn;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.sql.RSQLShortColumn;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.sql.RSQLStringColumn;
import com.raima.rdm.sql.RSQLTCPStatement;
import com.raima.rdm.sql.RSQLTimeColumn;
import com.raima.rdm.sql.RSQLTimestampColumn;
import com.raima.rdm.sql.RSQLUByteColumn;
import com.raima.rdm.sql.RSQLUIntColumn;
import com.raima.rdm.sql.RSQLUShortColumn;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;

public class RSQLTCPRowSet
implements RSQLRowSet {
    private int numcols;
    private long handle;
    private RSQLColumn[] columns;
    private RPC rpc;
    private ByteArrayInputStream chunk;
    private int currCol;
    private short is_null;
    private RSQLStatement stmt;
    private int row;
    private short uno;
    private long objId;
    private byte[] objIdLong;
    private int objIdSize;

    public RSQLTCPRowSet(RSQLTCPStatement stmt, int row, short uno, long objId, int objIdSize, int maxFieldSize) throws RDMException {
        this.stmt = stmt;
        this.row = row;
        this.uno = uno;
        this.objId = objId;
        this.objIdLong = null;
        this.objIdSize = objIdSize;
        if (stmt == null) {
            throw new RDMSQLException();
        }
        this.rpc = stmt.getRPC();
        this.handle = stmt.getStmtHandle();
        this.numcols = stmt.getNumCols();
        this.columns = new RSQLColumn[this.numcols];
        this.chunk = null;
        this.currCol = -1;
        try {
            for (short ii = 0; ii < this.numcols; ii = (short)(ii + 1)) {
                this.columns[ii] = this.createColumn(ii, maxFieldSize);
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O Error: " + e.getMessage());
        }
    }

    public RSQLTCPRowSet(RSQLTCPStatement stmt, int row, short uno, byte[] objIdLong, int objIdSize, int maxFieldSize) throws RDMException {
        this.stmt = stmt;
        this.row = row;
        this.uno = uno;
        this.objId = 0L;
        this.objIdLong = objIdLong;
        this.objIdSize = objIdSize;
        if (stmt == null) {
            throw new RDMSQLException();
        }
        this.rpc = stmt.getRPC();
        this.handle = stmt.getStmtHandle();
        this.numcols = stmt.getNumCols();
        this.columns = new RSQLColumn[this.numcols];
        this.chunk = null;
        this.currCol = -1;
        try {
            for (short ii = 0; ii < this.numcols; ii = (short)(ii + 1)) {
                this.columns[ii] = this.createColumn(ii, maxFieldSize);
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O Error: " + e.getMessage());
        }
    }

    public RSQLTCPRowSet(RSQLTCPStatement stmt, long generatedKey, int maxFieldSize) throws RDMException {
        this.stmt = stmt;
        if (stmt == null) {
            throw new RDMSQLException();
        }
        this.rpc = stmt.getRPC();
        this.handle = stmt.getStmtHandle();
        this.numcols = 1;
        this.columns = new RSQLColumn[this.numcols];
        this.chunk = null;
        this.currCol = -1;
        this.columns[0] = new RSQLLongColumn(generatedKey);
    }

    private int[] readTimestamp() throws IOException {
        int[] ts = new int[]{this.rpc.getInt32(), this.rpc.getInt32()};
        return ts;
    }

    private RSQLColumn createColumn(short col, int maxFieldSize) throws IOException, RDMException {
        RSQLColumn rcol = null;
        long elts = 0L;
        this.is_null = this.rpc.getInt16();
        if (this.is_null == 1) {
            return new RSQLNullColumn();
        }
        switch (this.rpc.getInt32()) {
            case 8: 
            case 2056: {
                rcol = new RSQLStringColumn(this.rpc.getString(), maxFieldSize);
                break;
            }
            case 6: 
            case 2054: {
                rcol = new RSQLBinaryColumn(this.rpc.getBytes(), maxFieldSize);
                break;
            }
            case 32769: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    byte val = this.rpc.getInt8();
                    if (ii != 0L) continue;
                    rcol = new RSQLBoolColumn(val != 0);
                }
                break;
            }
            case 2: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    byte val = this.rpc.getInt8();
                    if (ii != 0L) continue;
                    rcol = new RSQLByteColumn(val);
                }
                break;
            }
            case 32770: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    byte val = this.rpc.getInt8();
                    if (ii != 0L) continue;
                    rcol = new RSQLUByteColumn(val);
                }
                break;
            }
            case 258: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    short val = this.rpc.getInt16();
                    if (ii != 0L) continue;
                    rcol = new RSQLShortColumn(val);
                }
                break;
            }
            case 33026: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    short val = this.rpc.getInt16();
                    if (ii != 0L) continue;
                    rcol = new RSQLUShortColumn(val);
                }
                break;
            }
            case 514: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    int val = this.rpc.getInt32();
                    if (ii != 0L) continue;
                    rcol = new RSQLIntColumn(val);
                }
                break;
            }
            case 33282: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    long val = this.rpc.getInt32();
                    if (ii != 0L) continue;
                    rcol = new RSQLUIntColumn(val);
                }
                break;
            }
            case 7: {
                rcol = new RSQLLongColumn(this.rpc.getInt64());
                break;
            }
            case 770: 
            case 33538: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    long val = this.rpc.getInt64();
                    if (ii != 0L) continue;
                    rcol = new RSQLLongColumn(val);
                }
                break;
            }
            case 515: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    float val = this.rpc.getFloat();
                    if (ii != 0L) continue;
                    rcol = new RSQLFloatColumn(val);
                }
                break;
            }
            case 771: {
                elts = this.rpc.getInt32();
                if (elts == 0L) {
                    ++elts;
                }
                for (long ii = 0L; ii < elts; ++ii) {
                    double val = this.rpc.getDouble();
                    if (ii != 0L) continue;
                    rcol = new RSQLDoubleColumn(val);
                }
                break;
            }
            case 260: {
                rcol = new RSQLDateColumn(this.rpc.getInt32());
                break;
            }
            case 516: {
                rcol = new RSQLTimeColumn(this.rpc.getInt32());
                break;
            }
            case 1028: {
                rcol = new RSQLTimeColumn(this.rpc.getInt32());
                this.rpc.getInt16();
                break;
            }
            case 772: {
                rcol = new RSQLTimestampColumn(this.readTimestamp());
                break;
            }
            case 1284: {
                rcol = new RSQLTimestampColumn(this.readTimestamp());
                this.rpc.getInt16();
                break;
            }
            case 5: {
                rcol = new RSQLDecimalColumn(this.rpc.getDecimal());
                break;
            }
            case 9: {
                rcol = new RSQLGuidColumn(this.rpc.getGuid());
                break;
            }
            case 4102: {
                rcol = new RSQLBlobColumn(this, col + 1, maxFieldSize);
                break;
            }
            case 4104: {
                rcol = new RSQLClobColumn(this, col + 1, maxFieldSize);
            }
        }
        return rcol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream getDataChunk(int colno) throws RDMException {
        int err;
        try {
            int type = 0;
            byte[] data = null;
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetData");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16((short)colno);
                this.rpc.sendInt8((byte)this.uno);
                if (this.uno != -1) {
                    if (this.objIdSize <= 8) {
                        this.rpc.sendInt32(this.objIdSize);
                        this.rpc.sendInt64(this.objId);
                    } else {
                        this.rpc.sendBytes(this.objIdLong);
                    }
                }
                this.rpc.sendInt64(1024L);
                this.rpc.flush();
                err = this.rpc.getInt32();
                if (err == 0) {
                    type = this.rpc.getInt32();
                    data = this.rpc.getByteArray((int)this.rpc.getInt64());
                }
            }
            if (err == 0) {
                this.currCol = colno;
                return new ByteArrayInputStream(data);
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O Error: " + e.getMessage());
        }
        if (err != 10009) {
            throw new RDMSQLException(this.stmt, "rdmStmtGetData()");
        }
        return null;
    }

    @Override
    public int getData(int colno, byte[] bytes) throws RDMException {
        int numbytes = 0;
        if (this.currCol != colno) {
            this.chunk = null;
        }
        if (this.chunk == null) {
            this.chunk = this.getDataChunk(colno);
        }
        while (numbytes < bytes.length && this.chunk != null) {
            int bytesread = this.chunk.read(bytes, numbytes, bytes.length - numbytes);
            if (bytesread == 0 || bytesread == -1) {
                this.chunk = this.getDataChunk(colno);
                continue;
            }
            numbytes += bytesread;
        }
        return numbytes;
    }

    @Override
    public int getNumCols() {
        return this.numcols;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public boolean isNull(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].isNull();
    }

    private void validateCol(int col) throws RDMException {
        if (col < 1 || col > this.numcols) {
            throw new RDMInvalidColumnException();
        }
    }

    @Override
    public InputStream getAsciiStream(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getAsciiStream();
    }

    @Override
    public InputStream getBinaryStream(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBinaryStream();
    }

    @Override
    public boolean getBoolean(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBoolean();
    }

    @Override
    public byte getByte(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getByte();
    }

    @Override
    public byte[] getBytes(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBytes();
    }

    @Override
    public Reader getCharacterStream(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getCharacterStream();
    }

    @Override
    public short getShort(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getShort();
    }

    @Override
    public int getInt(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getInt();
    }

    @Override
    public long getLong(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getLong();
    }

    @Override
    public float getFloat(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getFloat();
    }

    @Override
    public double getDouble(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getBigDecimal();
    }

    @Override
    public Date getDate(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getDate();
    }

    @Override
    public Date getDate(int col, Calendar cal) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getDate(cal);
    }

    @Override
    public Time getTime(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTime();
    }

    @Override
    public Time getTime(int col, Calendar cal) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTimestamp();
    }

    @Override
    public Timestamp getTimestamp(int col, Calendar cal) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getTimestamp(cal);
    }

    @Override
    public UUID getUUID(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getUUID();
    }

    @Override
    public String getString(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getString();
    }

    @Override
    public Object getObject(int col) throws RDMException {
        this.validateCol(col);
        return this.columns[col - 1].getObject();
    }
}

