/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQLDesc;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.sql.RSQLTCPStatement;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import java.io.IOException;

public class RSQLTCPDesc
implements RSQLDesc {
    short num;
    int type;
    short scale;
    boolean nullable;
    int elts;
    int width;
    int octet_len;
    short prec;
    long handle;
    RPC rpc;
    String name;
    String table;
    String db;
    RSQLStatement stmt;

    public RSQLTCPDesc(RSQLTCPStatement stmt, int num) throws RDMException {
        this.stmt = stmt;
        this.handle = stmt.getStmtHandle();
        this.rpc = stmt.getRPC();
        this.num = (short)num;
        this.table = null;
        String name = stmt.getGeneratedKeyName();
        if (name != null && num == 1) {
            this.setName(name);
        } else {
            this.rdmStmtGetColDescr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rdmStmtGetColDescr() throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetColDescr");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16(this.num);
                this.rpc.sendInt16((short)1);
                this.rpc.flush();
                int ret = this.rpc.getInt32();
                if (ret != 0) {
                    throw new RDMSQLException(this.stmt, "rdmStmtGetColDescr()");
                }
                this.name = this.rpc.getString();
                this.type = this.rpc.getInt32();
                this.elts = this.rpc.getInt16();
                this.width = this.rpc.getInt16();
                this.octet_len = this.rpc.getInt32();
                this.prec = this.rpc.getInt16();
                this.scale = this.rpc.getInt16();
                this.nullable = this.rpc.getInt16() != 0;
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    @Override
    public short getNum() {
        return this.num;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public short getScale() {
        return this.scale;
    }

    @Override
    public short getPrecision() {
        return this.prec;
    }

    @Override
    public boolean getNullable() {
        return this.nullable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rdmStmtGetTableName() throws RDMException {
        try {
            RPC rPC = this.rpc;
            synchronized (rPC) {
                this.rpc.sendFcnID("SQL GetTableName");
                this.rpc.sendInt64(this.handle);
                this.rpc.sendInt16(this.num);
                this.rpc.flush();
                if (this.rpc.getInt32() != 0) {
                    throw new RDMSQLException(this.stmt, "rdmStmtGetTableName()");
                }
                this.db = this.rpc.getString();
                this.table = this.rpc.getString();
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException("I/O error", e);
        }
    }

    @Override
    public String getTable() throws RDMException {
        if (this.table == null) {
            this.rdmStmtGetTableName();
        }
        return this.table;
    }

    @Override
    public String getDbase() throws RDMException {
        if (this.table == null) {
            this.rdmStmtGetTableName();
        }
        return this.db;
    }

    @Override
    public String getCatalog() throws RDMException {
        return "";
    }

    protected void setName(String name) {
        this.name = name;
    }
}

