/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLJNIRowSet;
import com.raima.rdm.sql.RSQLJNIStatement;
import com.raima.rdm.sql.RSQLRowArray;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMNoMoreDataException;
import java.sql.SQLWarning;

public class RSQLJNIRowArray
implements RSQLRowArray {
    private RSQLJNIStatement stmt;
    private RSQLJNIRowSet[] rowsets = null;
    private int fetchedRows = 0;

    private native int rdmStmtFetchScroll(long var1, int var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSQLJNIRowArray(RSQLJNIStatement stmt, int fetchOrientation, int rowNumber, int fetchSize, int maxFieldSize) throws RDMException {
        try {
            int ret;
            if (stmt == null) {
                throw new RDMSQLException();
            }
            this.stmt = stmt;
            RSQL rSQL = stmt.getRsql();
            synchronized (rSQL) {
                long handle = stmt.getStmtHandle();
                ret = this.rdmStmtFetchScroll(handle, fetchOrientation, rowNumber, fetchSize, maxFieldSize);
            }
            if (ret == 10012) {
                stmt.addWarning(new SQLWarning("a column was truncated"));
            } else {
                if (ret == 10009) {
                    throw new RDMNoMoreDataException();
                }
                if (ret != 0) {
                    throw new RDMSQLException(stmt, "rdmStmtFetchScroll");
                }
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    @Override
    public RSQLRowSet getRowSet(int index) {
        return this.rowsets[index];
    }

    @Override
    public int getFetchedRows() {
        return this.fetchedRows;
    }

    private RDMException handleJNIError(Error e) {
        e.printStackTrace(System.err);
        return new RDMSQLException();
    }

    protected void setBlob(int row, int col, int maxFieldSize) {
        this.rowsets[row].setBlob(col, maxFieldSize);
    }

    protected void setBool(int row, int col, boolean b) {
        this.rowsets[row].setBool(col, b);
    }

    protected void setByte(int row, int col, byte b) {
        this.rowsets[row].setByte(col, b);
    }

    protected void setBytes(int row, int col, byte[] b, int maxFieldSize) {
        this.rowsets[row].setBytes(col, b, maxFieldSize);
    }

    protected void setClob(int row, int col, int maxFieldSize) {
        this.rowsets[row].setClob(col, maxFieldSize);
    }

    protected void setDate(int row, int col, int i) {
        this.rowsets[row].setDate(col, i);
    }

    protected void setDecimal(int row, int col, String str) {
        this.rowsets[row].setDecimal(col, str);
    }

    protected void setDouble(int row, int col, double d) {
        this.rowsets[row].setDouble(col, d);
    }

    protected void setFetchedRows(int numrows, short uno, long objId) throws RDMException {
        if (this.rowsets == null && numrows > 0) {
            this.rowsets = new RSQLJNIRowSet[numrows];
            for (int ii = 0; ii < numrows; ++ii) {
                this.rowsets[ii] = new RSQLJNIRowSet(this.stmt, ii, uno, objId);
            }
        }
        this.fetchedRows = numrows;
    }

    protected void setFloat(int row, int col, float f) {
        this.rowsets[row].setFloat(col, f);
    }

    protected void setGuid(int row, int col, String str) {
        this.rowsets[row].setGuid(col, str);
    }

    protected void setInt(int row, int col, int i) {
        this.rowsets[row].setInt(col, i);
    }

    protected void setLong(int row, int col, long l) {
        this.rowsets[row].setLong(col, l);
    }

    protected void setNClob(int row, int col, int maxFieldSize) {
        this.rowsets[row].setNClob(col, maxFieldSize);
    }

    protected void setNull(int row, int col) {
        this.rowsets[row].setNull(col);
    }

    protected void setShort(int row, int col, short s) {
        this.rowsets[row].setShort(col, s);
    }

    protected void setString(int row, int col, String str, int maxFieldSize) {
        this.rowsets[row].setString(col, str, maxFieldSize);
    }

    protected void setTime(int row, int col, int i) {
        this.rowsets[row].setTime(col, i);
    }

    protected void setTimestamp(int row, int col, int[] ts) {
        this.rowsets[row].setTimestamp(col, ts);
    }
}

