/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;

public class RSQLDoubleParam
extends RSQLParam {
    double d;

    public RSQLDoubleParam() {
        super(771, (short)3);
    }

    public RSQLDoubleParam(double d) {
        super(771);
        this.d = d;
    }

    public RSQLDoubleParam(short t, double d) {
        super(771, t);
        this.d = d;
    }

    @Override
    public String getString() throws RDMException {
        return Double.toString(this.d);
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromDouble(this.d);
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return this.d != 0.0;
    }

    @Override
    public byte getByte() throws RDMException {
        return (byte)this.d;
    }

    @Override
    public short getShort() throws RDMException {
        return (short)this.d;
    }

    @Override
    public int getInt() throws RDMException {
        return (int)this.d;
    }

    @Override
    public long getLong() throws RDMException {
        return (long)this.d;
    }

    @Override
    public float getFloat() throws RDMException {
        return (float)this.d;
    }

    @Override
    public double getDouble() throws RDMException {
        return this.d;
    }

    @Override
    public BigDecimal getDecimal() throws RDMException {
        return new BigDecimal(this.d, new MathContext(32));
    }

    @Override
    public void setDouble(double d) throws RDMException {
        this.d = d;
    }

    @Override
    public void setFloat(float f) throws RDMException {
        this.d = f;
    }

    @Override
    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(771);
        rpc.sendDouble(this.d);
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.d = rpc.getDouble();
    }
}

